package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netflix.loadbalancer.RetryRule;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationPlan;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MonitorFanIndicatorMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.RegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationPlanMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ESEquipmentsDTO;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IndicatorsDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SocialContributionDto;
//import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
//import com.yeejoin.amos.component.influxdb.InfluxdbUtil;
import io.swagger.models.auth.In;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.io.File;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Async
@Service
public class MonitoringServiceIMQTTmpl {
    //社会贡献Cron表达式
    private final String totalSocialContributionCron = "0 0/1 * * * *";
    //区域完成情况 Cron表达式
    private final String completionOfPowerIndicatorsByProvinceNameCron = "0/30 * * * * *";
    //风电站状态Cron表达式
    private final String fanStatusStatisticsCron = "0/30 0 * * * *";
    //风电站总览Cron表达式
    private final String fanstationOverviewCron = "0/30 * * * * *";
    //风电站功率曲线图表达式
    private final String fanStationPowerBightCron = "0/30 * * * * *";
    //风机状态列表Cron表达式
    private final String fanStatusListCron = "0/30 * * * * *";
    //风机实时数据Cron表达式
    private final String fanCurrentDataCron = "0 0/1 * * * *";
    Logger logger = LoggerFactory.getLogger(MonitoringServiceIMQTTmpl.class);
    @Autowired
    StationPlanMapper stationPlanMapper;
    /**
     * 场站mapper
     */
    @Autowired
    StationBasicMapper stationBasicMapper;
    @Autowired
    CommonServiceImpl commonServiceImpl;
    @Autowired
    RegionMapper regionMapper;
    @Autowired
    EmqKeeper emqKeeper;
    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicator;
    @Autowired
    CommonServiceImpl commonService;
//    @Autowired
//    InfluxDButils influxDButils;
    @Autowired
    MonitoringServiceImpl monitoringServiceImpl;
    @Value("${fan.statuts.stattuspath}")
    private String fanStatusImagePathPrefix;
    @Autowired
    private MonitorFanIndicatorMapper monitorFanIndicatorregionMapper;


    /**
     * 社会贡献定时消息发送  1分钟推送一次
     */
    @Scheduled(cron = totalSocialContributionCron)
    public void getTotalSocialContribution() {
        logger.error("--------------------------社会贡献定时执行----------------------------------------------");
        List<SocialContributionDto> socialContributionDtoList = new ArrayList<>();
        //定义社会贡献列表
        AtomicReference<Double> totalSocialContribution = new AtomicReference<>(0.0);
        //获取所有网关id不为空的数据
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("fan_gateway_id"));
        stationBasicList.forEach(stationBasic -> {
            if ("FDZ".equals(stationBasic.getStationType())) {
                Map<String, List<String>> queryCondtion = new HashMap<>();
                queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("日发电量", "月发电量", "年发电量"));
                queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
                totalSocialContribution.updateAndGet(v -> v + commonServiceImpl.getTotalByIndicatior(stationBasic.getFanGatewayId(), "年发电量"));
            } else {
                Map<String, List<String>> queryCondtion = new HashMap<>();
                queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList(CommonConstans.taiHeGenIndicatorYear));
                queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getBoosterGatewayId()));

                List<ESEquipments> result = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
                totalSocialContribution.updateAndGet(v -> v + commonServiceImpl.getSumByEquipmentIndxName(result, CommonConstans.taiHeGenIndicatorYear));
            }
        });
        Page<SocialContributionDto> socialContributionDtoPage = commonService.getSocialContributionDtoList(totalSocialContribution.get());
        try {
            emqKeeper.getMqttClient().publish("socialcontribution_topic", JSON.toJSON(socialContributionDtoPage).toString().getBytes("UTF-8"), 1, true);
            logger.info("-----------------发送社会贡献消息=================== 成功！" + JSON.toJSONString(socialContributionDtoPage));
        } catch (Exception exception) {
            logger.error("-----------------发送社会贡献消息=================== 失败！");
        }
    }

    /**
     * 区域实时数据消息推送-30s一次
     */
    @Scheduled(cron = completionOfPowerIndicatorsByProvinceNameCron)
    public void getCompletionOfPowerIndicatorsByProvinceName() {
        Page<SocialContributionDto> socialContributionDtoPage = new Page<SocialContributionDto>();
        logger.error("--------------------------区域实时数据消息开始发送----------------------------------------------");
        List<SocialContributionDto> socialContributionDtoList = new ArrayList<>();
        Region region = this.regionMapper.selectOne(new QueryWrapper<Region>().eq("level", 1).eq("region_name", "江西省"));
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().like("belong_area", region.getRegionCode()).isNotNull("fan_gateway_id"));
        int year = Calendar.getInstance().get(Calendar.YEAR);
        List<Long> fdz = stationBasicList.stream().map(StationBasic::getSequenceNbr).collect(Collectors.toList());
        LambdaQueryWrapper<StationPlan> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(StationPlan::getYear, String.valueOf(year));
        queryWrapper.in(StationPlan::getStationBasicId, fdz);
        List<StationPlan> fdzPlans = stationPlanMapper.selectList(queryWrapper);
        double value = fdzPlans.stream().mapToDouble(StationPlan::getValue).sum();

        //日发电量
        AtomicReference<Double> dailyPower = new AtomicReference<>(0.0);
        //月发电量
        AtomicReference<Double> monthlyPower = new AtomicReference<>(0.0);
        //年发电量
        AtomicReference<Double> annualPower = new AtomicReference<>(0.0);
        //年发电量完成比例
        stationBasicList.forEach(stationBasic -> {
            if ("FDZ".equals(stationBasic.getStationType())) {
                Map<String, List<String>> queryCondtion = new HashMap<>();
                queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("有功功率", "日发电量", "月发电量", "年发电量"));
                queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
                List<ESEquipments> result = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
                dailyPower.updateAndGet(v -> v + monitoringServiceImpl.keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "日发电量")));
                monthlyPower.updateAndGet(v -> v + monitoringServiceImpl.keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "月发电量")));
                annualPower.updateAndGet(v -> v + monitoringServiceImpl.keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, "年发电量")));
            } else {
                Map<String, List<String>> queryCondtion = new HashMap<>();
                queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, CommonConstans.taiHeGenIndicator);
                queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getBoosterGatewayId()));
                List<ESEquipments> result = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
                dailyPower.updateAndGet(v -> v + monitoringServiceImpl.keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, CommonConstans.taiHeGenIndicatorDay) ));
                monthlyPower.updateAndGet(v -> v + monitoringServiceImpl.keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, CommonConstans.taiHeGenIndicatorMonth)));
                annualPower.updateAndGet(v -> v + monitoringServiceImpl.keepFourdecimalPlaces(commonServiceImpl.getSumByEquipmentIndxName(result, CommonConstans.taiHeGenIndicatorYear) ));
            }
        });

        String completionRatio = String.format("%.2f", (annualPower.get() * 100) / value);
        SocialContributionDto dailyPowerdto = new SocialContributionDto();
        dailyPowerdto.setTitle(String.format(CommonConstans.Fourdecimalplaces, dailyPower.get()));
        dailyPowerdto.setUnit("万kWh");
        SocialContributionDto monthlyPowerdto = new SocialContributionDto();
        monthlyPowerdto.setTitle(String.format(CommonConstans.Fourdecimalplaces, monthlyPower.get()));
        monthlyPowerdto.setUnit("万kWh");
        SocialContributionDto annualPowerdto = new SocialContributionDto();
        annualPowerdto.setTitle(String.format(CommonConstans.Fourdecimalplaces, annualPower.get()));
        annualPowerdto.setUnit("万kWh");
        SocialContributionDto completionRatioDto = new SocialContributionDto();
        completionRatioDto.setTitle(completionRatio);
        completionRatioDto.setUnit("%");
        SocialContributionDto useHoursDto = new SocialContributionDto();
        useHoursDto.setTitle(String.format("%.2f", (annualPower.get() / Double.valueOf(monitoringServiceImpl.getInstallCapity(stationBasicList)))));
        useHoursDto.setUnit("h");
        socialContributionDtoList.add(dailyPowerdto);
        socialContributionDtoList.add(monthlyPowerdto);
        socialContributionDtoList.add(annualPowerdto);
        socialContributionDtoList.add(completionRatioDto);
        socialContributionDtoList.add(useHoursDto);
        socialContributionDtoPage.setRecords(socialContributionDtoList);
        socialContributionDtoPage.setTotal(100);
        socialContributionDtoPage.setCurrent(1);
        try {
//            emqKeeper.getMqttClient().publish("completionofpowerindicator_topic", JSON.toJSON(socialContributionDtoPage).toString().getBytes("UTF-8"), 1, true);
            logger.info("-----------------发送区域实时生产数据消息=================== 成功！" + JSON.toJSONString(socialContributionDtoPage));
        } catch (Exception exception) {
            logger.error("-----------------发送区域实时生产数据消息=================== 失败！");
        }
    }

    /**
     * 实时推送-风电站风机状态统计数据
     */
    @Scheduled(cron = fanStatusStatisticsCron)
    public void getFanStatusStatistics() {
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("sequence_nbr").eq("station_type", "FDZ"));
        stationBasicList.forEach(stationBasic -> {
            List<IndexDto> fanStatusStatistics = monitorFanIndicator.getFanStatusStatistics(String.valueOf(stationBasic.getSequenceNbr()));
            Page<IndexDto> page = new Page<>(1, 10);
            List<IndexDto> collect = fanStatusStatistics.stream()
                    .limit(10)
                    .collect(Collectors.toList());
            page.setTotal(fanStatusStatistics.size());
            page.setRecords(collect);
            try {
                emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_fanStatusStatistics_topic", JSON.toJSON(page).toString().getBytes("UTF-8"), 1, true);
                logger.info("-----------------发送风电站风机状态数据消息=================== 成功！" + JSON.toJSONString(page));
            } catch (Exception exception) {
                logger.error("-----------------发送风电站风机状态数据消息=================== 失败！");
            }
        });
    }

    /**
     * 实时推送-风电站风场总概览
     */
//    @Scheduled(cron = fanstationOverviewCron)
//    public void getFanstationOverview() {
//        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("sequence_nbr").eq("station_type", "FDZ"));
//        stationBasicList.forEach(stationBasic -> {
//            String gatewayId = stationBasic.getFanGatewayId();
//            String[] sumColumns = new String[]{"日发电量", "月发电量", "年发电量"};
//            String[] avgColumns = new String[]{"有功功率", "瞬时风速"};
//            List<String> columnList = Arrays.asList(sumColumns);
//            List<String> columnLists = Arrays.asList(avgColumns);
//            Map<String, Object> columnMap = new HashMap<>();
//            for (String column : columnList) {
//                Double result = commonService.getTotalByIndicatior(gatewayId, column);
//                columnMap.put(column, result);
//            }
//            for (String column : columnLists) {
//                Double result = commonService.getAvgvalueByIndicatior(gatewayId, column);
//                columnMap.put(column, result);
//            }
//            String num = monitorFanIndicator.getFJCount(gatewayId);
//            columnMap.put("风机台数", num);
//            Double capacityl = commonService.getStationCapactityByStationWerks(stationBasic.getStationNumber());
//            columnMap.put("装机容量", capacityl);
//            List<Map<String, Object>> objects = new ArrayList<>();
//            Map<String, Object> data = new HashMap<>();
//            data.put("title", Float.valueOf(columnMap.get("装机容量").toString()));
//            objects.add(data);
//            Map<String, Object> data1 = new HashMap<>();
//            data1.put("title", Float.valueOf(columnMap.get("日发电量").toString()));
//            objects.add(data1);
//            Map<String, Object> data2 = new HashMap<>();
//            data2.put("title", columnMap.get("风机台数").toString().replace(".0", ""));
//            objects.add(data2);
//            Map<String, Object> data3 = new HashMap<>();
//            data3.put("title", Float.valueOf(columnMap.get("月发电量").toString()));
//            objects.add(data3);
//            Map<String, Object> data4 = new HashMap<>();
//            data4.put("title", Float.valueOf(columnMap.get("瞬时风速").toString()));
//            objects.add(data4);
//            Map<String, Object> data5 = new HashMap<>();
//            data5.put("title", Float.valueOf(columnMap.get("年发电量").toString()));
//            objects.add(data5);
//            Map<String, Object> data6 = new HashMap<>();
//            data6.put("title", Float.valueOf(columnMap.get("有功功率").toString()));
//            objects.add(data6);
//            Map<String, Object> data7 = new HashMap<>();
//            data7.put("title", 0.00);
//            objects.add(data7);
//            IPage<Map<String, Object>> result = new Page<>();
//            result.setRecords(objects);
//            result.setCurrent(1);
//            result.setTotal(objects.size());
//            try {
//                emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_fanStationOverview_topic", JSON.toJSON(result).toString().getBytes("UTF-8"), 1, true);
//                logger.info("-----------------发送风电站总概览数据消息=================== 成功！" + JSON.toJSONString(result));
//            } catch (Exception exception) {
//                logger.error("-----------------发送风电站总概览数据消息=================== 失败！");
//            }
//        });
//    }

    /**
     * 实时推送-场站功率曲线总概览
     */
    @Scheduled(cron = fanStationPowerBightCron)
    public void getFanStationPowerBight() {
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("sequence_nbr").eq("station_type", "FDZ"));
        stationBasicList.forEach(stationBasic -> {
            String gatewayId = stationBasic.getFanGatewayId();
            Map<String, Object> detailsWindSpeed = monitorFanIndicator.getDetailsWindSpeedAll(gatewayId);
            try {
                emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_fanStationPowerBight_topic", JSON.toJSON(detailsWindSpeed).toString().getBytes("UTF-8"), 1, true);
                logger.info("-----------------发送风电站功率曲线数据消息=================== 成功！" + JSON.toJSONString(detailsWindSpeed));
            } catch (Exception exception) {
                logger.error("-----------------发送风电站功率曲线数据消息=================== 失败！");
            }
        });
    }

    /**
     * 实时同送-获取各场站的风机列表
     */
//    @Scheduled(cron = fanStatusListCron)
//    public void getFanStatusList() {
//        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("sequence_nbr").eq("station_type", "FDZ"));
//        stationBasicList.forEach(stationBasic -> {
//            List<IndexDto> fanStatusList = monitorFanIndicator.getFanStatusList(String.valueOf(stationBasic.getSequenceNbr()));
//            Page<IndexDto> page = new Page<>(1, 999);
//            List<IndexDto> collect = fanStatusList.stream()
//                    .limit(999)
//                    .collect(Collectors.toList());
//            page.setTotal(fanStatusList.size());
//            page.setRecords(collect);
//            IPage<HashMap<String, String>> fanStatusListImages = getFanStatusListImages(collect);
//            try {
//                emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_fanStationFanStatusList_topic", JSON.toJSON(page).toString().getBytes("UTF-8"), 1, true);
//                emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_fanStationFanStatusListImages_topic", JSON.toJSON(fanStatusListImages).toString().getBytes("UTF-8"), 1, true);
//                logger.info("-----------------发送风电站风机列表数据消息=================== 成功！" + JSON.toJSONString(page));
//            } catch (Exception exception) {
//                logger.error("-----------------发送风电站风机列表数据消息=================== 失败！");
//            }
//        });
//    }
    @Scheduled(cron = fanCurrentDataCron)
    public void getFanCurrentData() {
        Integer current = 1;
        Integer size = 99;
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("sequence_nbr").eq("station_type", "FDZ"));
        stationBasicList.forEach(stationBasic -> {
            List<ESEquipmentsDTO> fanStatusList = monitorFanIndicator.getFanStatusList(String.valueOf(stationBasic.getSequenceNbr()));
            fanStatusList.forEach(indexDto -> {
                String stationBasicId = String.valueOf(stationBasic.getSequenceNbr());
                String equipmentNumber = indexDto.getEquipmentNumber();
                String topicPrefix = stationBasicId + "_" + equipmentNumber;
                IndexDto info = monitorFanIndicator.getFanBasicInfoByEquipNum(equipmentNumber, stationBasicId);
                HashMap<String, Object> windspeddInfo = new HashMap<>();
                String windspeddInfoValue = monitorFanIndicator.getFanDataByType(stationBasicId, equipmentNumber, "实时监控表计", "风速");
                windspeddInfo.put("value", windspeddInfoValue);
                windspeddInfo.put("value", 100);
                String activepower = monitorFanIndicator.getFanDataByType(stationBasicId, equipmentNumber, "实时监控表计", "有功功率");
                String powerFrequency = monitorFanIndicator.getFanDataByType(stationBasicId, equipmentNumber, "实时监控表计", "电网频率");
                String hubSpeed = monitorFanIndicator.getFanDataByType(stationBasicId, equipmentNumber, "实时监控表计", "轮毂转速");
                HashMap<String, List<String>> realTimeTemperatureResult = monitorFanIndicator.getRealTimeTemperature(equipmentNumber, stationBasicId, "实时监控表计");
                IPage<ESEquipments> realTimedata = monitorFanIndicator.getFanIdxInfoByPage(equipmentNumber, stationBasicId, "实时运行数据", current, size, "");
                Map<String, Object> windSpeedOfFan = monitorFanIndicator.getDetailsWindSpeed(stationBasic.getFanGatewayId(), equipmentNumber);
                //发电机系统
                IPage<ESEquipments> fdjSystem = monitorFanIndicator.getFanIdxInfoByPage(equipmentNumber, stationBasicId, "实时运行数据", current, size, "发电机系统");
                List<Map<String, Object>> fdjSystemStatus = monitorFanIndicator.getStatusMonitoring(stationBasic.getFanGatewayId(), equipmentNumber, "发电机系统");
                //机舱与塔筒系统
                IPage<ESEquipments> jcyttSystem = monitorFanIndicator.getFanIdxInfoByPage(equipmentNumber, stationBasicId, "实时运行数据", current, size, "机舱与塔筒系统");
                List<Map<String, Object>> jcyttSystemStatus = monitorFanIndicator.getStatusMonitoring(stationBasic.getFanGatewayId(), equipmentNumber, "机舱与塔筒系统");
                //偏航与液压系统
                IPage<ESEquipments> phyyySystem = monitorFanIndicator.getFanIdxInfoByPage(equipmentNumber, stationBasicId, "实时运行数据", current, size, "偏航与液压系统");
                List<Map<String, Object>> phyyySystemStatus = monitorFanIndicator.getStatusMonitoring(stationBasic.getFanGatewayId(), equipmentNumber, "偏航与液压系统");
                //变流与主控系统
                IPage<ESEquipments> blyzkSystem = monitorFanIndicator.getFanIdxInfoByPage(equipmentNumber, stationBasicId, "实时运行数据", current, size, "变流与主控系统");
                List<Map<String, Object>> blyzkSystemStatus = monitorFanIndicator.getStatusMonitoring(stationBasic.getFanGatewayId(), equipmentNumber, "变流与主控系统");
                //变流与主控系统
                IPage<ESEquipments> ylSystem = monitorFanIndicator.getFanIdxInfoByPage(equipmentNumber, stationBasicId, "实时运行数据", current, size, "叶轮系统");
                List<Map<String, Object>> ylSystemStatus = monitorFanIndicator.getStatusMonitoring(stationBasic.getFanGatewayId(), equipmentNumber, "叶轮系统");
                try {
                    //{stationBasicId}_{equipmentNumber}_fanBasicInfo_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_fanBasicInfo_topic", JSON.toJSON(info).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windspeddInfo_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_windspeddInfo_topic", JSON.toJSON(windspeddInfo).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_activepower_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_activepower_topic", activepower.getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_powerFrequency_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_powerFrequency_topic", powerFrequency.getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_hubSpeed_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_hubSpeed_topic", hubSpeed.getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_realTimeTemperature_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_realTimeTemperature_topic", JSON.toJSON(realTimeTemperatureResult).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_realTimedata_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_realTimedata_topic", JSON.toJSON(realTimedata).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_windSpeedOfFan_topic", JSON.toJSON(windSpeedOfFan).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_fdjSystem_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_fdjSystem_topic", JSON.toJSON(fdjSystem).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_fdjSystemStatus_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_fdjSystemStatus_topic", JSON.toJSON(fdjSystemStatus).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_jcyttSystem_topic", JSON.toJSON(jcyttSystem).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_jcyttSystemStatus_topic", JSON.toJSON(jcyttSystemStatus).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_phyyySystem_topic", JSON.toJSON(phyyySystem).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_phyyySystemStatus_topic", JSON.toJSON(phyyySystemStatus).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_blyzkSystem_topic", JSON.toJSON(blyzkSystem).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_blyzkSystemStatus_topic", JSON.toJSON(blyzkSystemStatus).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_ylSystem_topic", JSON.toJSON(ylSystem).toString().getBytes("UTF-8"), 1, true);
                    //{stationBasicId}_{equipmentNumber}_windSpeedOfFan_topic
                    emqKeeper.getMqttClient().publish(topicPrefix + "_ylSystemStatus_topic", JSON.toJSON(ylSystemStatus).toString().getBytes("UTF-8"), 1, true);
                    logger.info("-----------------发送风电站风机基础数据消息=================== 成功！");
                } catch (Exception exception) {
                    logger.error("-----------------发送风电站风机基础数据消息=================== 失败！");
                }
            });
        });
    }

    /**
     * @param collect 根据网关id查询出来的数据
     * @return 加工后风机实时运行状态图列表数据
     * @deprecated 根据查询出来的风机状态返回风机的状态图片
     */
    public IPage<HashMap<String, String>> getFanStatusListImages(List<IndexDto> collect) {
        IPage<HashMap<String, String>> page = new Page<>();
        HashMap<String, String> hashMap = new HashMap<>();
        //对于查出来的风机进行排序，便于数据处理
        List<IndexDto> indexDtoList = collect.stream().sorted(Comparator.comparing(IndexDto::getEquipmentNumber)).collect(Collectors.toList());
        for (int i = 1; i <= indexDtoList.size(); i++) {
            IndexDto indexDto = indexDtoList.get(i - 1);
            hashMap.put("url" + i, fanStatusImagePathPrefix + File.separator + "风机-" + indexDto.getState() + ".gif");
            hashMap.put("name" + i, indexDto.getEquipmentNumber());
        }
        page.setTotal(10);
        page.setSize(100);
        page.setCurrent(1);
        List<HashMap<String, String>> hashMapList = new ArrayList<>();
        hashMapList.add(hashMap);
        page.setRecords(hashMapList);
        return page;
    }

    @Scheduled(cron = "0 0/1 * * * *")
    public void getIndicatorsSwitchInfo() {
//        Integer current = 1;
//        Integer size = 99;
//        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("booster_gateway_id").eq("station_type", "FDZ"));
//        stationBasicList.forEach(stationBasic -> {
//            //获取系统的forntmodule  前期每次都查询 后续应该放到缓存中
//            List<Map<String, String>> boosterStationInfo = monitorFanIndicatorregionMapper.getBoosterStationInfo(stationBasic.getBoosterGatewayId());
//            for (int i = 0; i < boosterStationInfo.size(); i++) {
//                Map<String, String> map = boosterStationInfo.get(i);
//                sendIndicatorSwitch(stationBasic.getSequenceNbr().toString(), stationBasic.getBoosterGatewayId(), map.get("boosterName"));
//            }
//        });
    }

//    public void sendIndicatorSwitch(String stationId, String bootStationGateWayId, String frontMoudule) {
//        String sql = "SELECT * FROM indicators_" + bootStationGateWayId + " where frontModule = '" + frontMoudule + "' and systemType='开关'";
//        List<IndicatorsDto> indicatorsDtoList = influxDButils.getListData(sql, IndicatorsDto.class);
//        //过滤掉包含数字的开关
//        List<IndicatorsDto> result = indicatorsDtoList.stream().filter(indicatorsDto -> !indicatorsDto.getDisplayName().matches(".*\\d+.*")).collect(Collectors.toList());
//        HashMap<String, String> hashMap = new HashMap<>();
//        for (int i = 0; i < result.size(); i++) {
//            IndicatorsDto indicatorsDto = result.get(i);
//            //此处需要根据查询的结果来动态的给定图片的url路径。
//            hashMap.put("url" + i, "tetee");
//            hashMap.put("display" + i, indicatorsDto.getDisplayName());
//        }
//        Page<HashMap<String, String>> hashMapPage = new Page<>();
//        List<HashMap<String, String>> list = new ArrayList<>();
//        list.add(hashMap);
//        hashMapPage.setRecords(list);
//        hashMapPage.setTotal(list.size());
//        hashMapPage.setCurrent(1);
//        System.out.println(result.size());
//        try {
//            emqKeeper.getMqttClient().publish(stationId + bootStationGateWayId + "_topic", JSON.toJSON(hashMapPage).toString().getBytes("UTF-8"), 1, true);
//            logger.info(JSON.toJSONString(hashMapPage));
//            logger.info("-----------------发送升压站数据成功=================== 成功！");
//        } catch (Exception e) {
//            logger.info("-----------------发送升压站数据成功=================== 成功！");
//        }
//    }
}
