package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.module.ugp.api.entity.Equipment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 项目资源表（包括焊工、管材、设备）
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="ProjectResourceDto", description="项目资源表（包括焊工、管材、设备）")
public class ProjectResourceDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "资源名称")
    private String name;

    @ApiModelProperty(value = "sb名称")
   private String equipmentName;
    @ApiModelProperty(value = "资源类型（welder、material、equipment）")
    private String type;

    @ApiModelProperty(value = "资源id")
    private Long resourceId;



 @ApiModelProperty(value = "管材编号")
 private String code;



 @ApiModelProperty(value = "管材规格")
 private String spec;

 @ApiModelProperty(value = "管材壁厚")
 private Integer wallThickness;

 @ApiModelProperty(value = "生产厂家")
 private String manufacturer;

 @ApiModelProperty(value = "生产日期")
 private Date manufactureDate;

 @ApiModelProperty(value = "生产编号")
 private String batchNum;


 @ApiModelProperty(value = "项目名称")
 private String  projectName;

 @ApiModelProperty(value = "项目资源id")
 private Long  projectResourceId;


 Equipment equipment;


 @ApiModelProperty(value = "企业id")
 private Long companyId;



// private String equipmentCode;
// private String equipmentType;
// private String equipmentManufacturer;
// private String equipmentManufacture_date;
 @ApiModelProperty(value = "使用年限")
 private String serviceLife;

 @ApiModelProperty(value = "检定状态")
 private String verifyStatus;

 @ApiModelProperty(value = "检验日期")
 private Date inspectionDate;

 @ApiModelProperty(value = "使用状态")
 private String useStatus;

 @ApiModelProperty(value = "备注")
 private String remark;

 @ApiModelProperty(value = "单位机构代码")
 private String orgCode;


}
