package com.yeejoin.amos.api.openapi.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class InformationSituationConverter implements Converter<String> {

    private static final String TYPE_QR_CODE = "二维码";
    private static final String TYPE_STAMP = "电子标签";
    private static final String TYPE_NO = "无";
    private static final String TYPE_OTHER = "其他";


    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                     GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        if (TYPE_QR_CODE.equals(cellValue)) {
            return "1";
        } else if (TYPE_STAMP.equals(cellValue)) {
            return "2";
        } else if (TYPE_OTHER.equals(cellValue)) {
            return "3";
        }
        return "99";
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        // 判断实体类中获取的值，转换为Excel预期的值，并封装为CellData对象
        if (o == null) {
            return new CellData("");
        } else if (o.equals("1")) {
            return new CellData(TYPE_QR_CODE);
        } else if (o.equals("2")) {
            return new CellData(TYPE_STAMP);
        } else if (o.equals("3")) {
            return new CellData(TYPE_OTHER);
        }
        return new CellData(TYPE_NO);
    }
}