package com.yeejoin.amos.boot.module.jg.api.enums;

import java.util.Arrays;
import java.util.Optional;

/**
 * 使用登记业务类型枚举
 *
 * @author Administrator
 */
public enum RegTypeEnum {

    /**
     * 使用登记业务类型枚举
     */
    REGISTRATION_NEW("0", "新增登记"),

    REGISTRATION_HISTORY("1", "历史登记"),

    REGISTRATION_SPECIAL("2", "特殊历史登记");

    private final String code;

    private final String name;

    RegTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Optional<String> getNameByCode(String code) {
        return Arrays.stream(RegTypeEnum.values())
                     .filter(e -> e.getCode().equals(code))
                     .map(RegTypeEnum::getName)
                     .findFirst();
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
