package com.yeejoin.amos.boot.module.common.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 单位下摄像头表
 *
 * @author system_generator
 * @date 2024-10-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="BaseEnterpriseVideoNodeDto", description="单位下摄像头表")
public class BaseEnterpriseVideoNodeDto extends BaseDto {

   private static final long serialVersionUID = 1L;

   /**
    * 使用单位名称
    */
   @ApiModelProperty(value = "使用单位名称")
   private String useUnitName;

   /**
    * 使用单位统一信用代码
    */
   @ApiModelProperty(value = "使用单位统一信用代码")
   private String useUnitCode;
   /**
    * 区域名称
    */
   @ApiModelProperty(value = "区域名称")
   private String regionName;
   /**
    * 区域代码
    */
   @ApiModelProperty(value = "区域代码")
   private String regionCode;

   /**
    * 视频名称
    */
   @ApiModelProperty(value = "视频名称")
   private String videoName;

   /**
    * 设备使用登记代码
    */
   @ApiModelProperty(value = "设备使用登记代码")
   private String devUseCode;

   /**
    * 是否删除
    */
   @ApiModelProperty(value = "是否删除")
   private Boolean isDelete;

   /**
    * 组织代码
    */
   @ApiModelProperty(value = "组织代码")
   private String orgCode;

   /**
    * 视频ID
    */
   @ApiModelProperty(value = "视频ID")
   private String cameraIndexCode;

   /**
    * 更新时间
    */
   @ApiModelProperty(value = "更新时间")
   private Date updatesTime;
   @ApiModelProperty(value = "标识什么设种类使用的摄像头")
   private String equListCode;

   /**
    * 视频配置表主键
    */
   @ApiModelProperty(value = "视频配置表主键")
   private Long videoSeq;
}
