package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.service;

import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.adapter.DocGenerateAdapter;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.DocGeneratorFactory;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.dto.DocGenerationRequest;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.support.DocGenerator;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
@Slf4j
public class DocGenerateService {

    private final DocGeneratorFactory docGeneratorFactory;

    private final DocGenerateAdapter defaultDocGenerateAdapter;


    public String generateDoc(String appSeq) {
        DocGenerationRequest docGenerationRequest = defaultDocGenerateAdapter.prepareRequest(appSeq);
        DocGenerator docGenerator = docGeneratorFactory.getGenerator(docGenerationRequest);
        return docGenerator.generate(appSeq);
    }
}
