package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationReformDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.jg.api.enums.CompanyTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationReformServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 改造变更登记
 *
 * @author system_generator
 * {@code @Date} 2023-12-20
 */
@RestController
@Api(tags = "改造变更登记Api")
@RequestMapping(value = "/jg-change-registration-reform")
public class JgChangeRegistrationReformController extends BaseController {

    @Autowired
    JgChangeRegistrationReformServiceImpl jgChangeRegistrationReformServiceImpl;

    /**
     * 新增改造变更登记
     *
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增改造变更登记", notes = "新增改造变更登记")
	public ResponseModel<Object> save(@RequestBody JSONObject map) {
	    return ResponseHelper.buildResponse(jgChangeRegistrationReformServiceImpl.save(map));
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/flowExecute")
	@ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
	public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
		jgChangeRegistrationReformServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),
				String.valueOf(map.get("instanceId")),
				String.valueOf(map.get("operate")),
				String.valueOf(map.get("comment")),
				String.valueOf(map.get("nextTaskId")));
		return ResponseHelper.buildResponse("ok");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/withdraw")
	@ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
	public ResponseModel<Object> withdraw(@RequestBody JSONObject map) {
		jgChangeRegistrationReformServiceImpl.withdraw(String.valueOf(map.get("instanceId")), String.valueOf(map.get("nextTaskId")));
		return ResponseHelper.buildResponse("ok");
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/deleteBatch")
	@ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
	public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
		List<Long> ids = (List<Long>) map.get("ids");
		jgChangeRegistrationReformServiceImpl.deleteBatch(ids);
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/delete")
	@ApiOperation(httpMethod = "POST", value = "删除", notes = "删除")
	public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
		ArrayList<Long> ids = new ArrayList<>();
		ids.add(id);
		jgChangeRegistrationReformServiceImpl.deleteBatch(ids);
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
	@GetMapping(value = "/getList")
	public ResponseModel<Page<Map<String, Object>>> getList(JgChangeRegistrationReformDto dto,
															@RequestParam(value = "sort",required = false) String sort,
															@RequestParam(value = "current") int current,
															@RequestParam(value = "size") int size) {
		Page<Map<String, Object>> page = new Page<>(current, size);
		ReginParams reginParams = getSelectedOrgInfo();
		if(reginParams.getCompany().getLevel().equals(COMPANY_TYPE_COMPANY)){
			dto.setDataType(COMPANY_TYPE_COMPANY);
			dto.setUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
		} else {
			dto.setDataType(COMPANY_TYPE_SUPERVISION);
			dto.setReceiveOrgCode(reginParams.getCompany().getCompanyCode());
		}
		Page<Map<String, Object>> list = jgChangeRegistrationReformServiceImpl.getList(dto,sort, page, dto.getRoleIds());
		list.getRecords().forEach(x-> x.put("companyType",reginParams.getCompany().getCompanyType()));
		return ResponseHelper.buildResponse(list);
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "获取详情", notes = "获取详情")
	@GetMapping(value = "/getDetail")
	public ResponseModel<Map<String, Object>> getDetail(@RequestParam("currentDocumentId") String currentDocumentId,@RequestParam(value = "equipId",required = false) String equipId) {
		return ResponseHelper.buildResponse(jgChangeRegistrationReformServiceImpl.getDetail(currentDocumentId,equipId));
	}

	/**
	 * 改造登记-导出使用登记证
	 * @param response 返回
	 * @param sequenceNbr 主键
	 * @param printType 打印类型，0-正常打印，1-套打（默认0）
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/export")
	@ApiOperation(httpMethod = "GET", value = "改造登记-导出使用登记证", notes = "改造登记-导出使用登记证")
	public void exportImageZip(HttpServletResponse response, @RequestParam("sequenceNbr") String sequenceNbr,
							   @RequestParam(value = "printType", defaultValue = "0") String printType){
		jgChangeRegistrationReformServiceImpl.exportUseRegistrationCertificate(sequenceNbr, response, printType);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping (value = "/getEquDetail")
	@ApiOperation(httpMethod = "GET", value = "根据使用登记证查询设备详情(前端组件默认传参record)", notes = "根据使用登记证查询设备详情")
	public ResponseModel<Map<String, Object>> getEquDetail(@RequestParam String record) {
		return ResponseHelper.buildResponse(jgChangeRegistrationReformServiceImpl.getEquDetail(record));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping (value = "/getUseRegistrationCodeData")
	@ApiOperation(httpMethod = "GET", value = "获取当前企业，某接收机构审批的使用登记证信息", notes = "获取当前企业，某接收机构审批的使用登记证信息")
	public ResponseModel<Page<JgUseRegistrationManageDto>> getUseRegistrationCodeData(
																		 @RequestParam(value = "current") int current,
																		 @RequestParam(value = "size") int size,
																		 @RequestParam(value = "EQU_LIST_CODE", required = false) String EQU_LIST_CODE,
																		 @RequestParam(value = "EQU_CATEGORY_CODE", required = false) String EQU_CATEGORY_CODE,
																		 @RequestParam(value = "equList", required = false) String equList,
																		 @RequestParam(value = "receiveCompanyCode") String receiveCompanyCode,
																		 @RequestParam(value = "transferType", required = false) String transferType) {
		JgUseRegistrationManageDto dto = new JgUseRegistrationManageDto();
		Page<JgUseRegistrationManageDto> page = new Page<JgUseRegistrationManageDto>();
		page.setCurrent(current);
		page.setSize(size);
		ReginParams info = getSelectedOrgInfo();
		if (info.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
			dto.setDataType(BaseController.COMPANY_TYPE_COMPANY);
			dto.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(info.getCompany().getCompanyType()) ?
					info.getCompany().getCompanyCode().split("_")[1] : info.getCompany().getCompanyCode());
		} else {
			dto.setDataType(BaseController.COMPANY_TYPE_SUPERVISION);
			dto.setReceiveCompanyCode(info.getCompany().getCompanyCode());
		}
		// 新增时使用EQU_LIST_CODE，适配组件，适配原有表单
		if (!ObjectUtils.isEmpty(EQU_LIST_CODE)){
			dto.setEquListCode(EQU_LIST_CODE);
		}
		// 流程页面使用equList，适配组件，适配原有表单
		if (!ObjectUtils.isEmpty(equList)){
			dto.setEquListCode(equList);
		}
		// 流程页面使用equList，适配组件，适配原有表单
		if (!ObjectUtils.isEmpty(EQU_CATEGORY_CODE)){
			dto.setEquCategoryCode(EQU_CATEGORY_CODE);
		}
		if (!ValidationUtil.isEmpty(receiveCompanyCode)){
			String[] codes = receiveCompanyCode.split("_");
			if (!ValidationUtil.isEmpty(codes)){
				dto.setReceiveCompanyCode("1".equals(transferType) ? null : codes[0]);
			}
		}
		dto.setCertificateStatus("1".equals(transferType) ? "已注销" : "已登记");
		return ResponseHelper.buildResponse(jgChangeRegistrationReformServiceImpl.getUseRegistrationCodeData(page, dto));
	}
}
