package com.yeejoin.amos.boot.module.jyjc.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jyjc.api.dto.PublicityInspectOrgInfoDto;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcOpeningApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcOpeningApplication;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcOpeningApplicationRequstDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *  Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-13
 */
public interface JyjcOpeningApplicationMapper extends BaseMapper<JyjcOpeningApplication> {

    Page<JyjcOpeningApplicationModel> selectJyjcOpeningApplicationList(@Param("page")Page<JyjcOpeningApplication> page,
                                                                       @Param("jyjcOpeningApplicationRequstDto") JyjcOpeningApplicationRequstDto jyjcOpeningApplicationRequstDto,
                                                                       @Param("applyStartTime") String applyStartTime,
                                                                       @Param("currentUserId") String currentUserId,
                                                                       @Param("applyendTime") String applyendTime);

    void updatePromoter(@Param("id") Long id);

    List<Long> selectOverdueData();

    /**
     * 检验机构公示
     * @param orgCode 区域对应的orgCode
     * @param dpFilterParamDto 过滤条件
     * @return List<PublicityInspectOrgInfoDto>
     */
    List<PublicityInspectOrgInfoDto> queryInspectionOrgListForPublicity(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);
}
