package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author Administrator
 */
@Service
public class StCommonServiceImpl {


    private static List<RegionModel> regionModels = new ArrayList<>();

    public void init() {
        initReginCode();
    }

    private void initReginCode() {
        Collection<RegionModel> result = Systemctl.regionClient.queryForTree(null).getResult();
        result.forEach(r -> {
            regionModels.add(r);
            this.loopSetChildRegin(regionModels, r.getChildren());
        });
    }

    private void loopSetChildRegin(List<RegionModel> regionModels, Collection<RegionModel> children) {
        if (children != null && children.size() > 0) {
            children.forEach(c -> {
                regionModels.add(c);
                this.loopSetChildRegin(regionModels, c.getChildren());
            });
        }
    }

    public List<RegionModel> getUserRegionCode(ReginParams selectedOrgInfo) {
        String regionCode = selectedOrgInfo.getCompany().getCompanyCode();
        Optional<RegionModel> op = regionModels.stream().filter(e->e.getRegionCode().toString().equals(regionCode)).findFirst();
        RegionModel model = op.orElse(new RegionModel());
        RegionModel result = new RegionModel();
        result.setRegionName(model.getRegionName());
        result.setRegionCode(Integer.parseInt(regionCode));
        return Collections.singletonList(result);
    }
}
