package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import java.util.List;
import java.util.Map;

/**
 * 注册登记信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-08-17
 */
public interface IdxBizJgRegisterInfoMapper extends BaseMapper<IdxBizJgRegisterInfo> {

    @Select("select \"USE_ORG_CODE\" from idx_biz_jg_register_info where \"RECORD\" = #{equipCode}")
   String getUseOrgCodeByEquip(@Param("equipCode") String equipCode);

    @Select("update idx_biz_jg_register_info set \"USE_ORG_CODE\" = #{useOrgCode} where \"RECORD\" = #{equipCode}")
    Boolean updateUseOrgCodeByEquip(@Param("equipCode") String equipCode,@Param("useOrgCode") String useOrgCode);

    @Select("select code as dictDataKey,name as dictDataValue from tz_equipment_category where parent_id = ( SELECT sub.id from tz_equipment_category as sub where sub.code = #{equipCode})")
    List<DictionarieValueModel> queryAllEquCategoriesUnderTheEquList(@Param("equipCode") String equipCode);

    @Select("SELECT jui.PROJECT_CONTRAPTION as value FROM idx_biz_jg_construction_info  jci LEFT JOIN idx_biz_jg_use_info  jui on jci.RECORD = jui.RECORD where  jci.USC_UNIT_CREDIT_CODE = #{uscUnitCreditCode} and jui.PROJECT_CONTRAPTION is not null  GROUP BY jui.PROJECT_CONTRAPTION")
    List<Map<String, Object>> getProjectContraption(@Param("uscUnitCreditCode")String uscUnitCreditCode);

    @Select("SELECT SEQUENCE_NBR,REC_DATE,ORG_BRANCH_NAME,ORG_BRANCH_CODE,USE_UNIT_NAME,USE_UNIT_CREDIT_CODE,EQU_LIST_CODE,EQU_LIST,EQU_CATEGORY,EQU_CATEGORY_CODE,USE_ORG_CODE,CODE96333,EQU_CODE,SUPERVISORY_CODE,USE_PLACE,ADDRESS,EQU_STATE,STATUS,USE_INNER_CODE,FACTORY_NUM,PRODUCE_UNIT_NAME,INSPECT_REPORT,NEXT_INSPECT_DATE,CONSTRUCTION_TYPE,USC_UNIT_CREDIT_CODE,USC_UNIT_NAME,EQU_DEFINE,EQU_DEFINE_CODE,PRODUCT_NAME,BRAND_NAME,EQU_TYPE,DATA_SOURCE,IS_INTO_MANAGEMENT,WHETHER_VEHICLE_CYLINDER,WHETHER_SKID_MOUNTED_PRESSURE_VESSEL,DATE_FORMAT(PRODUCE_DATE,'%Y-%m-%d %H:%i:%s')as PRODUCE_DATE,PROJECT_CONTRAPTION from idx_biz_view_jg_all WHERE PROJECT_CONTRAPTION is not null")
    List<Map<String, Object>> esSynchronousProjectContraption();

    @Select("SELECT\n" +
            "\tjui.PROJECT_CONTRAPTION AS value \n" +
            "FROM\n" +
            "\tidx_biz_jg_use_info jui\n" +
            "\tLEFT JOIN idx_biz_jg_register_info jri ON jri.\"RECORD\" = jui.\"RECORD\"\n" +
            "WHERE\n" +
            "\tjui.USE_UNIT_CREDIT_CODE = #{useUnitCreditCode} \n" +
            "\tAND jui.PROJECT_CONTRAPTION IS NOT NULL\n" +
            "\tAND jri.\"USE_ORG_CODE\" IS NULL\n" +
            "GROUP BY\n" +
            "\tjui.PROJECT_CONTRAPTION")
    List<Map<String, Object>> getUnRegisterProjectContraptionList(String useUnitCreditCode);
}
