package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanTaskTheStatusEnum {

    NOTSTARTED("notStarted",0),
    UNDERWAY("inProgress",1),
    FINISHED("ended",2),
    OVERTIME("timedout",3);

    /**
     * 名称
     */
    private String name;

    /**
     * 值
     */
    private int value;



    private PlanTaskTheStatusEnum(String name, int value) {
        this.name = name;
        this.value = value;
    }


    public static String getName(int value) {
        for (PlanTaskTheStatusEnum c : PlanTaskTheStatusEnum.values()) {
            if (c.getValue() == value) {
                return c.name;
            }
        }
        return null;
    }

    public static int getValue(String name) {
        for (PlanTaskTheStatusEnum c : PlanTaskTheStatusEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return -1;
    }


    public static PlanTaskTheStatusEnum getEnum(int value) {
        for (PlanTaskTheStatusEnum c : PlanTaskTheStatusEnum.values()) {
            if (c.getValue() == value) {
                return c;
            }
        }
        return null;
    }


    public static PlanTaskTheStatusEnum getEnum(String name) {
        for (PlanTaskTheStatusEnum c : PlanTaskTheStatusEnum.values()) {
            if (c.getName().equals(name)) {
                return c;
            }
        }
        return null;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String,String>> nameList = new ArrayList<>();
        for (PlanTaskTheStatusEnum c: PlanTaskTheStatusEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("name", c.getName());
            map.put("value", c.getValue() +"");
            nameList.add(map);
        }
        return nameList;
    }

    public static List<String> getEnumNameList() {
        List<String> nameList = new ArrayList<String>();
        for (PlanTaskTheStatusEnum c: PlanTaskTheStatusEnum.values()) {
            nameList.add(c.getName());
        }
        return nameList;
    }

    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


    public int getValue() {
        return value;
    }


    public void setValue(int value) {
        this.value = value;
    }


}
