package com.yeejoin.amos.boot.module.ymt.flc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ymt.api.dto.BaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.BaseUnitLicence;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.BaseUnitLicenceServiceImpl;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.TzBaseEnterpriseInfoServiceImpl;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.CylinderUnitDto;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.RegUnitIcDto;
import com.yeejoin.amos.boot.module.ymt.flc.api.entity.CylinderUnit;
import com.yeejoin.amos.boot.module.ymt.flc.api.entity.RegUnitIc;
import com.yeejoin.amos.boot.module.ymt.flc.api.mapper.CylinderUnitMapper;
import com.yeejoin.amos.boot.module.ymt.flc.api.service.ICylinderUnitService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;

/**
 * 气瓶企业信息服务实现类
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Service
public class CylinderUnitServiceImpl extends BaseService<CylinderUnitDto, CylinderUnit,CylinderUnitMapper> implements ICylinderUnitService {

    @Autowired
    TzBaseEnterpriseInfoServiceImpl baseEnterpriseInfoService;

    @Autowired
    RegUnitIcServiceImpl regUnitIcService;

    @Autowired
    BaseUnitLicenceServiceImpl baseUnitLicenceService;

    /**
     * 分页查询
     */
    public Page<CylinderUnitDto> queryForCylinderUnitPage(Page<CylinderUnitDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderUnitDto> queryForCylinderUnitList()   {
        return this.queryForList("" , false);
    }

    /**
     * 获取上个月气瓶企业总量
     * @return
     */
    public Integer getLastMonthUnitTotal(String regionCode) {
        return baseMapper.getLastMonthUnitTotal(regionCode);
    }

    /**
     * 获取上上个月气瓶企业总量
     * @return
     */
    public Integer getMonthBeforeLastUnitTotal(String regionCode) {
        return baseMapper.getMonthBeforeLastUnitTotal(regionCode);
    }


    public Integer getThisMonthUnitTotalByRegionCode(String regionCode) {
        return baseMapper.getThisMonthUnitTotalByRegionCode(regionCode);
    }

    public Integer getUnitTotalByRegionCode(String regionCode) {
        return baseMapper.getUnitTotalByRegionCode(regionCode);
    }


    /**
     * 后边对接需要更改，目前没值默认0
     * @param code
     * @return
     */
    public Integer getWarnNum(String code) {
//        return baseMapper.getWarnNum(code);
        return 0;
    }
    
    public int getWarnNumByAppId(String appId) 
    {
    	  return baseMapper.getWarnNumByAppId(appId);
    }

    /**
     * 获取气瓶充装单位许可信息详情
     *
     * @param sequenceNbr
     * @return
     */
    public TzBaseEnterpriseInfoDto getCylinderUnitLic(Long sequenceNbr){
        CylinderUnit cylinderUnit = this.getById(sequenceNbr);
        if(ValidationUtil.isEmpty(cylinderUnit)){
            return null;
        }
        String creditCode = cylinderUnit.getCreditCode();

        //根据creditCode获取TzBaseEnterpriseInfo表信息
        LambdaQueryWrapper<TzBaseEnterpriseInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TzBaseEnterpriseInfo::getUseCode,cylinderUnit.getCreditCode())
                .eq(TzBaseEnterpriseInfo::getIsDelete,false);
        TzBaseEnterpriseInfo baseEnterpriseInfo = baseEnterpriseInfoService.getOne(wrapper);
        TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto = new TzBaseEnterpriseInfoDto();
        if (ValidationUtil.isEmpty(baseEnterpriseInfo)){
            return null;
        }
        BeanUtils.copyProperties(baseEnterpriseInfo, tzBaseEnterpriseInfoDto);

        // 许可信息
        List<BaseUnitLicence> unitLicences = baseUnitLicenceService.list(new LambdaQueryWrapper<BaseUnitLicence>()
                .eq(BaseUnitLicence::getUnitCode, creditCode));
        List<BaseUnitLicenceDto> unitLicenceDtos = new ArrayList<BaseUnitLicenceDto>();
        for (BaseUnitLicence baseUnitLicence : unitLicences) {
            BaseUnitLicenceDto baseUnitLicenceDto = new BaseUnitLicenceDto();
            BeanUtils.copyProperties(baseUnitLicence, baseUnitLicenceDto);
            unitLicenceDtos.add(baseUnitLicenceDto);
        }
        tzBaseEnterpriseInfoDto.setUnitLicences(unitLicenceDtos);
        // 工商信息
        RegUnitIc regUnitIc = regUnitIcService.getOne(
                new LambdaQueryWrapper<RegUnitIc>().eq(RegUnitIc::getUnitCode, creditCode));
        RegUnitIcDto regUnitIcDto = new RegUnitIcDto();
        if (regUnitIc != null) {
            BeanUtils.copyProperties(regUnitIc, regUnitIcDto);
        }
        tzBaseEnterpriseInfoDto.setRegUnitIcDto(regUnitIcDto);
        return tzBaseEnterpriseInfoDto;
    }

    /**
     * 根据creditCode查询该企业是否存在许可超期
     * @param creditCode 统一社会信用代码
     * @return
     */
    public Integer getLicenseOutOfDate(String creditCode){
        return baseMapper.getLicenseOutOfDate(creditCode);
    }
}