package com.yeejoin.amos.patrol.dao.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.data.annotation.CreatedDate;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * The persistent class for the p_plan_task_detail database table.
 *
 */
@Entity
@Table(name="p_plan_task_detail_history")
public class PlanTaskDetailHistory implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 是否完成：是否完成0-未完成，1-已完成，2-超时漏检
     */
    @Column(name="is_finish")
    private int isFinish;
    /**
     * 点编号
     */
    @Column(name="point_id")
    private long pointId;
    /**
     * 任务批次号
     */
    @Column(name="task_no")
    private long taskNo;

    /**
     * 具体执行人id
     */
    @Column(name="executor_id")
    private String executorId;

    /**
     * 执行时间
     */
    @Column(name="executor_date")
    private Date executorDate;

    private PlanTask planTask;

    /**
     * 状态：0 未开始；1 合格；2 不合格；3 漏检
     */
    @Column(name="status")
    private String status="0";

    public PlanTaskDetailHistory() {
    }


    public int getIsFinish() {
        return this.isFinish;
    }

    public void setIsFinish(int isFinish) {
        this.isFinish = isFinish;
    }

    public long getPointId() {
        return this.pointId;
    }

    public void setPointId(long pointId) {
        this.pointId = pointId;
    }

    public long getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(long taskNo) {
        this.taskNo = taskNo;
    }



    public void setPlanTask(PlanTask planTask) {
        this.planTask = planTask;
    }


    public String getStatus() {
        return status;
    }


    public void setStatus(String status) {
        this.status = status;
    }


    public String getExecutorId() {
        return executorId;
    }

    public void setExecutorId(String executorId) {
        this.executorId = executorId;
    }

    public Date getExecutorDate() {
        return executorDate;
    }

    public void setExecutorDate(Date executorDate) {
        this.executorDate = executorDate;
    }

    /**
     * id
     */
    private long id;

    @CreatedDate
    @Column(name="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    @Id
    @Column(name = "ID",nullable=false,unique=true)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
}