package com.yeejoin.amos.boot.module.cylinder.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 气瓶充装信息--充装前检查
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling")
@ApiModel(value="TzCylinderFilling对象", description="气瓶充装信息--充装前检查")
public class CylinderFilling extends CylinderFillingBaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "检查时间")
    private Date inspectionDate;

    @ApiModelProperty(value = "车牌号码")
    @TableField(value = "car_number")
    private String carNumber;

    @ApiModelProperty(value = "充装气体与气瓶允许充装气体一致")
    private String isCylinderGasConsistent;

    @ApiModelProperty(value = "充装介质")
    private String fillingMedium;

    @ApiModelProperty(value = "气瓶外表面有划伤、裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷")
    private String hasSevereExternalDamage;

    @ApiModelProperty(value = "气瓶内有剩余压力")
    private String hasResidualPressure;

    @ApiModelProperty(value = "无气体泄漏")
    private String isGasLeak;

    @ApiModelProperty(value = "气瓶附件齐全并符合安全要求")
    private String areAccessoriesCompleteAndSafe;

    @ApiModelProperty(value = "排除超期未检气瓶、非法改装或翻新及报废气瓶")
    private String excludeOverdueRefurbishedScrappedCylinders;

    @ApiModelProperty(value = "警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致")
    private String isWarningLabelGasNameConsistentWithStamp;

    @ApiModelProperty(value = "气瓶外表面的颜色标志是否符合规定")
    private String isColorMarkingCompliant;

    @ApiModelProperty(value = "瓶阀符合GB7512规定")
    @TableField(value = "valve_complies_gb7512")
    private String valveCompliesGB7512;

    @ApiModelProperty(value = "气瓶外表面无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷")
    private String hasNoSevereExternalDamage;

    @ApiModelProperty(value = "新投入使用气瓶或经检验后首次投入使用气瓶，充装前按照规定先置换瓶内空气，并经分析合格后方可充气")
    private String isNewOrInspectedOk;

    @ApiModelProperty(value = "充装介质与气瓶钢印标志气体名称是否一致")
    private String isFillingMediumConsistentWithStamp;

    @ApiModelProperty(value = "气瓶瓶阀的出气口螺纹型式是符合GB/T15383的规定")
    @TableField(value = "outlet_thread_type_complies_gb15383")
    private String outletThreadTypeCompliesGB15383;

    @ApiModelProperty(value = "充装可燃、氧化性气体，如无余压保持阀，重复充装前应先进行抽真空处理")
    private String isVacuumProcessed;

    @ApiModelProperty(value = "气瓶外表面无严重腐蚀")
    private String hasNoSevereCorrosion;

    @ApiModelProperty(value = "气瓶外表面无损伤缺陷")
    private String hasNoSurfaceDefects;

    @ApiModelProperty(value = "气瓶外表面的颜色标志符合GB/T7144的规定、且清晰易认")
    @TableField(value = "color_meets_gb7144")
    private String colorMeetsGB7144;

    @ApiModelProperty(value = "气瓶外表面无裂纹")
    private String hasNoCracks;

    @ApiModelProperty(value = "气瓶外表面无明显变形")
    private String hasNoObviousDeformation;

    @ApiModelProperty(value = "瓶体、瓶阀无沾染油脂或其他可燃物")
    private String noOilOrFlammableSubstances;

    @ApiModelProperty(value = "瓶体无腐蚀、机械损伤等表面缺陷、是否满足GB13076标准报废")
    @TableField(value = "meets_gb13076_and_mechanical_damage")
    private String meetsGB13076AndMechanicalDamage;

    @ApiModelProperty(value = "易熔合金无融熔、流失、损伤的")
    private String fusiblePlugUndamaged;

    @ApiModelProperty(value = "钢印标记完整且能够识别")
    private String stampMarkingsClearAndComplete;

    @ApiModelProperty(value = "附件完整且符合规定")
    private String accessoriesCompleteAndConforming;

    @ApiModelProperty(value = "瓶阀侧接嘴处积无炭黑或焦油等异物")
    private String noCarbonBlackOrTarAtValvePort;

    @ApiModelProperty(value = "瓶内的填料、溶剂的质量没有问题")
    private String fillerAndSolventQualityOk;

    @ApiModelProperty(value = "无其他影响安全使用缺陷的")
    private String noOtherSafetyAffectingDefects;

    @ApiModelProperty(value = "充装间温度")
    private Double fillingRoomTemperature;

    @ApiModelProperty(value = "剩余压力")
    private Double residualPressure;

    @ApiModelProperty(value = "丙酮补加量")
    private Double acetoneSupplementAmount;

    @ApiModelProperty(value = "钢印、警示标签与待充介质名称一致")
    private String isStampAndLabelConsistentWithMedium;

    @ApiModelProperty(value = "外表面颜色标志符合规定")
    private String externalColorMarkingCompliant;

    @ApiModelProperty(value = "瓶阀出气口螺纹符合要求")
    private String valveOutletThreadComplies;

    @ApiModelProperty(value = "外表面无严重损伤缺陷")
    private String hasNoSevereSurfaceDefects;

    @ApiModelProperty(value = "气瓶附件符合要求")
    private String cylinderAccessoriesMeetRequirements;

    @ApiModelProperty(value = "氧化性混合气体的瓶体、瓶阀未沾染油脂")
    private String oxidizingGasCylinderFreeOfOil;

    @ApiModelProperty(value = "气瓶经预处理（抽真空、烘干、置换或组合）合格")
    private String preTreatedSuccessfully;

    @ApiModelProperty(value = "气瓶表面无油污、无严重损伤")
    private String surfaceFreeOfOilAndDamage;

    @ApiModelProperty(value = "瓶阀完好、接头洁净无水或冰")
    private String valveInGoodConditionCleanConnection;

    @ApiModelProperty(value = "无余压的瓶用洁净的待充气体吹扫（易燃的先用液氮置换）")
    private String emptyPressureCylinderPurgedWithCleanGas;

    @ApiModelProperty(value = "瓶阀出气口为内螺纹(左旋)")
    private String valveOutletInternalThreadLeftHanded;

    @ApiModelProperty(value = "有余压的经定性鉴别且与待充介质一致")
    private String qualitativeTestPassedForResidualGas;

    @ApiModelProperty(value = "无余压的经卸阀内检合格")
    private String internalValveInspectionPassed;

    @ApiModelProperty(value = "气瓶安全附件齐全并符合安全要求")
    private String safetyAccessoriesCompleteAndSafe;

    @ApiModelProperty(value = "首充气瓶已置换瓶内空气")
    private String newCylinderAirReplacedBeforeFirstUse;
}
