package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RequestContextWrapper;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.jg.api.enums.CompanyTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.service.IJgTableDataExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

/**
 * JG表格数据导出
 */
@Slf4j
@RestController
@Api(tags = "JG表格数据导出")
@RequestMapping(value = "/dataExport")
public class JgTableDataExportController extends BaseController {


    private IJgTableDataExportService iJgTableDataExportService;

    public JgTableDataExportController(IJgTableDataExportService iJgTableDataExportService) {
        this.iJgTableDataExportService = iJgTableDataExportService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/gen")
    @ApiOperation(httpMethod = "GET", value = "工具辅助接口", notes = "工具辅助接口")
    public ResponseModel<String> httGen(String jsonName, String voName, String tableName) {
        iJgTableDataExportService.gen(jsonName, voName, tableName);
        return ResponseHelper.buildResponse("Ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/certificate")
    @ApiOperation(httpMethod = "GET", value = "登记证列表数据导出", notes = "登记证列表数据导出")
    public ResponseModel<String> certificateExport(JgUseRegistrationManageDto dto,
                                                   // 区分非审批列表导出（isJG --> jg），还是审批列表导出 ,默认审批列表导出
                                                   @RequestParam(value = "isJG", defaultValue = "false") Boolean isJG,
                                                   @RequestParam(value = "ids", required = false) String ids,
                                                   @RequestParam(value = "sort", required = false) String sort) {
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.certificate(uuid, dto, isJG, ids == null ? new ArrayList<>() : Arrays.asList(ids.split(",")), sort);
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/maintenance")
    @ApiOperation(httpMethod = "GET", value = "维保备案列表数据导出", notes = "维保备案列表数据导出")
    public void maintenanceExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.maintenance(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/installation")
    @ApiOperation(httpMethod = "GET", value = "安装告知列表数据导出", notes = "安装告知列表数据导出")
    public void installationExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.installation(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/maintain")
    @ApiOperation(httpMethod = "GET", value = "维修告知列表数据导出", notes = "维修告知列表数据导出")
    public void maintainExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.maintain(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/reform")
    @ApiOperation(httpMethod = "GET", value = "改造告知列表数据导出", notes = "改造告知列表数据导出")
    public void reformExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.reform(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/transfer")
    @ApiOperation(httpMethod = "GET", value = "移装告知列表数据导出", notes = "移装告知列表数据导出")
    public void transferExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.transfer(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/registration")
    @ApiOperation(httpMethod = "GET", value = "使用登记列表数据导出", notes = "使用登记列表数据导出")
    public void registrationExport(HttpServletResponse response,
                                   JgUseRegistrationDto dto,
                                   @ApiParam(value = "客户端类型: jgAudit-监管审核;jgLook-监管查看")
                                   @RequestParam(value = "client", required = false, defaultValue = "jgAudit") String client) {
        ReginParams info = getSelectedOrgInfo();
        dto.setCurrentUserId(info.getUserModel().getUserId());
        if (info.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            dto.setDataType(BaseController.COMPANY_TYPE_COMPANY);
            dto.setUnitCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(info.getCompany().getCompanyType()) ?
                    info.getCompany().getCompanyCode().split("_")[1] : info.getCompany().getCompanyCode());
        } else {
            dto.setDataType(BaseController.COMPANY_TYPE_SUPERVISION);
            dto.setReceiveCompanyCode(info.getCompany().getCompanyCode());
            dto.setSupervisionOrgCode(info.getCompany().getOrgCode());
        }
        iJgTableDataExportService.registration(response, dto, client);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationUnit")
    @ApiOperation(httpMethod = "GET", value = "单位变更列表数据导出", notes = "单位变更列表数据导出")
    public void changeRegistrationUnitExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.changeRegistrationUnit(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationReform")
    @ApiOperation(httpMethod = "GET", value = "改造登记列表数据导出", notes = "改造登记列表数据导出")
    public void changeRegistrationReformExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.changeRegistrationReform(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/enableDisable")
    @ApiOperation(httpMethod = "GET", value = "启用停用列表数据导出", notes = "启用停用列表数据导出")
    public void enableDisableExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.enableDisable(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/scrapCancel")
    @ApiOperation(httpMethod = "GET", value = "注销报废列表数据导出", notes = "注销报废列表数据导出")
    public void scrapCancelExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.scrapCancel(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationTransfer")
    @ApiOperation(httpMethod = "GET", value = "移装变更列表数据导出", notes = "移装变更列表数据导出")
    public void changeRegistrationTransferExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.changeRegistrationTransfer(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeRegistrationName")
    @ApiOperation(httpMethod = "GET", value = "更名变更列表数据导出", notes = "更名变更列表数据导出")
    public void changeRegistrationNameExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.changeRegistrationName(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/vehicleInformation")
    @ApiOperation(httpMethod = "GET", value = "车气登记列表数据导出", notes = "车气登记列表数据导出")
    public void vehicleInformationExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.vehicleInformation(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/changeVehicleRegistrationUnit")
    @ApiOperation(httpMethod = "GET", value = "车用气瓶变更列表数据导出", notes = "车用气瓶变更列表数据导出")
    public void changeVehicleRegistrationUnitExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.changeVehicleRegistrationUnit(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/unregulatedEquip")
    @ApiOperation(httpMethod = "GET", value = "未纳管设备列表数据导出", notes = "未纳管设备列表数据导出")
    public ResponseModel<String> unregulatedEquipExport(@RequestParam Map<String, Object> map) {
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("未纳管设备列表数据", uuid);
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.unregulatedEquip(uuid, map);
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/manageEquipment")
    @ApiOperation(httpMethod = "GET", value = "已纳管设备列表数据导出", notes = "已纳管设备列表数据导出")
    public ResponseModel<String> manageEquipmentExport(@RequestParam Map<String, Object> map) {
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("已纳管设备列表数据", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.manageEquipment(uuid, map);
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipTransfer")
    @ApiOperation(httpMethod = "GET", value = "设备移交列表数据导出", notes = "设备移交列表数据导出")
    public void equipTransferExport(HttpServletResponse response, String ids) {
        Assert.hasText(ids, "未选择导出数据");
        iJgTableDataExportService.equipTransfer(response, Arrays.asList(ids.split(",")));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/unregulatedPipe")
    @ApiOperation(httpMethod = "GET", value = "未纳管压力管道列表数据导出", notes = "未纳管压力管道列表数据导出")
    public ResponseModel<String> unregulatedPipe(@RequestParam Map<String, String> params,
                                                 @RequestParam(value = "sort", required = false) String sort) {
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("未纳管压力管道列表", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.unregulatedPipe(uuid, params, sort, getSelectedOrgInfo());
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/managePipe")
    @ApiOperation(httpMethod = "GET", value = "已纳管压力管道列表数据导出", notes = "已纳管压力管道列表数据导出")
    public ResponseModel<String> managePipe(@RequestParam Map<String, String> params,
                                            @RequestParam(value = "sort", required = false) String sort) {
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("已纳管压力管道列表", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.managePipe(uuid, params, sort, getSelectedOrgInfo());
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/enterpriseInformationExport")
    @ApiOperation(httpMethod = "GET", value = "基础设置-企业信息列表数据导出", notes = "基础设置-企业信息列表数据导出")
    public ResponseModel<String> managePipe(@RequestParam(value = "ids", required = false) String ids,
                                            @RequestParam Map<String, Object> map) {
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("企业信息列表", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.enterpriseInformationExport(uuid, ids, map);
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/userInfoExport")
    @ApiOperation(httpMethod = "GET", value = "基础设置-企业-人员信息列表数据导出", notes = "基础设置-企业-人员信息列表数据导出")
    public ResponseModel<String> userInfoExport(@RequestParam(value = "ids", required = false) String ids,
                                                @RequestParam(value = "sort", required = false) String sort,
                                                @RequestParam Map<String, Object> map) {
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("人员信息列表", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.userInfoExport(uuid, ids, map);
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/userInfoExportWithAdmin")
    @ApiOperation(httpMethod = "POST", value = "基础设置-监管单位-人员信息列表数据导出", notes = "基础设置-监管单位-人员信息列表数据导出")
    public ResponseModel<String> userInfoExportWithAdmin(@RequestParam(value = "ids", required = false) String ids,
                                                         @RequestBody Map<String, Object> map) {
        String uuid = UUID.randomUUID().toString();
        iJgTableDataExportService.startDownLoadMsg("人员信息列表", uuid);
        RequestContextWrapper contextWrapper = RequestContextWrapper.capture();
        new Thread(() -> {
            contextWrapper.apply();
            iJgTableDataExportService.userInfoExportWithAdmin(uuid, ids, map);
        }).start();
        return ResponseHelper.buildResponse("后台处理中，请注意下载！");
    }


    /**
     * 西安电梯设备数据导出
     * @param beginDate 开始时间
     * @param endDate 结束时间
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportXianElevatorData")
    @ApiOperation(httpMethod = "GET", value = "西安电梯设备数据导出", notes = "西安电梯设备数据导出")
    public void exportXianData(HttpServletResponse response,@ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
                                                @ApiParam(value = "结束日期", required = true) @RequestParam String endDate) {
        iJgTableDataExportService.exportXianElevatorData(response, beginDate, endDate);
    }
}
