package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.common.api.constant.TZSCommonConstant;
import com.yeejoin.amos.boot.module.common.biz.refresh.DataRefreshEvent;
import com.yeejoin.amos.boot.module.jg.api.common.PipLenCalUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.DynamicColumnDto;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jyjc.api.common.StringUtil;
import com.yeejoin.amos.boot.module.jyjc.api.dto.PipelineInspectionResultDto;
import com.yeejoin.amos.boot.module.jyjc.api.dto.PipelineResultItemDto;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionHistory;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.enums.*;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultDataModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultAttachmentService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultService;
import com.yeejoin.amos.boot.module.jyjc.api.vo.JyjcInspectionResultVo;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionDetectionSaveToDbEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.BizEmqPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jyjc.biz.util.JsonUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgTechParamsPipeline;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.feign.systemctl.model.DictionarieModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jyjc.api.enums.CategoryEnum.getCategoryByType;

/**
 * 业务开通申请表服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
@Slf4j
public class JyjcInspectionResultServiceImpl extends BaseService<JyjcInspectionResultModel, JyjcInspectionResult, JyjcInspectionResultMapper> implements IJyjcInspectionResultService {

    private static final String JYJC_SUBMIT_FILE_PREFIX = "JYJC_";
    private static final String JYJC_SUBMIT_FILE_JYBG = "JYBG";
    private static final String JYJC_SUBMIT_KEY = "inspectResult";
    private static final String EQU_LIST = "equip";
    private static final String JYJC_RESULT_STATUS = "2";

    @Autowired
    private IJyjcInspectionResultAttachmentService iJyjcInspectionResultAttachmentService;

    @Autowired
    private IJyjcInspectionResultParamService iJyjcInspectionResultParamService;

    @Value("classpath:/json/equipCategory.json")
    private Resource equipCategory;

    @Autowired
    JyjcInspectionResultMapper resultMapper;

    @Autowired
    JyjcInspectionResultParamServiceImpl resultParamService;
    @Autowired
    JyjcInspectionResultAttachmentServiceImpl attachmentService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    UseInfoMapper useInfoMapper;

    @Autowired
    IdxBizJgInspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    @Autowired
    private SnowflakeIdUtil sequence;

    @Autowired
    CommonServiceImpl commonService;

    @Autowired
    TzsUserInfoMapper tzsUserInfoMapper;

    @Autowired
    EventPublisher eventPublisher;

    @Autowired
    BizEmqPublisher bizEmqPublisher;

    @Autowired
    private CommonMapper jgCommonMapper;

    @Autowired
    private ObjectMapper objectMapper;

    @Autowired
    private IdxBizJgTechParamsPipelineMapper techParamPipelineMapper;

    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;

    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;

    @Autowired
    JyjcInspectionHistoryServiceImpl jyjcInspectionHistoryService;

    @Autowired
    private IdxBizJgInspectionDetectionInfoMapper idxBizJgInspectionDetectionInfoMapper;

    @Autowired
    private EmqKeeper emqKeeper;

    @javax.annotation.Resource
    private IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper;


    /**
     * 检验检测单位分页查询
     */
    public Page<JyjcInspectionResultModel> queryForJyjcInspectionResultPage(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model, boolean type) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        if (type) {
            // 检验检测单位分页查询
            model.setInspectionUnitCode(CommonServiceImpl.getUnitCode(reginParams.getCompany()));
        } else {
            // 报检单位分页查询
            model.setApplicationUnitCode(CommonServiceImpl.getUnitCode(reginParams.getCompany()));
        }
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectJyjcInspectionResultpPage(page, model);
        resultPage.getRecords().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            }
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
            }
        });
        return resultPage;
    }

    public Page<JyjcInspectionResultModel> queryForPageList(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model, String sort) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        SortVo sortMap = commonService.sortFieldConversion(sort);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        // 判断当前登录人身份（报检机构、接收机构、即时报检又是接收机构、都不是（不存在此情况））
        String identity = CommonServiceImpl.getCompanyIdentityByType(reginParams.getCompany().getCompanyType());
        model.setCompanyCode(CommonServiceImpl.getUnitCode(reginParams.getCompany()));
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectForPage(page, model, identity, sortMap, reginParams.getCompany().getCompanyType());
        resultPage.getRecords().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            }
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
            }
            v.setSourceResult(ResultTypeEnum.getNameByCode(v.getResultType()));
            v.setIdentity(identity);
            v.setUseInnerCode("null".equals(v.getUseInnerCode()) ? "" : v.getUseInnerCode());
        });
        return resultPage;
    }


    static String getPersonIdentityByType(String companyType) {
        if ("使用单位".equals(companyType)) {
            return String.join(",", Arrays.asList(BizTypeEnum.FIRST_INSPECTION.getCode(), BizTypeEnum.DETECTION.getCode()));
        } else if ("安装改造维修单位".equals(companyType)) {
            return String.join(",", Arrays.asList(BizTypeEnum.SUPERVISE.getCode(), BizTypeEnum.DETECTION.getCode()));
        } else {
            return null;
        }
    }


    public JyjcInspectionResultAttachment getReportAttachment(Long resultSeq) {
        return Optional.ofNullable(attachmentService.getOneByUniKey(resultSeq, JYJC_SUBMIT_FILE_JYBG)).orElse(new JyjcInspectionResultAttachment());
    }

    @Transactional(rollbackFor = Exception.class)
    public JyjcInspectionResultModel updateJyjcInspectionResult(Map<String, Map<String, Object>> tableModel) {

        Map<String, Object> map = tableModel.get(JYJC_SUBMIT_KEY);

        JyjcInspectionResultModel model = BeanUtil.mapToBean(map, JyjcInspectionResultModel.class, true);
        String inspector = model.getInspector();
        if (StringUtil.isNotEmpty(inspector)) {
            List jsonArray = JSONArray.parseArray(inspector);
            Object inspectors = jsonArray.stream().map(String::valueOf).collect(Collectors.joining(","));
            model.setInspector(String.valueOf(inspectors));
        }
        model.setResultStatus(JYJC_RESULT_STATUS);

        // 更新结果主表
        updateWithModel(model);

        // 更新附件表
        List<JyjcInspectionResultAttachment> attachmentList = new ArrayList<>();
        LambdaQueryWrapper<JyjcInspectionResultAttachment> fileWrapper = new LambdaQueryWrapper<>();
        fileWrapper.eq(JyjcInspectionResultAttachment::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultAttachment> fileList = attachmentService.list(fileWrapper);
        JyjcInspectionResultAttachment jybgFile = new JyjcInspectionResultAttachment();

        map.forEach((k, v) -> {
            if (k.contains(JYJC_SUBMIT_FILE_PREFIX)) {
                JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
                attachment.setResultSeq(model.getSequenceNbr());
                attachment.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                attachment.setAttachmentType(k);
                // 新增时需要判断之前有就更新
                if (!CollectionUtils.isEmpty(fileList)) {
                    List<JyjcInspectionResultAttachment> collect = fileList.stream().filter(obj -> k.equals(obj.getAttachmentType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect)) {
                        JyjcInspectionResultAttachment jyjcInspectionResultAttachment = collect.get(0);
                        attachment.setSequenceNbr(jyjcInspectionResultAttachment.getSequenceNbr());
                    }
                }
                attachmentList.add(attachment);
                if (k.contains(JYJC_SUBMIT_FILE_JYBG)) {
                    jybgFile.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                    attachment.setAttachmentType(k);
                }
            }
        });
        if (!CollectionUtils.isEmpty(attachmentList)) {
            attachmentService.saveOrUpdateBatch(attachmentList);
        }

        // 更新参数表
        LambdaQueryWrapper<JyjcInspectionResultParam> paramWrapper = new LambdaQueryWrapper<>();
        paramWrapper.eq(JyjcInspectionResultParam::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultParam> params = resultParamService.list(paramWrapper);
        List<JyjcInspectionResultParam> paramList = new ArrayList<>();
        tableModel.forEach((k, v) -> {
            if (!JYJC_SUBMIT_KEY.equals(k) && !ObjectUtils.isEmpty(tableModel.get(k))) {
                List<JyjcInspectionResultParam> collect = params.stream().filter(p -> k.equals(p.getParamType())).collect(Collectors.toList());
                JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
                if (!CollectionUtils.isEmpty(collect)) {
                    resultParam.setSequenceNbr(collect.get(0).getSequenceNbr());
                }
                resultParam.setParamType(k);
                resultParam.setResultSeq(model.getSequenceNbr());
                resultParam.setParamJson(JSON.toJSONString(tableModel.get(k)));
                paramList.add(resultParam);
            }
        });
        if (!CollectionUtils.isEmpty(paramList)) {
            resultParamService.saveOrUpdateBatch(paramList);
        }
        JyjcInspectionResultModel dbResultModel = this.queryBySeq(model.getSequenceNbr());
        // 更新使用信息、检验信息、技术参数
        Set<String> records = this.updateTechParamAndInspectInfo(dbResultModel, jybgFile);
        return dbResultModel;
    }

    public void sendDataRefreshMsg(Set<String> records) {
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                try {
                    log.info("设备检验信息变化发送数据变更mqtt消息, 设备：{}", records);
                    emqKeeper.getMqttClient().publish(String.format(TZSCommonConstant.DATA_REFRESH_TOPIC, DataRefreshEvent.DataType.equipment.name(), DataRefreshEvent.Operation.UPDATE), JSONObject.toJSONString(new ArrayList<>(records)).getBytes(StandardCharsets.UTF_8), 2, false);
                } catch (MqttException e) {
                    log.error("发送数据变更emq消息失败：{}", e.getMessage(), e);
                }
            }
        });
    }


    private Set<String> updateTechParamAndInspectInfo(JyjcInspectionResultModel model, JyjcInspectionResultAttachment jybgFile) {
        Set<String> records = new HashSet<>();
        if (model.getEquList().equals(EquipmentClassifityEnum.YLGD.getCode())) {
            // 管道逻辑： 循环更新技术参数、检验信息更新或者插入、使用信息更新(数据库及es)
            JyjcInspectionResultParam param = iJyjcInspectionResultParamService.getOneParamByResultSeq(model.getSequenceNbr());
            if (!ObjectUtils.isEmpty(param.getParamJson())) {
                JSONObject paramObj = JSON.parseObject(param.getParamJson());
                try {
                    List<Map<String, Object>> equips = objectMapper.readValue(
                            objectMapper.writeValueAsString(paramObj.get("equip")),
                            new TypeReference<ArrayList<Map<String, Object>>>() {
                            }
                    );
                    equips.forEach(e -> {
                        String record = String.valueOf(e.get("record"));
                        records.add(record);
                        // 1.更新管道的技术参数
                        doUpdatePipelineTechParams(e, record, techParamPipelineMapper);
                        // 2.检验信息更新或者插入
                        IdxBizJgInspectionDetectionInfo info = new IdxBizJgInspectionDetectionInfo();
                        LambdaQueryWrapper<IdxBizJgInspectionDetectionInfo> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(IdxBizJgInspectionDetectionInfo::getResultSeq, model.getSequenceNbr());
                        wrapper.eq(IdxBizJgInspectionDetectionInfo::getRecord, record);
                        List<IdxBizJgInspectionDetectionInfo> list = idxBizJgInspectionDetectionInfoMapper.selectList(wrapper);
                        if (CollectionUtils.isEmpty(list)) {
                            // 无则插入
                            commonService.buildInspectInfo(model, info, jybgFile, record);
                            info.setSequenceNbr(sequence.nextId() + "");
                            idxBizJgInspectionDetectionInfoMapper.insert(info);
                            // 对方不查询库 所以无事务操作
                            bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
                        } else {
                            // 已经维护过则更新
                            info = list.get(0);
                            commonService.buildInspectInfo(model, info, jybgFile, record);
                            idxBizJgInspectionDetectionInfoMapper.updateById(info);
                            // 对方不查询库 所以无事务操作
                            bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
                        }
                        // 3.更新使用信息表，最新检验信息
                        useInfoMapper.updateByRecord(record, model.getNextInspectionDate(), model.getInspectionType(), model.getApplicationNo());
                        // 4.更新es下次检验日期
                        commonService.updateEquipNextInspectDate(model, record);
                    });
                    // 更新装置的汇总的管道长度
                    calAndWriteTotalPipelineLength(model.getEquipUnicode());
                } catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            // 台套逻辑： 单条更新技术参数、检验信息更新或者插入、使用信息更新(数据库及es)
            // 1.动态更新技术参数
            updateTechParam(model.getSequenceNbr(), model.getEquipUnicode());
            // 2.检验信息更新或者插入
            IdxBizJgInspectionDetectionInfo info = new IdxBizJgInspectionDetectionInfo();
            QueryWrapper<IdxBizJgInspectionDetectionInfo> wrapper = new QueryWrapper<>();
            wrapper.lambda().eq(IdxBizJgInspectionDetectionInfo::getResultSeq, model.getSequenceNbr());
            List<IdxBizJgInspectionDetectionInfo> list = idxBizJgInspectionDetectionInfoMapper.selectList(wrapper);
            if (CollectionUtils.isEmpty(list)) {
                commonService.buildInspectInfo(model, info, jybgFile, model.getEquipUnicode());
                info.setSequenceNbr(sequence.nextId() + "");
                idxBizJgInspectionDetectionInfoMapper.insert(info);
                // 对方不查询库 所以无事务操作
                bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
            } else {
                info = list.get(0);
                commonService.buildInspectInfo(model, info, jybgFile, model.getEquipUnicode());
                idxBizJgInspectionDetectionInfoMapper.updateById(info);
                // 对方不查询库 所以无事务操作
                bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
            }
            // 3.更新使用信息表最新的检验信息
            useInfoMapper.updateByRecord(model.getEquipUnicode(), model.getNextInspectionDate(), model.getInspectionType(), model.getApplicationNo());
            // 4.es更新下次检验日期
            commonService.updateEquipNextInspectDate(model, model.getEquipUnicode());
            records.add(model.getEquipUnicode());
        }
        return records;
    }


    public void calAndWriteTotalPipelineLength(String projectContraptionId) {
        List<IdxBizJgTechParamsPipeline> allPipeLines = idxBizJgProjectContraptionMapper.selectPipelineListByProjectContraptionId(projectContraptionId);
        Double totalPipelineLength = allPipeLines.stream().map(IdxBizJgTechParamsPipeline::getPipeLength).filter(Objects::nonNull).map(this::parseToBigDecimal)
                .reduce(BigDecimal.ZERO, BigDecimal::add)
                .setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().doubleValue();
        LambdaUpdateWrapper<IdxBizJgProjectContraption> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(com.yeejoin.amos.boot.biz.common.entity.BaseEntity::getSequenceNbr, projectContraptionId);
        updateWrapper.set(IdxBizJgProjectContraption::getPipelineLength, totalPipelineLength);
        idxBizJgProjectContraptionMapper.update(null, updateWrapper);
    }

    private BigDecimal parseToBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        } catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public void updateTechParam(Long resultSeq, String record) {
        List<DynamicColumnDto> columns = new ArrayList<>();
        JyjcInspectionResultParam param = iJyjcInspectionResultParamService.getOneParamByResultSeq(resultSeq);
        if (param != null) {
            if (!ObjectUtils.isEmpty(param.getParamJson())) {
                JSONObject paramObj = JSON.parseObject(param.getParamJson());
                paramObj.forEach((k, v) -> {
                    DynamicColumnDto columnDto = new DynamicColumnDto();
                    columnDto.setColumnName(String.format("\"%s\"", StrUtil.toUnderlineCase(k).toUpperCase()));
                    columnDto.setColumnValue(v == null ? null : String.valueOf(v));
                    columns.add(columnDto);
                });
                String tableName = this.getTableName(param.getParamType());
                jgCommonMapper.updateTechParamDynamic(tableName, record, columns);
            }
        }
    }

    private String getTableName(String paramType) {
        return String.format("\"%s\"", StrUtil.toUnderlineCase(paramType));
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionResultModel> queryForJyjcInspectionResultList() {
        return this.queryForList("", false);
    }

    @Override
    public Map<String, Object> queryDetailBySeq(Long sequenceNbr) {
        Map<String, Object> map = new HashMap<>();
        Map<String, Object> resultMap = new HashMap<>(9);

        JyjcInspectionResultModel jyjcInspectionResultModel = this.queryBySeq(sequenceNbr);
        if (!ObjectUtils.isEmpty(jyjcInspectionResultModel)) {
            // 对象转map
            map = BeanUtil.beanToMap(jyjcInspectionResultModel);

            // 获取附件
            List<JyjcInspectionResultAttachment> attachmentList = iJyjcInspectionResultAttachmentService.getObjByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(attachmentList)) {
                Map<String, Object> attachmentMap = attachmentList.stream().map(obj -> {
                    if (StringUtil.isNotEmpty(obj.getAttachmentUrl())) {
                        obj.setAttachmentUrlList(JSONArray.parseArray(obj.getAttachmentUrl()));
                    }
                    return obj;
                }).collect(Collectors.toMap(JyjcInspectionResultAttachment::getAttachmentType, JyjcInspectionResultAttachment::getAttachmentUrlList));
                map.putAll(attachmentMap);
            }
            // 获取技术参数
            List<JyjcInspectionResultParam> paramList = iJyjcInspectionResultParamService.getParamByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(paramList)) {
                Map<String, Object> finalMap = map;
                paramList.forEach(param -> {
                    if (!ObjectUtils.isEmpty(param.getParamJson())) {
                        JSONObject paramObj = JSON.parseObject(String.valueOf(param.getParamJson()));
                        paramObj.put("equList", finalMap.get("equList"));
                        paramObj.put("equCategory", finalMap.get("equCategory"));
                        paramObj.put("inspectionType", jyjcInspectionResultModel.getInspectionType());
                        resultMap.put(param.getParamType(), paramObj);
                    }
                });
            }
        }
        resultMap.put(JYJC_SUBMIT_KEY, map);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> equipList(String type, String notNode) {
        List<Map<String, Object>> menus = new ArrayList<>();
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(equipCategory);
        List<Map<String, Object>> mapList;
        if (ValidationUtil.isEmpty(type)) {
            mapList = resourceJson.get(EquipmentClassifityEnum.BDLS.getCode());
        } else {
            mapList = resourceJson.get(type);
        }

        mapList.stream().filter(map -> {
            if (!ObjectUtils.isEmpty(notNode)) {
                String[] code = notNode.split(",");
                List<String> codeList = Arrays.asList(code);
                return !codeList.contains(map.get("code"));
            }
            return true;
        }).forEach(obj -> {
            Map<String, Object> resultMap = new HashMap<>(2);
            resultMap.put("instanceName", obj.get("name"));
            resultMap.put("instanceId", obj.get("code"));
            menus.add(resultMap);
        });

        return menus;
    }

    @Transactional(rollbackFor = Exception.class)
    public List<JyjcInspectionResultDataModel> receivePushResultData(List<JyjcInspectionResultDataModel> resultDataModels) {
        log.info("收到检验检测厂商推送的结果数据：{}", JSONArray.toJSONString(resultDataModels));
        // 1.数据合法性检查
        this.checkMustFieldIsValid(resultDataModels);
        // 2.组织数据
        List<JyjcInspectionResult> resultList = queryResultList(resultDataModels.stream().map(JyjcInspectionResultDataModel::getApplicationNo).collect(Collectors.toList()));
        // key为{record}， value为{JyjcInspectionResult}，首次检验时，设备无监管码，用record作为设备标识，可适用与所有的检验结果的接收
        Map<String, JyjcInspectionResult> recordResultMap = getRecordKeyResultMap(resultList);
        // key为{supervisoryCode}， value为{JyjcInspectionResult} ，适用于非首次检验之外的检验结果接收
        Map<String, JyjcInspectionResult> superviseCodeKeyResultMap = getSuperviseCodeKeyResultMap(resultList);
        List<JyjcInspectionResult> updateResultList = new ArrayList<>();
        List<JyjcInspectionResultAttachment> resultAttachments = new ArrayList<>();
        List<JyjcInspectionResultParam> resultParams = new ArrayList<>();
        resultDataModels.forEach(r -> {
            JyjcInspectionResult result = this.getJyjcInspectionResult(r, recordResultMap, superviseCodeKeyResultMap);
            if (result != null) {
                // 填充主表数据
                this.fillResultData(r, result, updateResultList);
                // 填充附件数据
                this.fillResultAttachmentData(r, result, resultAttachments);
                // 填充技术参数数据
                this.fillResultParamData(r, result, resultParams);
            }
        });
        // 3.数据入库
        if (!updateResultList.isEmpty()) {
            // 3.1 批量保存主表数据
            this.updateBatchById(updateResultList);
            // 3.2 批量保存子表数据
            deleteAndCreateSubTable(updateResultList, resultAttachments, resultParams);
            // 3.4 异步更新设备的检验检测信息
            eventPublisher.publish(new InspectionDetectionSaveToDbEvent(this, new ArrayList<>(updateResultList)));
        }
        return resultDataModels;
    }

    private void checkMustFieldIsValid(List<JyjcInspectionResultDataModel> resultDataModels) {
        int i = 0;
        for (JyjcInspectionResultDataModel resultDataModel : resultDataModels) {
            i++;
            if (StringUtils.isEmpty(resultDataModel.getEquipId()) && StringUtils.isEmpty(resultDataModel.getSupervisoryCode())) {
                throw new BadRequest("第" + i + "条数据存在问题，supervisoryCode和equipId不能同时为空！");
            }
        }
    }

    private JyjcInspectionResult getJyjcInspectionResult(JyjcInspectionResultDataModel resultDataModel,
                                                         Map<String, JyjcInspectionResult> recordResultMap,
                                                         Map<String, JyjcInspectionResult> superviseCodeKeyResultMap) {
        if (StringUtils.isNotEmpty(resultDataModel.getEquipId())) {
            return recordResultMap.get(resultDataModel.getApplicationNo() + ":" + resultDataModel.getEquipId());
        }
        if (StringUtils.isNotEmpty(resultDataModel.getSupervisoryCode())) {
            return superviseCodeKeyResultMap.get(resultDataModel.getApplicationNo() + ":" + resultDataModel.getSupervisoryCode());
        }
        return null;
    }


    private void deleteAndCreateSubTable(List<JyjcInspectionResult> resultList, List<JyjcInspectionResultAttachment> resultAttachments, List<JyjcInspectionResultParam> resultParams) {
        List<Long> resultIds = resultList.stream().map(BaseEntity::getSequenceNbr).collect(Collectors.toList());
        if (!resultAttachments.isEmpty()) {
            attachmentService.remove(new LambdaQueryWrapper<JyjcInspectionResultAttachment>().in(JyjcInspectionResultAttachment::getResultSeq, resultIds));
            attachmentService.saveBatch(resultAttachments);
        }
        if (!resultParams.isEmpty()) {
            resultParamService.remove(new LambdaQueryWrapper<JyjcInspectionResultParam>().in(JyjcInspectionResultParam::getResultSeq, resultIds));
            resultParamService.saveBatch(resultParams);
        }
    }


    private void fillResultParamData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResultParam> resultParams) {
        JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
        resultParam.setResultSeq(jyjcInspectionResult.getSequenceNbr());
        resultParam.setParamJson(JSON.toJSONString(r.getTechParams()));
        resultParam.setRecUserId(RequestContext.getExeUserId());
        resultParam.setRecDate(new Date());
        resultParam.setRemark("同步数据");
        // 将设备种类code换成技术参数枚举
        resultParam.setParamType(this.getTypeByEquipList(jyjcInspectionResult.getEquList()));
        resultParams.add(resultParam);
    }

    private void fillResultParamData(PipelineInspectionResultDto r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResultParam> resultParams) {
        List<JyjcInspectionResultParam> paramList = iJyjcInspectionResultParamService.getParamByResultSeq(jyjcInspectionResult.getSequenceNbr());
        if (!paramList.isEmpty()) {
            JyjcInspectionResultParam resultParam = paramList.get(0);
            resultParam.setRecUserId(RequestContext.getExeUserId());
            resultParam.setRecDate(new Date());
            resultParam.setRemark("同步数据");
            String fullParamJsonStr = resultParam.getParamJson();
            JSONObject paramObj = JSON.parseObject(fullParamJsonStr);
            try {
                List<Map<String, Object>> equips = objectMapper.readValue(
                        objectMapper.writeValueAsString(paramObj.get("equip")),
                        new TypeReference<ArrayList<Map<String, Object>>>() {
                        }
                );
                Map<String, PipelineResultItemDto> recordResultMap = r.getInspectionEquips().stream().collect(Collectors.toMap(PipelineResultItemDto::getEquipId, Function.identity()));
                equips.forEach(e -> {
                    PipelineResultItemDto resultItemDto = recordResultMap.get(e.get("record").toString());
                    if (resultItemDto != null) {
                        BeanUtil.copyProperties(resultItemDto, e);
                    }
                });
                // 管道长度更新为最新的
                paramObj.put("pipelineLength", JyjcInspectionApplicationServiceImpl.calTotalLength(equips));
                paramObj.put("equip", equips);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            resultParam.setParamJson(paramObj.toJSONString());
            resultParams.add(resultParam);
        }
    }


    private String getTypeByEquipList(String equList) {
        EquipCategoryEnum categoryEnum = EquipCategoryEnum.of(Integer.parseInt(equList));
        assert categoryEnum != null;
        // 前端为枚举类名称的驼峰形式且首字母大写，故进行格式转化换
        return StrUtil.upperFirst(StrUtil.toCamelCase(categoryEnum.name()));
    }

    private void fillResultAttachmentData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResultAttachment> resultAttachments) {
        r.getAttachments().forEach(a -> {
            JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
            attachment.setResultSeq(jyjcInspectionResult.getSequenceNbr());
            attachment.setAttachmentType(a.getAttachmentType());
            attachment.setAttachmentUrl(JSON.toJSONString(a.getAttachmentContent()));
            attachment.setRecUserId(RequestContext.getExeUserId());
            attachment.setRecDate(new Date());
            attachment.setRemark("同步数据");
            resultAttachments.add(attachment);
        });
    }

    private void fillResultData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResult> updateResultList) {
        jyjcInspectionResult.setResultStatus(ResultStatusEnum.YES_RESULT.getCode());
        jyjcInspectionResult.setLicenseNumber(r.getLicenseNumber());
        jyjcInspectionResult.setResultNo(r.getResultNo());
        jyjcInspectionResult.setInnerPersonCode(r.getInnerPersonCode());
        jyjcInspectionResult.setInspector(this.getUserSeqByPersonCode(r.getInnerPersonCode()));
        jyjcInspectionResult.setInspectionConclusion(r.getInspectionConclusion());
        jyjcInspectionResult.setInspectionDate(r.getInspectionDate());
        jyjcInspectionResult.setNextInspectionDate(r.getNextInspectionDate());
        jyjcInspectionResult.setInspectionStartDate(r.getInspectionStartDate());
        jyjcInspectionResult.setInspectionEndDate(r.getInspectionEndDate());
        jyjcInspectionResult.setInspectionResultSummary(r.getInspectionResultSummary());
        jyjcInspectionResult.setNonConformance(JSON.toJSONString(r.getNonConformance()));
        jyjcInspectionResult.setRemark("同步数据");
        jyjcInspectionResult.setTraceId(r.getTraceId());
        updateResultList.add(jyjcInspectionResult);
    }

    private String getUserSeqByPersonCode(String innerPersonCode) {
        if (StrUtil.isNotEmpty(innerPersonCode)) {
            List<TzsUserInfo> tzsUserInfos = tzsUserInfoMapper.selectList(new LambdaQueryWrapper<TzsUserInfo>()
                    .in(TzsUserInfo::getCertificateNum, Arrays.asList(innerPersonCode.split(",")))
                    .select(com.yeejoin.amos.boot.biz.common.entity.BaseEntity::getSequenceNbr));
            return tzsUserInfos.stream().map(u -> u.getSequenceNbr() + "").collect(Collectors.joining(","));
        }
        log.error("检验人员内部编号为空");
        return "";
    }

    private Map<String, JyjcInspectionResult> getSuperviseCodeKeyResultMap(List<JyjcInspectionResult> resultList) {
        return resultList.stream().filter(r -> StringUtils.isNotEmpty(r.getSupervisoryCode())).collect(Collectors.toMap((c) -> c.getApplicationNo() + ":" + c.getSupervisoryCode(), Function.identity()));
    }

    private Map<String, JyjcInspectionResult> getRecordKeyResultMap(List<JyjcInspectionResult> resultList) {
        return resultList.stream().collect(Collectors.toMap((c) -> c.getApplicationNo() + ":" + c.getEquipUnicode(), Function.identity()));
    }

    private List<JyjcInspectionResult> queryResultList(List<String> applicationNos) {
        LambdaQueryWrapper<JyjcInspectionResult> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(JyjcInspectionResult::getApplicationNo, applicationNos);
        return this.list(wrapper);
    }

    public List<DictionarieModel> inspectTypeListByPerson(ReginParams selectedOrgInfo) {
        String groups = getPersonIdentityByType(selectedOrgInfo.getCompany().getCompanyType());
        return JyjcInspectionApplicationServiceImpl.getDictionarieModels(groups);
    }

    @Async
    public void updatePlanCreateDateByAppNo(String appNo) {
        LambdaUpdateWrapper<JyjcInspectionResult> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(JyjcInspectionResult::getApplicationNo, appNo);
        updateWrapper.set(JyjcInspectionResult::getPlanCreateDate, new Date());
        this.update(updateWrapper);
    }

    /**
     * 检验检测结果列表数据导出
     *
     * @param response
     * @param ids
     */
    public void Export(HttpServletResponse response, List<String> ids) {
        List<JyjcInspectionResultVo> exportData = this.baseMapper.queryExportInIds(ids);
        for (JyjcInspectionResultVo vo : exportData) {
            if (vo.getResultStatus().equals("1")) {
                vo.setResultStatus("未出");
            } else if (vo.getResultStatus().equals("2")) {
                vo.setResultStatus("已出");
            }
        }
        ExcelUtil.createTemplate(response, "检验检测结果列表数据", "检验检测结果列表", exportData, JyjcInspectionResultVo.class, null, false);
    }

    private String getDictNameByCode(String code) {
        DataDictionary dataDictionary = dataDictionaryService.getByCode(code, "JYJC");
        return dataDictionary != null ? dataDictionary.getName() : "";
    }


    /**
     * 使用单位录入检验结果
     *
     * @param entryData
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean useUnitEntryWithSave(Map<String, Object> entryData, ReginParams reginParams) {
        Set<String> records = new HashSet<>();
        boolean isYLGD = "8000".equals(Objects.toString(entryData.get("equList")));
        JSONArray equList = JSON.parseArray(JSON.toJSONString(entryData.get(EQU_LIST)));
        List<String> applicationNos = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.JY.getCode(), equList.size()).getResult();
        for (int i = 0; i < equList.size(); i++) {
            JSONObject equ = JSON.parseObject(equList.get(i).toString());
            Long resSeq = sequence.nextId();
            // 保存结果表数据
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                JyjcInspectionResult jyjcInspectionResult = new JyjcInspectionResult()
                        .setInspectionUnitCode(Objects.toString(entryData.getOrDefault("inspectOrgCode", "")))
                        .setApplicationNo(applicationNos.get(i))
                        .setApplicationUnitCode(CommonServiceImpl.getUnitCode(reginParams.getCompany()))
                        .setEquipUnicode(Objects.toString(equ.get("record")))
                        .setResultStatus(ResultStatusEnum.YES_RESULT.getCode())
                        .setLicenseNumber(null)
                        .setResultNo(Objects.toString(entryData.getOrDefault("inspectReportNo", "")))
                        .setInnerPersonCode(null)
                        .setInspectionConclusion(Objects.toString(entryData.getOrDefault("inspectConclusion", "")))
                        .setInspectionDate(sdf.parse(entryData.get("inspectDate").toString()))
                        .setNextInspectionDate(sdf.parse(entryData.get("nextInspectionDate").toString()))
                        .setApplicationDate(ObjectUtils.isEmpty(entryData.get("applicationDate")) ? null : sdf.parse(Objects.toString(entryData.get("applicationDate"))))
                        .setInspectionStartDate(null)
                        .setInspectionEndDate(null)
                        .setInspectionResultSummary(null)
                        .setNonConformance(null)
                        .setInspectionType(Objects.toString(entryData.get("inspectType")))
                        .setRemark(null)
                        .setBizType(getCategoryByType(JYJCTypeEnum.of(Objects.toString(entryData.get("inspectType")))))
                        .setEquCategory(isYLGD ? Objects.toString(equ.getOrDefault("equCategory", "")) : Objects.toString(equ.getOrDefault("EQU_CATEGORY_CODE", "")))
                        .setInspectionTypeName(this.getDictNameByCode(Objects.toString(entryData.get("inspectType"))))
                        .setResultType(ResultTypeEnum.USEUNITENTRY.getCode())
                        .setEquList(isYLGD ? Objects.toString(equ.getOrDefault("equList", "")) : Objects.toString(equ.getOrDefault("EQU_LIST_CODE", "")))
                        .setEquDefine(isYLGD ? Objects.toString(equ.getOrDefault("equDefine", "")) : Objects.toString(equ.getOrDefault("EQU_DEFINE_CODE", "")))
                        .setTraceId(null)
                        .setInspectionUnitName(Objects.toString(entryData.getOrDefault("inspectOrgName", "")))
                        .setApplicationUnitName(reginParams.getCompany().getCompanyName())
                        .setSupervisoryCode(Objects.toString(equ.getOrDefault("SUPERVISORY_CODE", "")))
                        .setIsExistNc(null)
                        .setSafetyLevel(Objects.toString(equ.getOrDefault("safetyLevel", "")))
                        .setManageType("single");
                jyjcInspectionResult.setSequenceNbr(resSeq);
                jyjcInspectionResult.setRecDate(new Date());
                jyjcInspectionResult.setRecUserId(RequestContext.getExeUserId());
                this.save(jyjcInspectionResult);

                // 检验结果附件表
                this.useUnitEntrySaveOrUpdateAttachment(entryData, resSeq);

                // 保存到设备的检验信息表
                IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = new IdxBizJgInspectionDetectionInfo();
                inspectionDetectionInfo.setInspectConclusion(Objects.toString(entryData.getOrDefault("inspectConclusion", "")));
                inspectionDetectionInfo.setInspectDate(ObjectUtils.isEmpty(entryData.get("inspectDate")) ? null : sdf.parse(Objects.toString(entryData.get("inspectDate"))));
                inspectionDetectionInfo.setInspectReport(ObjectUtils.isEmpty(entryData.get("JYJC_TZSBJYBG")) ? null : JSON.toJSONString(entryData.get("JYJC_TZSBJYBG")));
                inspectionDetectionInfo.setInspectOrgCode(Objects.toString(entryData.getOrDefault("inspectOrgCode", "")));
                inspectionDetectionInfo.setInspectOrgName(Objects.toString(entryData.getOrDefault("inspectOrgName", "")));
                inspectionDetectionInfo.setInspectStaff(Objects.toString(entryData.getOrDefault("inspectStaff", "")));
                inspectionDetectionInfo.setInspectType(Objects.toString(entryData.getOrDefault("inspectType", "")));
                inspectionDetectionInfo.setNextInspectDate(sdf.parse(entryData.get("nextInspectionDate").toString()));
                inspectionDetectionInfo.setRecord(equ.getOrDefault("record", "").toString());
                inspectionDetectionInfo.setRecDate(new Date());
                inspectionDetectionInfo.setSafetyLevel(Objects.toString(entryData.getOrDefault("safetyLevel", "")));
                inspectionDetectionInfo.setRecUserId(RequestContext.getExeUserId());
                inspectionDetectionInfo.setInspectReportNo(Objects.toString(entryData.getOrDefault("inspectReportNo", "")));
                inspectionDetectionInfo.setResultSeq(Objects.toString(resSeq));
                idxBizJgInspectionDetectionInfoMapper.insert(inspectionDetectionInfo);

                // 保存检验历史表用于详情回显
                entryData.put("equip", new JSONArray(Collections.singletonList(equ)));
                entryData.put("sequenceNbr", resSeq);
                JyjcInspectionHistory inspectionHistory = new JyjcInspectionHistory().setSSeq(resSeq).setHistoryData(JSON.parseObject(JSON.toJSONString(entryData))).setSType(Objects.toString(entryData.get("inspectType")));
                inspectionHistory.setRecUserId(RequestContext.getExeUserId());
                inspectionHistory.setRecDate(new Date());
                jyjcInspectionHistoryService.save(inspectionHistory);
                records.add(inspectionDetectionInfo.getRecord());
                // 3.更新使用信息表，最新检验信息
                useInfoMapper.updateByRecord(inspectionDetectionInfo.getRecord(), jyjcInspectionResult.getNextInspectionDate(), jyjcInspectionResult.getInspectionType(), jyjcInspectionResult.getApplicationNo());
                // 4.更新es下次检验日期
                commonService.updateEquipNextInspectDate(jyjcInspectionResult, inspectionDetectionInfo.getRecord());
                sendDataRefreshMsg(records);
                // 发送 type = update的数据，为了兼容检验机构对接时会先产生一条检验结果信息，此时还没有设备的检验信息，后续会更新该条检验信息，
                // 所以 sendInspectionMsgAfterSave 方法在处理时只处理了update 操作。
                bizEmqPublisher.sendInspectionMsgAfterSave(inspectionDetectionInfo, "update");
            } catch (Exception e) {
                log.warn(e.getMessage());
                throw new BadRequest("数据异常，请联系管理员！");
            }
        }
        return Boolean.TRUE;
    }

    /**
     * 使用单位录入检验结果附件-保存/更新
     *
     * @param entryData
     */
    public void useUnitEntrySaveOrUpdateAttachment(Map<String, Object> entryData, Long resSeq) {
        // 删除旧数据
        attachmentService.getBaseMapper().delete(
                new LambdaQueryWrapper<JyjcInspectionResultAttachment>()
                        .eq(JyjcInspectionResultAttachment::getResultSeq, resSeq)
        );

        // 定义需要处理的附件字段列表（字段名和类型一致）
        List<String> attachmentKeys = Arrays.asList("JYJC_TZSBJYBG", "JYJC_SYBZ", "JYJC_JYYJTZSLLD");

        // 当前用户和时间只获取一次
        String userId = RequestContext.getExeUserId();
        Date now = new Date();

        // 批量处理
        for (String key : attachmentKeys) {
            Object data = entryData.get(key);
            if (!ObjectUtils.isEmpty(data)) {
                JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
                attachment.setAttachmentType(key);
                attachment.setAttachmentUrl(JSON.toJSONString(data));
                attachment.setResultSeq(resSeq);
                attachment.setRecUserId(userId);
                attachment.setRecDate(now);
                attachmentService.save(attachment);
            }
        }
    }


    /**
     * 使用单位录入检验结果-更新
     *
     * @param entryData
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean useUnitEntryWithUpdate(Map<String, Object> entryData, ReginParams reginParams) {
        boolean isYLGD = "8000".equals(Objects.toString(entryData.get("equList")));
        Object sequenceNbr = entryData.get("sequenceNbr");
        if (sequenceNbr == null) {
            throw new BadRequest("数据丢失，请重新进入页面填写！");
        }
        JSONArray equList = JSON.parseArray(JSON.toJSONString(entryData.get(EQU_LIST)));
        JSONObject equ = JSON.parseObject(JSON.toJSONString(equList.get(0)));
        // 保存结果表数据
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            JyjcInspectionResult jyjcInspectionResult = new JyjcInspectionResult()
                    .setInspectionUnitCode(Objects.toString(entryData.getOrDefault("inspectOrgCode", "")))
                    .setApplicationUnitCode(CommonServiceImpl.getUnitCode(reginParams.getCompany()))
                    .setEquipUnicode(Objects.toString(equ.get("record")))
                    .setResultStatus(ResultStatusEnum.YES_RESULT.getCode())
                    .setLicenseNumber(null)
                    .setResultNo(Objects.toString(entryData.getOrDefault("inspectReportNo", "")))
                    .setInnerPersonCode(null)
                    .setInspectionConclusion(Objects.toString(entryData.getOrDefault("inspectConclusion", "")))
                    .setInspectionDate(sdf.parse(entryData.get("inspectDate").toString()))
                    .setNextInspectionDate(sdf.parse(entryData.get("nextInspectionDate").toString()))
                    .setApplicationDate(ObjectUtils.isEmpty(entryData.get("applicationDate")) ? null : sdf.parse(Objects.toString(entryData.get("applicationDate"))))
                    .setInspectionStartDate(null)
                    .setInspectionEndDate(null)
                    .setInspectionResultSummary(null)
                    .setNonConformance(null)
                    .setRemark(null)
                    .setInspectionType(Objects.toString(entryData.get("inspectType")))
                    .setBizType(getCategoryByType(JYJCTypeEnum.of(Objects.toString(entryData.get("inspectType")))))
                    .setEquCategory(isYLGD ? Objects.toString(equ.getOrDefault("equCategory", "")) : Objects.toString(equ.getOrDefault("EQU_CATEGORY_CODE", "")))
                    .setInspectionTypeName(this.getDictNameByCode(Objects.toString(entryData.get("inspectType"))))
                    .setResultType(ResultTypeEnum.USEUNITENTRY.getCode())
                    .setEquList(isYLGD ? Objects.toString(equ.getOrDefault("equList", "")) : Objects.toString(equ.getOrDefault("EQU_LIST_CODE", "")))
                    .setEquDefine(isYLGD ? Objects.toString(equ.getOrDefault("equDefine", "")) : Objects.toString(equ.getOrDefault("EQU_DEFINE_CODE", "")))
                    .setTraceId(null)
                    .setInspectionUnitName(Objects.toString(entryData.getOrDefault("inspectOrgName", "")))
                    .setApplicationUnitName(reginParams.getCompany().getCompanyName())
                    .setSupervisoryCode(Objects.toString(equ.getOrDefault("SUPERVISORY_CODE", "")))
                    .setIsExistNc(null)
                    .setSafetyLevel(Objects.toString(equ.getOrDefault("safetyLevel", "")))
                    .setManageType("single");
            jyjcInspectionResult.setSequenceNbr(Long.valueOf(Objects.toString(sequenceNbr)));
            jyjcInspectionResult.setRecDate(new Date());
            jyjcInspectionResult.setRecUserId(RequestContext.getExeUserId());
            this.updateById(jyjcInspectionResult);

            // 检验结果附件表
            this.useUnitEntrySaveOrUpdateAttachment(entryData, Long.valueOf(Objects.toString(sequenceNbr)));

            // 保存到设备的检验信息表
            IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = new IdxBizJgInspectionDetectionInfo();
            inspectionDetectionInfo.setInspectConclusion(Objects.toString(entryData.getOrDefault("inspectConclusion", "")));
            inspectionDetectionInfo.setInspectDate(ObjectUtils.isEmpty(entryData.get("inspectDate")) ? null : sdf.parse(Objects.toString(entryData.get("inspectDate"))));
            inspectionDetectionInfo.setInspectReport(ObjectUtils.isEmpty(entryData.get("JYJC_TZSBJYBG")) ? null : JSON.toJSONString(entryData.get("JYJC_TZSBJYBG")));
            inspectionDetectionInfo.setInspectOrgCode(Objects.toString(entryData.getOrDefault("inspectOrgCode", "")));
            inspectionDetectionInfo.setInspectOrgName(Objects.toString(entryData.getOrDefault("inspectOrgName", "")));
            inspectionDetectionInfo.setInspectStaff(Objects.toString(entryData.getOrDefault("inspectStaff", "")));
            inspectionDetectionInfo.setInspectType(Objects.toString(entryData.getOrDefault("inspectType", "")));
            inspectionDetectionInfo.setNextInspectDate(sdf.parse(entryData.get("nextInspectionDate").toString()));
            inspectionDetectionInfo.setRecord(equ.getOrDefault("record", "").toString());
            inspectionDetectionInfo.setRecDate(new Date());
            inspectionDetectionInfo.setSafetyLevel(Objects.toString(entryData.getOrDefault("safetyLevel", "")));
            inspectionDetectionInfo.setRecUserId(RequestContext.getExeUserId());
            inspectionDetectionInfo.setInspectReportNo(Objects.toString(entryData.getOrDefault("inspectReportNo", "")));
            inspectionDetectionInfo.setResultSeq(Objects.toString(sequenceNbr));
            inspectionDetectionInfo.setSequenceNbr(Objects.toString(sequenceNbr));
            idxBizJgInspectionDetectionInfoMapper.updateById(inspectionDetectionInfo);

            // 保存检验历史表用于详情回显
            entryData.put("equip", new JSONArray(Collections.singletonList(equ)));
            entryData.put("sequenceNbr", sequenceNbr);
            JyjcInspectionHistory inspectionHistory = new JyjcInspectionHistory().setHistoryData(JSON.parseObject(JSON.toJSONString(entryData))).setSType(Objects.toString(entryData.get("inspectType")));
            inspectionHistory.setRecDate(new Date());
            inspectionHistory.setRecUserId(RequestContext.getExeUserId());
            jyjcInspectionHistoryService.update(inspectionHistory,
                    new LambdaUpdateWrapper<JyjcInspectionHistory>().eq(JyjcInspectionHistory::getSSeq, Long.valueOf(Objects.toString(sequenceNbr))));
            // 3.更新使用信息表，最新检验信息
            useInfoMapper.updateByRecord(inspectionDetectionInfo.getRecord(), jyjcInspectionResult.getNextInspectionDate(), jyjcInspectionResult.getInspectionType(), jyjcInspectionResult.getApplicationNo());
            // 4.更新es下次检验日期
            commonService.updateEquipNextInspectDate(jyjcInspectionResult, inspectionDetectionInfo.getRecord());
            // 发送数据变更消息
            sendDataRefreshMsg(Sets.newHashSet(inspectionDetectionInfo.getRecord()));
            bizEmqPublisher.sendInspectionMsgAfterSave(inspectionDetectionInfo, "update");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new BadRequest("数据异常，请联系管理员！");
        }
        return Boolean.TRUE;
    }

    /**
     * 使用单位录入检验结果-获取详情
     *
     * @param resultSeq
     * @return
     */
    public JSONObject getUseUnitEntryDetail(Long resultSeq) {
        return jyjcInspectionHistoryService.getBySSeq(resultSeq).getHistoryData();
    }

    /**
     * 使用单位录入检验结果-删除
     *
     * @param resultSeq
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean delUseUnitEntry(Long resultSeq) {
        // 删除结果表
        this.baseMapper.deleteById(resultSeq);
        Set<String> records = idxBizJgInspectionDetectionInfoMapper.selectList(new LambdaQueryWrapper<IdxBizJgInspectionDetectionInfo>().eq(IdxBizJgInspectionDetectionInfo::getResultSeq, resultSeq).select(IdxBizJgInspectionDetectionInfo::getRecord)).stream().map(IdxBizJgInspectionDetectionInfo::getRecord).collect(Collectors.toSet());
        // 删除检验信息表
        idxBizJgInspectionDetectionInfoMapper.delete(new LambdaQueryWrapper<IdxBizJgInspectionDetectionInfo>().eq(IdxBizJgInspectionDetectionInfo::getResultSeq, resultSeq.toString()));
        // 删除附件表
        attachmentService.getBaseMapper().delete(new LambdaQueryWrapper<JyjcInspectionResultAttachment>().eq(JyjcInspectionResultAttachment::getResultSeq, resultSeq.toString()));
        // 删除历史表
        jyjcInspectionHistoryService.getBaseMapper().delete(new LambdaQueryWrapper<JyjcInspectionHistory>().eq(JyjcInspectionHistory::getSSeq, resultSeq));
        // 发送数据变更消息
        sendDataRefreshMsg(records);
        records.stream()
                .filter(Objects::nonNull)
                .map(this::getTheLatestInspectionInformation)
                .filter(Objects::nonNull)
                .forEach(info -> bizEmqPublisher.sendInspectionMsgAfterSave(info, "update"));
        return Boolean.TRUE;
    }

    /**
     * 获取最新的一条检验检测信息
     *
     * @param record 设备 record
     * @return 最新的一条检验检测信息
     */
    private IdxBizJgInspectionDetectionInfo getTheLatestInspectionInformation(String record) {
        List<IdxBizJgInspectionDetectionInfo> inspectionDetectionInfoList = idxBizJgInspectionDetectionInfoMapper.selectList(
                new LambdaQueryWrapper<IdxBizJgInspectionDetectionInfo>()
                        .eq(IdxBizJgInspectionDetectionInfo::getRecord, record)
                        .orderByDesc(IdxBizJgInspectionDetectionInfo::getInspectDate)
                        .last("LIMIT 1")
        );
        return inspectionDetectionInfoList.stream()
                .findFirst()
                .orElse(null);
    }


    @Transactional(rollbackFor = Exception.class)
    public List<PipelineInspectionResultDto> receivePipelineResultData(List<PipelineInspectionResultDto> resultData) {
        log.info("收到检验检测厂商推送的压力管道结果数据：{}", JSONArray.toJSONString(resultData));
        // 1.数据合法性检查
        this.checkMustFieldIsValid2(resultData);
        // 2.组织数据
        List<JyjcInspectionResult> resultList = queryResultList(resultData.stream().map(PipelineInspectionResultDto::getApplicationNo).collect(Collectors.toList()));
        Map<String, JyjcInspectionResult> applyNoResultAppMap = resultList.stream().collect(Collectors.toMap(JyjcInspectionResult::getApplicationNo, Function.identity()));
        List<JyjcInspectionResult> updateResultList = new ArrayList<>();
        List<JyjcInspectionResultAttachment> resultAttachments = new ArrayList<>();
        List<JyjcInspectionResultParam> resultParams = new ArrayList<>();
        resultData.forEach(r -> {
            JyjcInspectionResult result = applyNoResultAppMap.get(r.getApplicationNo());
            if (result != null) {
                // 填充主表数据
                this.fillResultData(r, result, updateResultList);
                // 填充附件数据
                this.fillResultAttachmentData(r, result, resultAttachments);
                // 填充技术参数数据
                this.fillResultParamData(r, result, resultParams);
            }
        });
        // 3.数据入库
        if (!updateResultList.isEmpty()) {
            // 3.1 批量保存主表数据
            super.updateBatchById(updateResultList);
            // 3.2 批量保存子表数据
            deleteAndCreateSubTable(updateResultList, resultAttachments, resultParams);
            // 3.3 异步更新设备的检验检测信息
            eventPublisher.publish(new InspectionDetectionSaveToDbEvent(this, new ArrayList<>(updateResultList)));
        }
        return resultData;
    }

    private void checkMustFieldIsValid2(List<PipelineInspectionResultDto> resultData) {
        int i = 0;
        for (PipelineInspectionResultDto resultDataModel : resultData) {
            i++;
            if (StringUtils.isEmpty(resultDataModel.getApplicationNo())) {
                throw new BadRequest("第" + i + "条数据存在问题，applicationNo不能为空！");
            }
            if (resultDataModel.getInspectionEquips() == null || resultDataModel.getInspectionEquips().isEmpty()) {
                throw new BadRequest("第" + i + "条数据存在问题，inspectionEquips不能为空！");
            }
            boolean isExistEmptyEquipId = resultDataModel.getInspectionEquips().stream().anyMatch(e -> StringUtils.isEmpty(e.getEquipId()));
            if (isExistEmptyEquipId) {
                throw new BadRequest("第" + i + "条数据存在问题，inspectionEquips中存在缺少equip的数据！");
            }
        }
    }

    public static void doUpdatePipelineTechParams(Map<String, Object> e, String record, IdxBizJgTechParamsPipelineMapper techParamPipelineMapper) {
        IdxBizJgTechParamsPipeline techParamPipeline = new IdxBizJgTechParamsPipeline();
        BeanUtil.copyProperties(e, techParamPipeline, true);
        LambdaUpdateWrapper<IdxBizJgTechParamsPipeline> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgTechParamsPipeline::getRecord, record);
        updateWrapper.set(IdxBizJgTechParamsPipeline::getNominalDiameter, techParamPipeline.getNominalDiameter());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWallThickness, techParamPipeline.getWallThickness());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getPipeLengthText, techParamPipeline.getPipeLengthText());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getPipeLength, PipLenCalUtils.cal(techParamPipeline.getPipeLengthText()));
        updateWrapper.set(IdxBizJgTechParamsPipeline::getPressure, techParamPipeline.getPressure());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getTemperature, techParamPipeline.getTemperature());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getMedium, techParamPipeline.getMedium());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWorkMedium, techParamPipeline.getWorkMedium());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWorkPressure, techParamPipeline.getWorkPressure());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWorkTemperature, techParamPipeline.getWorkTemperature());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getRemarks, techParamPipeline.getRemarks());
        techParamPipelineMapper.update(null, updateWrapper);
    }
}