package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.PipeLengthField;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-压力管道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_tech_params_pipeline")
@PipeLengthField
public class IdxBizJgTechParamsPipeline extends TzsBaseEntity {


    /**
     *
     */
    @TableField("\"RECORD\"")
    private String record;

    /**
     *
     */
    @TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
    @TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
    @TableField("\"DEVICE_NAME\"")
    private String deviceName;

    /**
     *
     */
    @TableField("\"PIPELINE_CLASS\"")
    private String pipelineClass;

    /**
     *
     */
    @TableField("\"PIPE_NAME\"")
    private String pipeName;

    /**
     *
     */
    @TableField("\"PIPELINE_NUMBER\"")
    private String pipelineNumber;

    /**
     *
     */
    @TableField("\"DEVICE_LEVEL\"")
    private String deviceLevel;

    /**
     *
     */
    @TableField("\"DESIGN_STANDARD\"")
    private String designStandard;

    /**
     *
     */
    @TableField("\"PIPE_DRAW_NUMBER\"")
    private String pipeDrawNumber;

    /**
     *
     */
    @TableField("\"NOMINAL_DIAMETER\"")
    private String nominalDiameter;

    /**
     *
     */
    @TableField("\"WALL_THICKNESS\"")
    private String wallThickness;

    /**
     *
     */
    @TableField(value = "\"PIPE_LENGTH\"", fill = FieldFill.INSERT_UPDATE)
    private String pipeLength;


    /**
     *
     */
    @TableField("\"STARTE_POSITION\"")
    private String startePosition;

    /**
     * 终点位置
     */
    @TableField("\"END_POSITION\"")
    private String endPosition;

    /**
     * 设计-介质
     */
    @TableField("\"PRESSURE\"")
    private String pressure;

    /**
     * 设计-介质
     */
    @TableField("\"TEMPERATURE\"")
    private String temperature;

    /**
     * 设计-介质
     */
    @TableField("\"MEDIUM\"")
    private String medium;

    /**
     *
     */
    @TableField("\"REMARKS\"")
    private String remarks;


    /**
     * 管道信息
     */
    @TableField(value = "\"PIPE_INFO\"")
    private String pipeInfo;

    /**
     * * 工作压力
     */

    @TableField(value = "\"WORK_PRESSURE\"")
    private String workPressure;
    /**
     * * 工作温度
     */

    @TableField(value = "\"WORK_TEMPERATURE\"")
    private String workTemperature;
    /**
     * * 工作介质
     */

    @TableField(value = "\"WORK_MEDIUM\"")
    private String workMedium;
    /**
     * * 工作备注
     */

    @TableField(value = "\"WORK_REMARKS\"")
    private String workRemarks;

    /**
     * 管道长度斜线分隔多段表示用：数字或者 / 分割的数字，如2.1/6.3
     */
    @TableField(value = "\"PIPE_LENGTH_TEXT\"")
    private String pipeLengthText;

}
