package com.yeejoin.amos.boot.module.common.api.entity;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 人员
 */
@Data
@Document(indexName = "idx_biz_user_info")
public class EsUserInfo {
    @Id
    private String sequenceNbr;

    /**
     * 姓名
     */
    @Field(type = FieldType.Keyword)
    private String name;


    /**
     * 证件类型
     */
    @Field(type = FieldType.Keyword)
    private String certificateType;

    /**
     * 证件编号
     */
    @Field(type = FieldType.Keyword)
    private String certificateNum;

    /**
     * 性别
     */
    @Field(type = FieldType.Keyword)
    private String gender;

    /**
     * 岗位-保留兼容下游数据查询
     */
    @Field(type = FieldType.Keyword)
    private String post;

    /**
     * 新岗位（后期post迁移数组至此）
     */
    @Field(type = FieldType.Keyword)
    private String newPost;

    /**
     * 岗位名称-按照new_post显示
     */
    @Field(type = FieldType.Text)
    private String postName;

    /**
     * 联系电话
     */
    @Field(type = FieldType.Keyword)
    private String phone;

    /**
     * 出生日期
     */
    @Field(type = FieldType.Date, format = DateFormat.date)
    private LocalDate birthday;

    /**
     * 学历
     */
    @Field(type = FieldType.Keyword)
    private String education;

    /**
     * 专业
     */
    @Field(type = FieldType.Text)
    private String speciality;

    /**
     * 邮箱
     */
    @Field(type = FieldType.Keyword)
    private String email;

    /**
     * 住址
     */
    @Field(type = FieldType.Keyword)
    private String address;

    /**
     * 证件照片
     */
    @Field(type = FieldType.Keyword)
    private String identification;

    /**
     * 证件照片
     */
    @Field(type = FieldType.Keyword)
    private String appointDoc;

    /**
     * 单位名称
     */
    @Field(type = FieldType.Keyword)
    private String unitName;

    /**
     * 企业编码
     */
    @Field(type = FieldType.Keyword)
    private String unitCode;

    /**
     * 人员所属企业单位类型
     */
    @Field(type = FieldType.Keyword)
    private String unitType;

    /**
     * 头像
     */
    @Field(type = FieldType.Keyword)
    private String profile;

    /**
     * 设备类型
     */
    @Field(type = FieldType.Keyword)
    private String equipType;

    /**
     * 职称
     */
    @Field(type = FieldType.Keyword)
    private String jobTitle;

    /**
     * 岗位子类型（多个逗号分割）
     */
    @Field(type = FieldType.Keyword)
    private String subPost;

    /**
     * 岗位子类型名称（多个逗号分割）
     */
    @Field(type = FieldType.Text)
    private String subPostName;

    /**
     * 管辖机构OrgCode--来源企业表
     */
    @Field(type = FieldType.Keyword)
    private String superviseOrgCode;

    /**
     * 管辖机构名称--来源企业表
     */
    @Field(type = FieldType.Text)
    private String superviseOrgName;

    /**
     * 资质
     */
    @Field(type = FieldType.Nested)
    private List<License> licenses;

    /**
     * 创建时间
     */
    @Field(type = FieldType.Date, format = DateFormat.date_hour_minute_second)
    private LocalDateTime createDate;

    @Data
    public static class License {

        /**
         * 资质表主键
         */
        @Field(type = FieldType.Long)
        private Long sequenceNbr;

        /**
         * 主表主键
         */
        @Field(type = FieldType.Long)
        private Long userSeq;

        /**
         * 检验检测专用-级别
         */
        @Field(type = FieldType.Keyword)
        private String permissionLevel;

        /**
         * 检验检测专用-资质项目
         */
        @Field(type = FieldType.Keyword)
        private String permissionItem;

        /**
         * 证书编号
         */
        @Field(type = FieldType.Keyword)
        private String certNo;

        /**
         * 有效期至
         */
        @Field(type = FieldType.Date, format = DateFormat.date)
        private LocalDate expiryDate;

        /**
         * 发证机关
         */
        @Field(type = FieldType.Keyword)
        private String approvedOrgan;

        /**
         * 发证日期
         */
        @Field(type = FieldType.Date, format = DateFormat.date)
        private LocalDate issueDate;

        /**
         * 证书类型
         */
        @Field(type = FieldType.Keyword)
        private String certType;

        /**
         * 作业项目
         */
        @Field(type = FieldType.Keyword)
        private String jobItem;

        /**
         * 项目代号,多个用逗号分割
         */
        @Field(type = FieldType.Keyword)
        private String itemCode;

        /**
         * 其他作业项目
         */
        @Field(type = FieldType.Keyword)
        private String otherItem;
    }
}
