package com.yeejoin.amos.boot.module.common.biz.utils;

import com.alibaba.fastjson.JSON;

import java.util.List;

public class RefreshDataUtils {

    /**
     * 判断字符串是否为合法的 JSON 格式
     */
    public static boolean isJSONValid(String test) {
        try {
            JSON.parseArray(test);
            return true;
        } catch (Exception ex) {
            return false;
        }
    }

    public static String castStrList2String(String jsonTypesStr) {
        if (!isNullOrEmpty(jsonTypesStr)) {
            if (isJSONValid(jsonTypesStr)) {
                List<String> posts = JSON.parseArray(jsonTypesStr, String.class);
                return String.join(",", posts);
            }
            return jsonTypesStr;
        }
        return null;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }
}
