package com.yeejoin.amos.boot.module.common.biz.utils;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import com.yeejoin.amos.boot.module.common.api.dto.ITechParamDefine;
import com.yeejoin.amos.boot.module.common.api.dto.TechParamItem;
import org.reflections.Reflections;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TechParamUtil {
    private static final Set<Class<? extends ITechParamDefine>> subClasses;
    private static final Map<String, List<TechParamItem>> techParamsMetaMap = new ConcurrentHashMap<>();

    static {
        //▼ 指定扫描包路径（根据实际项目调整）
        Reflections reflections = new Reflections("com.yeejoin.amos.boot.module.common.api.dto");
        //▼ 获取所有继承ITechParamsMeta的类
        subClasses = reflections.getSubTypesOf(ITechParamDefine.class);
    }

    public static List<TechParamItem> getParamMetaList(String equListCode) {
        return techParamsMetaMap.computeIfAbsent(equListCode, (key) -> {
            List<TechParamItem> techParamItems = new ArrayList<>();
            for (Class<? extends ITechParamDefine> subClass : subClasses) {
                Field[] fields = subClass.getDeclaredFields();
                Group group = subClass.getAnnotation(Group.class);
                if (group != null && equListCode.equals(group.value())) {
                    for (Field field : fields) {
                        field.setAccessible(true);
                        TechnicalParameter technicalParameter = field.getAnnotation(TechnicalParameter.class);
                        TechParamItem techParamItem = new TechParamItem();
                        techParamItem.setParamKey(technicalParameter.key());
                        techParamItem.setParamLabel(technicalParameter.label());
                        techParamItem.setEquListCode(equListCode);
                        techParamItem.setParamType(technicalParameter.type());
                        techParamItem.setDictCode(technicalParameter.dictCode());
                        techParamItem.setUnit(technicalParameter.unit());
                        techParamItems.add(techParamItem);
                    }
                }
            }
            return techParamItems;
        });
    }

    public static Class<? extends ITechParamDefine> getParamClazz(String equListCode) {
        for (Class<? extends ITechParamDefine> subClass : subClasses) {
            Group group = subClass.getAnnotation(Group.class);
            if (group != null && equListCode.equals(group.value())) {
                return subClass;
            }
        }
        throw new RuntimeException("not found equListCode " + equListCode + "clazz");
    }
}

