package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 管道工程装置表
 *
 * @author system_generator
 * @date 2024-12-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Group(value = "idx_biz_jg_project_contraption")
@ApiModel(value = "ProjectContraptionChangeFieldDto", description = "管道工程装置表")
public class ProjectContraptionChangeDataDto extends BaseChangeDataDto {

    @FieldDisplayDefine(value = "主键", isExist = false)
    private String projectContraptionId;

    private static final long serialVersionUID = 1L;

    @FieldDisplayDefine(value = "工程（装置）名称/项目名称")
    private String projectContraption;

    @FieldDisplayDefine(value = "工程（装置）编号/项目编号")
    private String projectContraptionNo;


    @FieldDisplayDefine(value = "设备种类名称", isExist = false)
    private String equListName;


    @FieldDisplayDefine(value = "设备种类编码", isExist = false)
    private String equList;


    @FieldDisplayDefine(value = "设备类别名称", isExist = false)
    private String equCategoryName;


    @FieldDisplayDefine(value = "设备类别编码", isExist = false)
    private String equCategory;


    @FieldDisplayDefine(value = "设备品种名称")
    private String equDefineName;

    @FieldDisplayDefine(value = "设备品种代码", typeHandler = "equipCategoryTypeHandler")
    private String equDefine;

    @FieldDisplayDefine(value = "装置管道总长度(m)", isExist = false)
    private Double pipelineLength;

    @FieldDisplayDefine(value = "产品照片附件", type = JSON.class)
    private String productPhoto;

    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    private String otherAccessories;

    @FieldDisplayDefine(value = "产品质量合格证明", type = JSON.class)
    private String productQualificationCertificate;


    @FieldDisplayDefine(value = "使用省份", typeHandler = "regionCodeTypeHandler")
    private String province;

    @FieldDisplayDefine(value = "使用市", typeHandler = "regionCodeTypeHandler")
    private String city;

    @FieldDisplayDefine(value = "使用区县", typeHandler = "regionCodeTypeHandler")
    private String county;

    @FieldDisplayDefine(value = "使用街道/镇", typeHandler = "regionCodeTypeHandler")
    private String street;


    @FieldDisplayDefine(value = "使用详细地址")
    private String address;


    @FieldDisplayDefine(value = "使用地点名称省", isRepeatColumn = true)
    private String provinceName;


    @FieldDisplayDefine(value = "使用地点_市名称", isRepeatColumn = true)
    private String cityName;


    @FieldDisplayDefine(value = "使用地点_区名称", isRepeatColumn = true)
    private String countyName;


    @FieldDisplayDefine(value = " 使用地点_街道名称", isRepeatColumn = true)
    private String streetName;


    @FieldDisplayDefine(value = " 装置起始位置", type = JSON.class)
    private String startLatitudeLongitude;

    @FieldDisplayDefine(value = " 装置结束位置", type = JSON.class)
    private String endLatitudeLongitude;

    @FieldDisplayDefine(value = "来源类型", isExist = false)
    private String dataSource;

    @FieldDisplayDefine(value = "使用单位名称", isExist = false)
    private String useUnitCreditCode;

    @FieldDisplayDefine(value = "使用单位统一信用代码", isExist = false)
    private String useUnitName;

    @FieldDisplayDefine(value = "施工单位统一信用代码", isExist = false)
    private String uscUnitCreditCode;

    @FieldDisplayDefine(value = "施工单位名称", isExist = false)
    private String uscUnitName;

    @FieldDisplayDefine(value = "投用日期", isExist = false)
    private String useDate;

    @FieldDisplayDefine(value = "属地监管部门", isRepeatColumn = true)
    private String orgCode;

    @FieldDisplayDefine(value = "属地监管部门")
    private String orgName;

}
