package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jyjc.api.enums.OpenBizTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcBaseMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.InstanceRuntimeData;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzsUserInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Optional;

/**
 * @author Administrator
 */
@Service
public class CommonServiceImpl {

    @Value("${jyjc.user-post:6615}")
    private String jyjcUserPost;

    @Value("${jyjc.user-post:6616}")
    private String jyjcBizUserPost;

    @Value("${jy.user-post:66151}")
    private String jyUserPost;

    @Value("${jc.user-post:66152}")
    private String jcUserPost;

    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsUserInfoMapper userInfoMapper;

    @Autowired
    TzBaseEnterpriseInfoMapper enterpriseInfoMapper;

    @Autowired
    RedissonClient redissonClient;

    @Autowired
    JyjcBaseMapper jyjcBaseMapper;

    @Autowired
    private DataDictionaryServiceImpl dictionaryService;


    /**
     * @return ReginParams
     * @description 获取当前用户注册信息
     */
    ReginParams getReginParamsOfCurrentUser() {
        return JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
    }

    public List<TzsUserInfo> getUserInfosByUnitCode(String unitCode) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        userInfoQueryWrapper.like(TzsUserInfo::getPost, jyjcUserPost);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }

    public List<TzsUserInfo> getUserListByUnitCodeAndPost(String unitCode, String personType) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        this.castPersonType2Post(userInfoQueryWrapper, personType);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        userInfoQueryWrapper.select(TzsUserInfo::getPost, TzsUserInfo::getPhone, TzsUserInfo::getName, TzsUserInfo::getInnerPersonCode, BaseEntity::getSequenceNbr);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }


    public void castPersonType2Post(LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper, String personType) {

        if (personType.contains(OpenBizTypeEnum.JY.getCode()) && personType.contains(OpenBizTypeEnum.JC.getCode())) {
            userInfoQueryWrapper.and(w-> w.like(TzsUserInfo::getPost, jyUserPost).or().like(TzsUserInfo::getPost, jcUserPost));
            return;
        }
        if (personType.equals(OpenBizTypeEnum.JY.getCode())) {
            //userInfoQueryWrapper.like(TzsUserInfo::getPost, jcUserPost);
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jyUserPost);

        }
        if (personType.equals(OpenBizTypeEnum.JC.getCode())) {
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jcUserPost);
        }
    }

    public List<TzsUserInfo> getBizUserInfosByUnitCode(String unitCode) {
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.eq("unit_code", unitCode);
        userInfoQueryWrapper.like("post", jyjcBizUserPost);
        userInfoQueryWrapper.isNotNull("amos_user_id");
        userInfoQueryWrapper.eq("is_delete", false);
        List<TzsUserInfo> userInfos = userInfoMapper.selectList(userInfoQueryWrapper);
        return userInfos;
    }

    public List<TzsUserInfo> getUserPhonesByPersonCode(String personCode) {
        List<String> ids = StrUtil.split(personCode, ",");
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.in("sequence_nbr", ids);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }


    public List<TzBaseEnterpriseInfoDto> getInspectionUnitList(String openBizType) {
        return enterpriseInfoMapper.getInspectionUnitList(openBizType);
    }

    public TzBaseEnterpriseInfo getInspectionUnitBySequenceNbr(Long sequenceNbr) {
        return enterpriseInfoMapper.selectBySeq(sequenceNbr);
    }


    /**
     * 执行流程时前置校验是否已经执行
     *
     * @param taskId     任务id
     * @param instanceId 实例id
     */
    public void checkForExecuteFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前流程已经被转办给其他人或者页面按钮问题导致的权限未控制
        String nextExecuteUserIds = instanceRuntimeData.getNextExecuteUserIds();
        if (!nextExecuteUserIds.contains(RequestContext.getExeUserId())) {
            throw new BadRequest("当前登录人无执行权限！");
        }

    }

    private InstanceRuntimeData getInstanceRuntimeData(String instanceId) {
        RBucket<InstanceRuntimeData> rBucket = redissonClient.getBucket(buildJcInstanceDataKey(instanceId));
        return rBucket.get();
    }

    private String buildJcInstanceDataKey(String instanceId) {
        return "JC_INSTANCE_DATA:" + instanceId;
    }

    public static String buildJcExecuteLockKey(String instanceId) {
        return "JC_INSTANCE_LOCK:" + instanceId;
    }


    /**
     * 最新流程数据缓存
     *
     * @param instanceId   实例id
     * @param instanceData 流程数据
     */
    public void saveExecuteFlowData2Redis(String instanceId, InstanceRuntimeData instanceData) {
        redissonClient.getBucket(buildJcInstanceDataKey(instanceId)).set(instanceData);
    }


    /**
     * 撤回时校验流程是否已经执行
     *
     * @param taskId     前端业务上送任务id
     * @param instanceId 实例id
     */
    public void checkForRevocationFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 前端页面上送任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        if (!instanceRuntimeData.getPromoter().equals(RequestContext.getExeUserId())) {
            throw new BadRequest("无权限执行该任务");
        }
    }

    public List<AgencyUserModel> getAmosUseListByCompanyCode(String unitCode) {
        CompanyModel companyModel = jyjcBaseMapper.selectOneCompanyByCode(unitCode);
        FeignClientResult<List<AgencyUserModel>> result = Privilege.agencyUserClient.queryByCompanyId(companyModel.getSequenceNbr(), null, null, false);
        return result.getResult();
    }

    /**
     * 排序  ：页面列表排序功能支持，将 "字段,ascend" 或 "字段,descend" 转化为对应JSONObject
     *
     * @param sort "字段,ascend" 或 "字段,descend"
     * @return JSONObject
     */
    public SortVo sortFieldConversion(String sort) {
        Optional<String> optionalSort = Optional.ofNullable(sort);
        Optional<SortVo> optionalSortMap = optionalSort.filter(s -> !s.isEmpty())
                .map(s -> {
                    String[] sortParts = s.split(",");
                    if (sortParts.length == 2) {
                        String field = sortParts[0];
                        String sortSituation = sortParts[1].contains("asc") ? "ASC" : "DESC";
                        return SortVo.builder()
                                .field(convertToUnderline(field))
                                .sortType(sortSituation)
                                .build();
                    }
                    return null;
                });
        return optionalSortMap.orElse(null);
    }

    /**
     * 驼峰转下划线
     *
     * @param str
     * @return
     */
    public static String convertToUnderline(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_").append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    /**
     * 数据质量等级枚举转名称描述
     *
     * @param dataQualityScore 等级枚举
     * @param isIntoManagement 是否纳管
     * @return 名称描述
     */
    public String castDataQualityScore2Name(String dataQualityScore, Boolean isIntoManagement) {
        DataDictionary dataDictionary = dictionaryService.getByCode("DATA_QUALITY_SCORE", dataQualityScore);
        String name = Optional.ofNullable(dataDictionary).map(DataDictionary::getName).orElse(null);
        return name == null ? (isIntoManagement == null || !isIntoManagement) ? "二类" : "一类" : name;
    }
}
