package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum CompanyAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    USEUNIT("企业名称", "useUnit", TechnicalParameter.ParamType.STRING,"",null,null),
    ADDRESS("详细地址", "address", TechnicalParameter.ParamType.STRING,"",null,null),
    EXPIRYDATE("许可有效期", "expiryDate",TechnicalParameter.ParamType.DATE,"",null,null),
    UNIT_TYPE("企业类型", "unitType",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryUnitType",null,null),
    REGULATORY_LABELS("监管标签", "regulatoryLabels",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryDicData?type={type}","QYBQ",null),
    INDUSTRY_SUPERVISOR("行业主管部门", "industrySupervisor",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryDicData?type={type}","HYZGBM",null),
    ITEM_CODE("许可项目", "itemCode",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryXK",null,null),
    SUB_ITEM_CODE("许可子项目", "subItemCode",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryXK?type={type}",null,"itemCode"),
    OPERATING_STATUS("经营状态", "operatingStatus",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryDicDataNew?type={type}","jyzt",null),
    EQUIP_CATEGORY("设备类型", "equipCategory",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryEquipList",null,null),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;
    private String dataKey;
    private String argKey;

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (CompanyAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("dataKey", item.dataKey);
            jsonObject.put("argKey", item.argKey);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if(TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)){
                jsonObject.put("type","inputNumber");
            }else if(TechnicalParameter.ParamType.STRING.equals(item.paramType)){
                jsonObject.put("type","input");
            }else if(TechnicalParameter.ParamType.DATE.equals(item.paramType)){
                jsonObject.put("type","date");
            }else {
                jsonObject.put("type","select");
            }
            jsonObject.put("conditions",ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
