package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum DataQualityScoreEnum {

    /**
     * *设备等级
     */

    I("一类（使用登记证信息齐全）","一类", "1"),
    II("二类（只有设备名称和使用登记证编号）","二类", "2"),
    III("三类（只有设备名称）","三类", "3");

    private String name;
    private String label;
    private String code;

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (DataQualityScoreEnum e : DataQualityScoreEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (DataQualityScoreEnum e : DataQualityScoreEnum.values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label",e.name);
            jsonObject.put("value",e.name);
            jsonObject.put("key",e.code);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public static String getLabelByCode(String code) {
        for (DataQualityScoreEnum e : EnumSet.allOf(DataQualityScoreEnum.class)) {
            if(e.getCode().equals(code)){
                return e.getLabel();
            }
        }
        return null;
    }
}
