package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum EquipAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    USE_ORG_CODE("使用登记证编号", "USE_ORG_CODE", TechnicalParameter.ParamType.STRING,"",null,null),
    EQU_LIST("设备种类", "EQU_LIST_CODE",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryEquipList",null,null),
    EQU_CATEGORY("设备类别", "EQU_CATEGORY_CODE",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryEquCategory?type={type}",null,"EQU_LIST_CODE"),
    EQU_DEFINE("设备品种", "EQU_DEFINE_CODE",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryEquDefine?type={type}",null,"EQU_CATEGORY_CODE"),
    PRODUCT_NAME("设备名称", "PRODUCT_NAME", TechnicalParameter.ParamType.STRING,"",null,null),
    TECH_PARAM("技术参数", "techParam", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryTechParam?type={type}",null,"EQU_LIST_CODE"),
    PARAM_RANGE("参数范围", "paramRange", TechnicalParameter.ParamType.STRING,"",null,null),
    NEXT_INSPECT_DATE("检验有效期", "NEXT_INSPECT_DATE", TechnicalParameter.ParamType.DATE,"",null,null),
    EQU_STATE("设备状态", "EQU_STATE", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryEquState",null,null),
    WHETHER_VEHICLE_CYLINDER("是否车用气瓶", "WHETHER_VEHICLE_CYLINDER", null,"/statistics/comprehensiveStatisticalAnalysis/select/vehicleCylinder",null,null),
    QZ_OR_TANK("是否车用气瓶", "WHETHER_VEHICLE_CYLINDER", null,"/statistics/comprehensiveStatisticalAnalysis/select/qzOrTank",null,null),
//    IS_SUPERVISORY_CODE("赋码状态", "IS_SUPERVISORY_CODE", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryIsSupervisoryCode",null,null),
    DATA_QUALITY_SCORE("数据完整性", "DATA_QUALITY_SCORE", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryDataQualityScore",null,null),
    USE_DATE("使用年限", "USE_DATE", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryUscDate",null,null),
    REGISTER_STATUS("登记状态", "registerStatus", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryRegisterStatus",null,null),
//    UNIT_TYPE("所属单位类型", "unitType", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryUnitType",null,null),
    USC_UNIT_NAME("所属单位名称", "USC_UNIT_NAME", TechnicalParameter.ParamType.STRING,"",null,null),
    PRODUCE_UNIT_NAME("制造单位名称", "PRODUCE_UNIT_NAME", TechnicalParameter.ParamType.STRING,"",null,null),
    DESIGN_UNIT_NAME("设计单位名称", "DESIGN_UNIT_NAME", TechnicalParameter.ParamType.STRING,"",null,null),
    ME_UNIT_NAME("维保单位名称", "ME_UNIT_NAME", TechnicalParameter.ParamType.STRING,"",null,null),
    AZUSC_UNIT_NAME("安装单位名称", "USC_UNIT_NAME", TechnicalParameter.ParamType.STRING,"",null,null),
    CODE96333("96333识别码", "CODE96333", TechnicalParameter.ParamType.STRING,"",null,null),
    SUPERVISORY_CODE("监管码", "SUPERVISORY_CODE", TechnicalParameter.ParamType.STRING,"",null,null),
    EQU_TYPE("设备型号", "EQU_TYPE", TechnicalParameter.ParamType.STRING,"",null,null),
    PRODUCE_DATE("制造日期", "PRODUCE_DATE", TechnicalParameter.ParamType.DATE,"",null,null),
    designDate("设计日期", "designDate", TechnicalParameter.ParamType.DATE,"",null,null),
    use_date("投用如期", "USE_DATE", TechnicalParameter.ParamType.DATE,"",null,null),
    ISSUE_DATE("使用登记证日期", "issueDate", TechnicalParameter.ParamType.DATE,"",null,null),
    JDJY("监督检验日期", "JDJY", TechnicalParameter.ParamType.DATE,"",null,null),
    DQJY("定期检验日期", "DQJY", TechnicalParameter.ParamType.DATE,"",null,null),
    SCJY("首次检验日期", "SCJY", TechnicalParameter.ParamType.DATE,"",null,null),
    DTJY("电梯检测日期", "DTJY", TechnicalParameter.ParamType.DATE,"",null,null),
    nextInspectDate("下次检验日期", "nextInspectDate", TechnicalParameter.ParamType.DATE,"",null,null),
//    PRODUCE_DATE("是否进口", "PRODUCE_DATE", TechnicalParameter.ParamType.DATE,""),
    USE_PLACE_CODE("使用地点", "USE_PLACE_CODE", TechnicalParameter.ParamType.STRING,"",null,null),
    USE_PLACE("使用场所", "USE_PLACE", null,"/statistics/comprehensiveStatisticalAnalysis/select/queryDicData","ADDRESS",null),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;
    private String dataKey;
    private String argKey;

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (EquipAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("dataKey", item.dataKey);
            jsonObject.put("argKey", item.argKey);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if(TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)){
                jsonObject.put("type","inputNumber");
            }else if(TechnicalParameter.ParamType.STRING.equals(item.paramType)){
                jsonObject.put("type","input");
            }else if(TechnicalParameter.ParamType.DATE.equals(item.paramType)){
                jsonObject.put("type","date");
            }else {
                jsonObject.put("type","select");
            }
            if ("技术参数".equals(item.name)){
                jsonObject.put("type","select2");
            }
            jsonObject.put("conditions",ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
