package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum PersonAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    NAME("人员名称", "name", TechnicalParameter.ParamType.STRING,"",null,null),
    NEWPOST("人员类型", "newPost",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryRYLX",null,null),
    SUBPOST("人员子类型", "subPost",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryRYLX?type={type}",null,"newPost"),
    CERT_NO("有无资质", "certNo",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryCertNo",null,null),
    EXPIRY_DATE("资质状态", "expiryDate",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryExpiryDate",null,null),
    CERT_TYPE("证书类型", "certType",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryCertType",null,null),
    PERMISSION_LEVEL("证书级别", "permissionLevel",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryPermissionLevel",null,null),
    JOB_ITEM("作业项目", "jobItem",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryZYXM?type={type}",null,"certType"),
    PERMISSION_ITEM("项目", "permissionItem",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryZYXM?type={type}",null,"permissionLevel"),
    ISSUE_DATE("发证日期", "issueDate",TechnicalParameter.ParamType.DATE,"",null,null),
    EDUCATION("学历", "education",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryDicData","QYRYXL",null),
    ADDRESS("住址", "address",TechnicalParameter.ParamType.STRING,"",null,null),
    UNITCODE("所属企业", "unitCode", TechnicalParameter.ParamType.STRING,"",null,null),
    SUPERVISEORGCODE("管辖机构", "superviseOrgCode",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryUnitByOrgCode?type={type}",null,"orgTreeId"),
    EQUIP_TYPE("设备类型", "equipType",null,"/statistics/comprehensiveStatisticalAnalysis/select/queryEquipList",null,null),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;
    private String dataKey;
    private String argKey;

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (PersonAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("dataKey", item.dataKey);
            jsonObject.put("argKey", item.argKey);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if(TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)){
                jsonObject.put("type","inputNumber");
            }else if(TechnicalParameter.ParamType.STRING.equals(item.paramType)){
                jsonObject.put("type","input");
            }else if(TechnicalParameter.ParamType.DATE.equals(item.paramType)){
                jsonObject.put("type","date");
            }else {
                jsonObject.put("type","select");
            }
            jsonObject.put("conditions",ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
