package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum UnitTypeEnum {

    /**
     * *注册单位类型
     */

    sydw("使用单位", "1232", "use"),
    czdw("充装单位", "1231", "license"),
    jyjcjg("检验检测机构", "1233", "license"),
    azgzwxdw("安装改造维修单位", "1234", "license"),
    zzdw("制造单位", "1236", "license"),
    sjdw("设计单位", "1235", "license"),
    grzt("个人主体", "6599", "use");

    private String name;
    private String code;
    private String type;

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (UnitTypeEnum e : UnitTypeEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }

    public static JSONArray getAll() {
        JSONArray jsonArray = new JSONArray();
        for (UnitTypeEnum e : UnitTypeEnum.values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", e.name);
            jsonObject.put("value", e.name);
            jsonObject.put("key", e.code);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public static JSONArray getUnitTypeByType(String category) {
        if (ObjectUtils.isEmpty(category)) {
            return getAll();
        }
        JSONArray jsonArray = new JSONArray();
        for (UnitTypeEnum e : UnitTypeEnum.values()) {
            if (e.type.equals(category)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("label", e.name);
                jsonObject.put("value", e.name);
                jsonObject.put("key", e.code);
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }
}
