package com.yeejoin.amos.boot.module.statistcs.biz.utils;

import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import com.yeejoin.amos.boot.module.common.api.dto.ITechParamDefine;
import org.reflections.Reflections;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TechParamUtil {
    private static final Set<Class<? extends ITechParamDefine>> subClasses;
    private static final ConcurrentHashMap<String, String> allTechParamsMap = new ConcurrentHashMap<>();

    static {
        //▼ 指定扫描包路径（根据实际项目调整）
        Reflections reflections = new Reflections("com.yeejoin.amos.boot.module.common.api.dto");
        //▼ 获取所有继承ITechParamsMeta的类
        subClasses = reflections.getSubTypesOf(ITechParamDefine.class);
        for (Class<? extends ITechParamDefine> subClass : subClasses) {
            Field[] fields = subClass.getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                TechnicalParameter technicalParameter = field.getAnnotation(TechnicalParameter.class);
                allTechParamsMap.put(technicalParameter.key(), technicalParameter.label());
            }
        }
    }

    /**
     * 获取所有设备类型的技术参数
     *
     * @return result
     */
    public static AbstractMap<String, String> getAllTechParams() {
        return allTechParamsMap;
    }
}
