package com.yeejoin.amos.boot.module.tcm.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * 企业数据信息 Mapper 接口
 *
 * @author duanwei
 * @date 2022-08-10
 */
public interface TzBaseEnterpriseInfoMapper extends BaseMapper<TzBaseEnterpriseInfo> {

	/**
	 * 查找企业关联设备详情列表
	 * 
	 * @param sequenceNbr 企业id
	 * @return EquEnterDto 使用登记证代码、设备名称、设备类别、设备位置
	 */
	List<EquEnterDto> getInfo(String sequenceNbr);

	/**
	 * 根据企业名称查找设备
	 *
	 * @param useUnit 企业名称
	 * @return
	 */
	List<EquEnterDto> getInfoByUseUnit(String useUnit);

	/**
	 * 根据企业名称查找企业详情信息
	 * @param useUnit
	 * @return
	 */
	TzBaseEnterpriseInfo selectByUseUnit(String useUnit);


	CompanyModel getOneByCompanyCode(String companyCode);


	IPage<TzBaseEnterpriseInfoDto> page(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto);

	IPage<TzBaseEnterpriseInfoDto> pageList(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto, List orgCodeList);

	/**
	 * 查询未生成二维码的企业
	 * @return
	 */
    List<TzBaseEnterpriseInfo> listNoQrCode();

	List<Map<String, Object>> getEquipType(@Param("type")String type);

    Map<String, Object> getProblemInfoBySourceId(@Param("sourceId")String sourceId);

	@Update ("update tz_base_enterprise_info set SUPERVISE_ORG_NAME = #{superviseOrgName},SUPERVISE_ORG_CODE = REPLACE(SUPERVISE_ORG_CODE, #{oldSuperviseOrgCode}, #{preSuperviseOrgCode}), ORG_CODE = REPLACE(ORG_CODE, #{oldOrgCode}, #{preOrgCode}) where sequence_nbr = #{sequenceNbr}")
	void updateSubCompanyOrgCode(@Param("superviseOrgName") String superviseOrgName, @Param("oldSuperviseOrgCode") String oldSuperviseOrgCode, @Param("preSuperviseOrgCode")  String preSuperviseOrgCode,
								 @Param("oldOrgCode") String oldOrgCode, @Param("preOrgCode")  String preOrgCode, @Param("sequenceNbr") Long sequenceNbr);

}
