package com.yeejoin.amos.boot.module.tcm.biz.refresh;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.common.api.entity.EsUserInfo;
import com.yeejoin.amos.boot.module.common.api.entity.TzsUserPermission;
import com.yeejoin.amos.boot.module.common.biz.utils.RefreshDataUtils;
import com.yeejoin.amos.boot.module.tcm.api.mapper.TzsUserPermissionMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class CommonRefreshService {

    private final TzsUserPermissionMapper userPermissionMapper;

    public List<EsUserInfo.License> buildUserLicenses(Long sequenceNbr) {
        List<TzsUserPermission> permissions = userPermissionMapper.selectList(new LambdaQueryWrapper<TzsUserPermission>().eq(TzsUserPermission::getUserSeq, sequenceNbr));
        return permissions.stream().map(p -> {
            EsUserInfo.License license = new EsUserInfo.License();
            BeanUtil.copyProperties(p, license);
            license.setPermissionItem(RefreshDataUtils.castStrList2String(p.getPermissionItem()));
            license.setJobItem(RefreshDataUtils.castStrList2String(p.getJobItem()));
            return license;
        }).collect(Collectors.toList());
    }
}
