package com.yeejoin.amos.maintenance.business.service.impl;


import com.yeejoin.amos.maintenance.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.maintenance.business.dao.repository.AppVersionDao;
import com.yeejoin.amos.maintenance.business.dao.repository.IMsgSubscribeDao;
import com.yeejoin.amos.maintenance.business.param.UserMsgInitParam;
import com.yeejoin.amos.maintenance.business.service.intfc.IAppService;
import com.yeejoin.amos.maintenance.business.service.intfc.IMsgSubscribeService;
import com.yeejoin.amos.maintenance.common.enums.MsgSubscribeTypeEnum;
import com.yeejoin.amos.maintenance.dao.entity.AppVersion;
import com.yeejoin.amos.maintenance.dao.entity.MsgSubscribe;
import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("iAppService")
public class AppServiceImpl implements IAppService {

    @Autowired
    private IMsgSubscribeDao msgSubscribeDao;
    @Autowired
    private AppVersionDao appVersionDao;
    @Autowired
    private IMsgSubscribeService msgSubscribeService;
    @Autowired
    private PlanTaskMapper planTaskMapper;


    @Override
    public AppVersion queryAppLastVersion() {
        // TODO Auto-generated method stub
        return appVersionDao.findLastVersion();
    }


    /**
     * 新增用户时初始化消息订阅(p_msg_subscribe)表
     *
     * @param userDTO
     */
    @Override
    public List<MsgSubscribe> saveUserMsgInit(UserMsgInitParam userInitParam) {
        Long count = msgSubscribeDao.countByUserId(userInitParam.getUserId());
        if (count > 0) {    //	已存在用户订阅，直接返回
            return msgSubscribeService.queryMsgSubscribes(userInitParam.getUserId());
        }
        List<MsgSubscribe> msgConfigs = new ArrayList<MsgSubscribe>();
        for (MsgSubscribeTypeEnum type : MsgSubscribeTypeEnum.values()) {
            MsgSubscribe msgSub = new MsgSubscribe();
            msgSub.setOrgCode(userInitParam.getOrgCode());
            msgSub.setUserId(userInitParam.getUserId());
            if (type.equals(MsgSubscribeTypeEnum.PLANBEGIN)
                    || type.equals(MsgSubscribeTypeEnum.PLANWARN)
                    || type.equals(MsgSubscribeTypeEnum.PLANEND)) {
                msgSub.setAttribute1("False");
                msgSub.setAttribute2(10 + "");
            } else if (type.equals(MsgSubscribeTypeEnum.CHECKTYPE)
                    || type.equals(MsgSubscribeTypeEnum.CHECKEMAIL)) {
                msgSub.setAttribute1("error");
            }
            msgSub.setMsgType(type.getName());
            msgSubscribeDao.saveAndFlush(msgSub);
            msgConfigs.add(msgSub);

        }
        return msgConfigs;
    }


    @Override
    public List<String> getHaveToDoList(String userId) {
        int taskCount = planTaskMapper.getCurrentPlanTaskCount(userId);
        List<String> havetoDoList = Lists.newArrayList();
        if (taskCount > 0) {
            havetoDoList.add("planPatrol");
        }
        return havetoDoList;
    }

}