package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.equipmanage.common.entity.dto.EquipTypeAmountPageDTO;
import com.yeejoin.equipmanage.common.entity.dto.FireResourceStatsDTO;
import com.yeejoin.equipmanage.common.entity.vo.EquipTypeImgAmountVO;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.service.IEmergencyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 *
 * 四横八纵应急模块接口
 *
 *
 */
@RestController
@Api(tags = "四横八纵应急模块Api")
@RequestMapping(value = "/emergency", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EmergencyController extends AbstractBaseController {

    @Autowired
	IEmergencyService iEmergencyService;

	@Autowired
	RedisUtils redisUtils;

	/**
	 * 通过bizOrgCode过滤
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("系统状态")
	@GetMapping(value = "/system/state")
	public ResponseModel getSystemState(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
		if (StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
		}
		return CommonResponseUtil.success(iEmergencyService.getSystemState(bizOrgCode));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("系统告警统计")
	@GetMapping(value = "/system/alarm")
	public ResponseModel getSystemAlarmCount(@RequestParam(value = "status",required = false) String status,
											 @RequestParam(value = "current",required = false) int current,
											 @RequestParam(value = "size",required = false) int size,
											 @RequestParam(value = "bizOrgCode",required = false)String bizOrgCode) {
		if (current > 0){
			current = (current-1)*size;
		}
		return CommonResponseUtil.success(iEmergencyService.getSystemAlarmCount(status,current,size, bizOrgCode));
	}

	/**
	 * CAFS-消防水箱信息
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("CAFS-消防水箱信息")
	@GetMapping(value = "/cafs-tank")
	public ResponseModel getCAFSWaterTankInfo() {
		ReginParams reginParams = getSelectedOrgInfo();
		String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		return CommonResponseUtil.success(iEmergencyService.getCAFSWaterTankInfo());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("应急物资")
	@GetMapping(value = "/emergencyMaterials")
	public Map<String, Object> emergencyMaterials()  {
		return iEmergencyService.emergencyMaterials();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("消防系统/消防车")
	@GetMapping(value = "/systemAndCar")
	public Map<String, Object> systemAndCar()  {
		return iEmergencyService.systemAndCar();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("应急物资-详情")
	@GetMapping(value = "/emergencyMaterialsDetails")
	public Page<Map<String, Object>> emergencyMaterialsDetails(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode ,
															   @RequestParam(value = "pageNumber") int pageNumber,
															   @RequestParam(value = "pageSize") int pageSize)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.emergencyMaterialsDetails(page, bizOrgCode);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("消防炮列表")
	@GetMapping(value = "/fireMonitor")
	public Page<Map<String, Object>> selectFireMonitor(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
													   @RequestParam(value = "pageNumber") int pageNumber,
													   @RequestParam(value = "pageSize") int pageSize,
													   @RequestParam(value = "code") String code)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectFireMonitor(page, bizOrgCode, code);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("泡沫罐列表")
	@GetMapping(value = "/selectFoamTank")
	public Page<Map<String, Object>> selectFoamTank(@RequestParam(value = "pageNumber") int pageNumber,
													@RequestParam(value = "pageSize") int pageSize
													)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		return iEmergencyService.selectFoamTank(page);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("排油系统列表")
	@GetMapping(value = "/selectOilDrainage")
	public Page<Map<String, Object>> selectOilDrainage(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode ,
													   @RequestParam(value = "pageNumber") int pageNumber,
													   @RequestParam(value = "pageSize") int pageSize,
													   @RequestParam(value = "code") String code)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectOilDrainage(page, bizOrgCode, code);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("气体灭火系统")
	@GetMapping(value = "/selectGasExtinguishing")
	public Page<Map<String, Object>> selectGasExtinguishing(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode ,
													   @RequestParam(value = "pageNumber") int pageNumber,
													   @RequestParam(value = "pageSize") int pageSize,
													   @RequestParam(value = "code") String code)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectGasExtinguishing(page, bizOrgCode, code);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("压力流量")
	@GetMapping(value = "/selectPressureFlow")
	public Page<Map<String, Object>> selectPressureFlow(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode ,
													   @RequestParam(value = "pageNumber") int pageNumber,
													   @RequestParam(value = "pageSize") int pageSize)  {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (ObjectUtils.isEmpty(bizOrgCode)){
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
		}
		return iEmergencyService.selectPressureFlow(page, bizOrgCode);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("火灾自动报警系统告警分析-折线图")
	@GetMapping(value = "/selectAlarmAnalysis")
	public List<Map<String, Object>> selectPressureFlow(@RequestParam(value = "startDate") String startDate,
														@RequestParam(value = "endDate") String endDate,
														@RequestParam(value = "type") String type,
														@RequestParam(value = "systemType") String systemType)throws Exception   {

		ArrayList<Map<String, Object>> result = new ArrayList<>();
		if ("day".equals(type)) {
			return iEmergencyService.selectAlarmAnalysis(startDate, endDate, "0", "", systemType);
		} else if ("month".equals(type)) {
			String date = startDate.substring(0, 4) + "-01" + "-01";
			return iEmergencyService.selectAlarmAnalysis(startDate, endDate, "1", date, systemType);
		} else if ("week".equals(type)) {
			List<Map<String, Object>> maps = iEmergencyService.selectAlarmAnalysis(startDate, endDate, "0", "", systemType);
			String beginMonth = startDate.substring(5,7);
			String endMonth = endDate.substring(5,7);
			List<Map<String, String>> weeksMapInterval = DateUtils.getWeeksMapInterval(DateUtils.dateToStringMonth(startDate));
			for (Map<String, String> week : weeksMapInterval) {
				Date weekStart = null;
				Date weekEnd = null;
				try {
					weekStart = DateUtils.dateParse(week.get("weekStart"), DateUtils.DATE_PATTERN);
					weekEnd = DateUtils.dateParse(week.get("weekEnd"), DateUtils.DATE_PATTERN);
				} catch (ParseException e) {
					e.printStackTrace();
				}
				long startTime = null != weekStart ? weekStart.getTime() : 0;
				long endTime = null != weekEnd ? weekEnd.getTime() : 0;
				HashMap<String, Object> mapData = new HashMap<>();
				for (Map<String, Object> map : maps) {
					Date check = null;
					try {
						check = DateUtils.dateParse(String.valueOf(map.get("date")), DateUtils.DATE_PATTERN);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					if (null != check && !ObjectUtils.isEmpty(check) && check.getTime() >= startTime && check.getTime() <= endTime) {
						if (!ObjectUtils.isEmpty(mapData)) {
							BigDecimal old = new BigDecimal(String.valueOf(mapData.get("faultNum")));
							BigDecimal add = new BigDecimal(String.valueOf(map.get("faultNum")));
							BigDecimal now = old.add(add);
							mapData.put("faultNum", String.valueOf(now));

							BigDecimal firePumpsOld = new BigDecimal(String.valueOf(mapData.get("alarmNum")));
							BigDecimal firePumpsAdd = new BigDecimal(String.valueOf(map.get("alarmNum")));
							BigDecimal firePumpsNow = firePumpsOld.add(firePumpsAdd);
							mapData.put("alarmNum", String.valueOf(firePumpsNow));

							BigDecimal stabilizedOld = new BigDecimal(String.valueOf(mapData.get("shieldNum")));
							BigDecimal stabilizedAdd = new BigDecimal(String.valueOf(map.get("shieldNum")));
							BigDecimal stabilizedNow = stabilizedOld.add(stabilizedAdd);
							mapData.put("shieldNum", String.valueOf(stabilizedNow));
						} else {
							mapData.put("name", week.get("name"));
							mapData.put("faultNum", map.get("faultNum"));
							mapData.put("alarmNum", map.get("alarmNum"));
							mapData.put("shieldNum", map.get("shieldNum"));
						}

					}
				}
				result.add(mapData);
			}
			if(!StringUtils.isEmpty(beginMonth) && !beginMonth.equals(endMonth)){
				weeksMapInterval = DateUtils.getWeeksMapInterval(DateUtils.dateToStringMonth(endDate));
				for (Map<String, String> weeks : weeksMapInterval) {
					Date weekStart1 = null;
					Date weekEnd1 = null;
					try {
						weekStart1 = DateUtils.dateParse(weeks.get("weekStart"), DateUtils.DATE_PATTERN);
						weekEnd1 = DateUtils.dateParse(weeks.get("weekEnd"), DateUtils.DATE_PATTERN);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					long startTime1 = null != weekStart1 ? weekStart1.getTime() : 0;
					long endTime1 = null != weekEnd1 ? weekEnd1.getTime() : 0;
					HashMap<String, Object> mapData1 = new HashMap<>();
					for (Map<String, Object> map : maps) {
						Date check = null;
						try {
							check = DateUtils.dateParse(String.valueOf(map.get("date")), DateUtils.DATE_PATTERN);
						} catch (ParseException e) {
							e.printStackTrace();
						}
						if (null != check && !ObjectUtils.isEmpty(check) && check.getTime() >= startTime1 && check.getTime() <= endTime1) {
							if (!ObjectUtils.isEmpty(mapData1)) {
								BigDecimal old = new BigDecimal(String.valueOf(mapData1.get("faultNum")));
								BigDecimal add = new BigDecimal(String.valueOf(map.get("faultNum")));
								BigDecimal now = old.add(add);
								mapData1.put("faultNum", String.valueOf(now));

								BigDecimal firePumpsOld = new BigDecimal(String.valueOf(mapData1.get("alarmNum")));
								BigDecimal firePumpsAdd = new BigDecimal(String.valueOf(map.get("alarmNum")));
								BigDecimal firePumpsNow = firePumpsOld.add(firePumpsAdd);
								mapData1.put("alarmNum", String.valueOf(firePumpsNow));

								BigDecimal stabilizedOld = new BigDecimal(String.valueOf(mapData1.get("shieldNum")));
								BigDecimal stabilizedAdd = new BigDecimal(String.valueOf(map.get("shieldNum")));
								BigDecimal stabilizedNow = stabilizedOld.add(stabilizedAdd);
								mapData1.put("shieldNum", String.valueOf(stabilizedNow));
							} else {
								mapData1.put("name", weeks.get("name"));
								mapData1.put("faultNum", map.get("faultNum"));
								mapData1.put("alarmNum", map.get("alarmNum"));
								mapData1.put("shieldNum", map.get("shieldNum"));
							}

						}
					}
					result.add(mapData1);
				}
			}

		}

		return result;
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("火灾自动报警系统告警分析-饼图")
	@GetMapping(value = "/selectAlarmAnalysisCount")
	public List<Map<String, Object>> selectAlarmAnalysisCount(@RequestParam(value = "startDate") String startDate,
															  @RequestParam(value = "endDate") String endDate,
															  @RequestParam(value = "systemType") String systemType) {
		return iEmergencyService.selectAlarmAnalysisCount(systemType, startDate, endDate);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("消防炮灭火系统告警分析-饼图")
	@GetMapping(value = "/fireCannonAlarmAnalysisPie")
	public List<Map<String, Object>> fireCannonAlarmAnalysisPie(@RequestParam(value = "startDate") String startDate,
																@RequestParam(value = "endDate") String endDate,
																@RequestParam(value = "systemType") String systemType) {

		return iEmergencyService.selectFireCannonAlarmAnalysisPie(startDate, endDate, systemType);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("消防给水系统告警分析-饼图")
	@GetMapping(value = "/waterSystemAlarmAnalysisPie")
	public List<Map<String, Object>> waterSystemAlarmAnalysisPie(@RequestParam(value = "startDate") String startDate,
																 @RequestParam(value = "endDate") String endDate,
																 @RequestParam(value = "systemType") String systemType) {
		return iEmergencyService.waterSystemAlarmAnalysisPie(startDate, endDate, systemType);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("消防给水系统告警分析-小图")
	@GetMapping(value = "/waterSystemAlarmAnalysis")
	public List<Map<String, Object>> waterSystemAlarmAnalysis(@RequestParam(value = "startDate") String startDate,
															  @RequestParam(value = "endDate") String endDate,
															  @RequestParam(value = "type") String type,
															  @RequestParam(value = "systemType") String systemType) {
		ArrayList<Map<String, Object>> result = new ArrayList<>();
		if ("month".equals(type)) {
			String date = startDate.substring(0, 4) + "-01" + "-01";
			return iEmergencyService.waterSystemAlarmAnalysis(startDate, endDate, "1", date, systemType);
		} else if ("day".equals(type)) {
			return iEmergencyService.waterSystemAlarmAnalysis(startDate, endDate, "0", "", systemType);
		} else if ("week".equals(type)) {
			List<Map<String, Object>> maps = iEmergencyService.waterSystemAlarmAnalysis(startDate, endDate, "0", "", systemType);
			String beginMonth = startDate.substring(5,7);
			String endMonth = endDate.substring(5,7);
			List<Map<String, String>> weeksMapInterval = DateUtils.getWeeksMapInterval(DateUtils.dateToStringMonth(startDate));
			for (Map<String, String> week : weeksMapInterval) {
				Date weekStart = null;
				Date weekEnd = null;
				try {
					weekStart = DateUtils.dateParse(week.get("weekStart"), DateUtils.DATE_PATTERN);
					weekEnd = DateUtils.dateParse(week.get("weekEnd"), DateUtils.DATE_PATTERN);
				} catch (ParseException e) {
					e.printStackTrace();
				}
				long startTime = null != weekStart ? weekStart.getTime() : 0;
				long endTime = null != weekEnd ? weekEnd.getTime() : 0;
				HashMap<String, Object> mapData = new HashMap<>();
				for (Map<String, Object> map : maps) {
					Date check = null;
					try {
						check = DateUtils.dateParse(String.valueOf(map.get("date")), DateUtils.DATE_PATTERN);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					if (null != check && !ObjectUtils.isEmpty(check) && check.getTime() >= startTime && check.getTime() <= endTime) {
						if (!ObjectUtils.isEmpty(mapData)) {
							BigDecimal old = new BigDecimal(String.valueOf(mapData.get("controlCabinetAlarmNum")));
							BigDecimal add = new BigDecimal(String.valueOf(map.get("controlCabinetAlarmNum")));
							BigDecimal now = old.add(add);
							mapData.put("controlCabinetAlarmNum", String.valueOf(now));

							BigDecimal firePumpsOld = new BigDecimal(String.valueOf(mapData.get("firePumpsAlarmNum")));
							BigDecimal firePumpsAdd = new BigDecimal(String.valueOf(map.get("firePumpsAlarmNum")));
							BigDecimal firePumpsNow = firePumpsOld.add(firePumpsAdd);
							mapData.put("firePumpsAlarmNum", String.valueOf(firePumpsNow));

							BigDecimal stabilizedOld = new BigDecimal(String.valueOf(mapData.get("stabilizedPumpAlarmNum")));
							BigDecimal stabilizedAdd = new BigDecimal(String.valueOf(map.get("stabilizedPumpAlarmNum")));
							BigDecimal stabilizedNow = stabilizedOld.add(stabilizedAdd);
							mapData.put("stabilizedPumpAlarmNum", String.valueOf(stabilizedNow));
						} else {
							mapData.put("name", week.get("name"));
							mapData.put("controlCabinetAlarmNum", map.get("controlCabinetAlarmNum"));
							mapData.put("firePumpsAlarmNum", map.get("firePumpsAlarmNum"));
							mapData.put("stabilizedPumpAlarmNum", map.get("stabilizedPumpAlarmNum"));
						}

					}

				}
				result.add(mapData);
			}
			if(!StringUtils.isEmpty(beginMonth) && !beginMonth.equals(endMonth)){
				weeksMapInterval = DateUtils.getWeeksMapInterval(DateUtils.dateToStringMonth(endDate));
				for (Map<String, String> weeks : weeksMapInterval) {
					Date weekStart1 = null;
					Date weekEnd1 = null;
					try {
						weekStart1 = DateUtils.dateParse(weeks.get("weekStart"), DateUtils.DATE_PATTERN);
						weekEnd1 = DateUtils.dateParse(weeks.get("weekEnd"), DateUtils.DATE_PATTERN);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					long startTime1 = null != weekStart1 ? weekStart1.getTime() : 0;
					long endTime1 = null != weekEnd1 ? weekEnd1.getTime() : 0;
					HashMap<String, Object> mapData1 = new HashMap<>();
					for (Map<String, Object> map : maps) {
						Date check = null;
						try {
							check = DateUtils.dateParse(String.valueOf(map.get("date")), DateUtils.DATE_PATTERN);
						} catch (ParseException e) {
							e.printStackTrace();
						}
						if (null != check && !ObjectUtils.isEmpty(check) && check.getTime() >= startTime1 && check.getTime() <= endTime1) {
							if (!ObjectUtils.isEmpty(mapData1)) {
								BigDecimal old = new BigDecimal(String.valueOf(mapData1.get("controlCabinetAlarmNum")));
								BigDecimal add = new BigDecimal(String.valueOf(map.get("controlCabinetAlarmNum")));
								BigDecimal now = old.add(add);
								mapData1.put("controlCabinetAlarmNum", String.valueOf(now));

								BigDecimal firePumpsOld = new BigDecimal(String.valueOf(mapData1.get("firePumpsAlarmNum")));
								BigDecimal firePumpsAdd = new BigDecimal(String.valueOf(map.get("firePumpsAlarmNum")));
								BigDecimal firePumpsNow = firePumpsOld.add(firePumpsAdd);
								mapData1.put("firePumpsAlarmNum", String.valueOf(firePumpsNow));

								BigDecimal stabilizedOld = new BigDecimal(String.valueOf(mapData1.get("stabilizedPumpAlarmNum")));
								BigDecimal stabilizedAdd = new BigDecimal(String.valueOf(map.get("stabilizedPumpAlarmNum")));
								BigDecimal stabilizedNow = stabilizedOld.add(stabilizedAdd);
								mapData1.put("stabilizedPumpAlarmNum", String.valueOf(stabilizedNow));
							} else {
								mapData1.put("name", weeks.get("name"));
								mapData1.put("controlCabinetAlarmNum", map.get("controlCabinetAlarmNum"));
								mapData1.put("firePumpsAlarmNum", map.get("firePumpsAlarmNum"));
								mapData1.put("stabilizedPumpAlarmNum", map.get("stabilizedPumpAlarmNum"));
							}

						}
					}
					result.add(mapData1);
				}
			}

		}

		return result;
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation("消防炮系统告警分析-折线图")
	@GetMapping(value = "/fireCannonSystemAlarmAnalysis")
	public List<Map<String, Object>> fireCannonSystemAlarmAnalysis(@RequestParam(value = "startDate") String startDate,
																   @RequestParam(value = "endDate") String endDate,
																   @RequestParam(value = "type") String type,
																   @RequestParam(value = "systemType") String systemType) {
		ArrayList<Map<String, Object>> result = new ArrayList<>();
		if ("day".equals(type)) {
			return iEmergencyService.fireCannonSystemAlarmAnalysis(startDate, endDate, "0", "", systemType);
		} else if ("month".equals(type)) {
			String date = startDate.substring(0, 4) + "-01" + "-01";
			return iEmergencyService.fireCannonSystemAlarmAnalysis(startDate, endDate, "1", date, systemType);
		} else if ("week".equals(type)) {
			List<Map<String, Object>> maps = iEmergencyService.fireCannonSystemAlarmAnalysis(startDate, endDate, "0", "", systemType);
			String beginMonth = startDate.substring(5,7);
			String endMonth = endDate.substring(5,7);
			List<Map<String, String>> weeksMapInterval = DateUtils.getWeeksMapInterval(DateUtils.dateToStringMonth(startDate));
			for (Map<String, String> week : weeksMapInterval) {
				Date weekStart = null;
				Date weekEnd = null;
				try {
					weekStart = DateUtils.dateParse(week.get("weekStart"), DateUtils.DATE_PATTERN);
					weekEnd = DateUtils.dateParse(week.get("weekEnd"), DateUtils.DATE_PATTERN);
				} catch (ParseException e) {
					e.printStackTrace();
				}
				long startTime = null != weekStart ? weekStart.getTime() : 0;
				long endTime = null != weekEnd ? weekEnd.getTime() : 0;
				HashMap<String, Object> mapData = new HashMap<>();
				for (Map<String, Object> map : maps) {
					Date check = null;
					try {
						check = DateUtils.dateParse(String.valueOf(map.get("date")), DateUtils.DATE_PATTERN);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					if (null != check && !ObjectUtils.isEmpty(check) && check.getTime() >= startTime && check.getTime() <= endTime) {
						if (!ObjectUtils.isEmpty(mapData)) {
							BigDecimal old = new BigDecimal(String.valueOf(mapData.get("powerLossNum")));
							BigDecimal add = new BigDecimal(String.valueOf(map.get("powerLossNum")));
							BigDecimal now = old.add(add);
							mapData.put("powerLossNum", String.valueOf(now));

							BigDecimal firePumpsOld = new BigDecimal(String.valueOf(mapData.get("faultNum")));
							BigDecimal firePumpsAdd = new BigDecimal(String.valueOf(map.get("faultNum")));
							BigDecimal firePumpsNow = firePumpsOld.add(firePumpsAdd);
							mapData.put("faultNum", String.valueOf(firePumpsNow));

							BigDecimal stabilizedOld = new BigDecimal(String.valueOf(mapData.get("fireAlarmNum")));
							BigDecimal stabilizedAdd = new BigDecimal(String.valueOf(map.get("fireAlarmNum")));
							BigDecimal stabilizedNow = stabilizedOld.add(stabilizedAdd);
							mapData.put("fireAlarmNum", String.valueOf(stabilizedNow));

							BigDecimal shieldOld = new BigDecimal(String.valueOf(mapData.get("shieldNum")));
							BigDecimal shieldAdd = new BigDecimal(String.valueOf(map.get("shieldNum")));
							BigDecimal shieldNow = shieldOld.add(shieldAdd);
							mapData.put("shieldNum", String.valueOf(shieldNow));
						} else {
							mapData.put("name", week.get("name"));
							mapData.put("shieldNum", map.get("shieldNum"));
							mapData.put("fireAlarmNum", map.get("fireAlarmNum"));
							mapData.put("faultNum", map.get("faultNum"));
							mapData.put("powerLossNum", map.get("powerLossNum"));
						}

					}

				}
				result.add(mapData);
			}
			if(!StringUtils.isEmpty(beginMonth) && !beginMonth.equals(endMonth)){
				weeksMapInterval = DateUtils.getWeeksMapInterval(DateUtils.dateToStringMonth(endDate));
				for (Map<String, String> weeks : weeksMapInterval) {
					Date weekStart1 = null;
					Date weekEnd1 = null;
					try {
						weekStart1 = DateUtils.dateParse(weeks.get("weekStart"), DateUtils.DATE_PATTERN);
						weekEnd1 = DateUtils.dateParse(weeks.get("weekEnd"), DateUtils.DATE_PATTERN);
					} catch (ParseException e) {
						e.printStackTrace();
					}
					long startTime1 = null != weekStart1 ? weekStart1.getTime() : 0;
					long endTime1 = null != weekEnd1 ? weekEnd1.getTime() : 0;
					HashMap<String, Object> mapData1 = new HashMap<>();
					for (Map<String, Object> map : maps) {
						Date check = null;
						try {
							check = DateUtils.dateParse(String.valueOf(map.get("date")), DateUtils.DATE_PATTERN);
						} catch (ParseException e) {
							e.printStackTrace();
						}
						if (null != check && !ObjectUtils.isEmpty(check) && check.getTime() >= startTime1 && check.getTime() <= endTime1) {
							if (!ObjectUtils.isEmpty(mapData1)) {
								BigDecimal old = new BigDecimal(String.valueOf(mapData1.get("powerLossNum")));
								BigDecimal add = new BigDecimal(String.valueOf(map.get("powerLossNum")));
								BigDecimal now = old.add(add);
								mapData1.put("powerLossNum", String.valueOf(now));

								BigDecimal firePumpsOld = new BigDecimal(String.valueOf(mapData1.get("faultNum")));
								BigDecimal firePumpsAdd = new BigDecimal(String.valueOf(map.get("faultNum")));
								BigDecimal firePumpsNow = firePumpsOld.add(firePumpsAdd);
								mapData1.put("faultNum", String.valueOf(firePumpsNow));

								BigDecimal stabilizedOld = new BigDecimal(String.valueOf(mapData1.get("fireAlarmNum")));
								BigDecimal stabilizedAdd = new BigDecimal(String.valueOf(map.get("fireAlarmNum")));
								BigDecimal stabilizedNow = stabilizedOld.add(stabilizedAdd);
								mapData1.put("fireAlarmNum", String.valueOf(stabilizedNow));

								BigDecimal shieldOld = new BigDecimal(String.valueOf(mapData1.get("shieldNum")));
								BigDecimal shieldAdd = new BigDecimal(String.valueOf(map.get("shieldNum")));
								BigDecimal shieldNow = shieldOld.add(shieldAdd);
								mapData1.put("shieldNum", String.valueOf(shieldNow));
							} else {
								mapData1.put("name", weeks.get("name"));
								mapData1.put("powerLossNum", map.get("powerLossNum"));
								mapData1.put("faultNum", map.get("faultNum"));
								mapData1.put("fireAlarmNum", map.get("fireAlarmNum"));
								mapData1.put("shieldNum", map.get("shieldNum"));
							}

						}
					}
					result.add(mapData1);
				}
			}


		}

		return result;
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEquipExpiryList")
	@ApiOperation(httpMethod = "GET", value = "四横八纵-临期设备列表", notes = "四横八纵-临期设备列表")
	public ResponseModel getEquipExpiryList(@ApiParam("临期天数-近多少天") @RequestParam(value = "expiryDayNum", required = false) Integer expiryDayNum) {
		expiryDayNum = Objects.isNull(expiryDayNum) ? 180 : expiryDayNum;
		return CommonResponseUtil.success(iEmergencyService.getEquipExpiryList(expiryDayNum));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEquipExpiryStatistics")
	@ApiOperation(httpMethod = "GET", value = "四横八纵-临期设备统计", notes = "四横八纵-临期设备统计")
	public ResponseModel getEquipExpiryStatistics(@ApiParam("临期天数-近多少天") @RequestParam(value = "expiryDayNum", required = false) Integer expiryDayNum) {
		expiryDayNum = Objects.isNull(expiryDayNum) ? 180 : expiryDayNum;
		return CommonResponseUtil.success(iEmergencyService.getEquipExpiryStatistics(expiryDayNum));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getStockEquipStatistics")
	@ApiOperation(httpMethod = "GET", value = "四横八纵-报废设备统计", notes = "四横八纵-报废设备统计")
	public ResponseModel getStockEquipStatistics() {
		return CommonResponseUtil.success(iEmergencyService.getStockEquipStatistics());
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getPressurePumpStatusChart")
	@ApiOperation(httpMethod = "GET", value = "四横八纵-稳压泵启停状态图", notes = "四横八纵-稳压泵启停状态图，取舍补点")
	public ResponseModel getPressurePumpStatusChart(@RequestParam String startTime, @RequestParam String endTime,
													@RequestParam(required = false) String bizOrgCode) {
		if(StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
			if (!ValidationUtil.isEmpty(personIdentity)) {
				bizOrgCode = personIdentity.getBizOrgCode();
				if (bizOrgCode == null) {
					return CommonResponseUtil.success(Collections.EMPTY_MAP);
				}
			}
		}
		return CommonResponseUtil.success(iEmergencyService.getPressurePumpStatusChart(startTime, endTime, bizOrgCode));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getPressurePumpStatusDetailChart")
	@ApiOperation(httpMethod = "GET", value = "四横八纵-稳压泵启停状态图", notes = "四横八纵-稳压泵启停状态图，分钟级补点")
	public ResponseModel getPressurePumpStatusDetailChart(@RequestParam String startTime, @RequestParam String endTime,
													@RequestParam(required = false) String bizOrgCode) {
		if(StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
			if (!ValidationUtil.isEmpty(personIdentity)) {
				bizOrgCode = personIdentity.getBizOrgCode();
				if (bizOrgCode == null) {
					return CommonResponseUtil.success(Collections.EMPTY_MAP);
				}
			}
		}
		return CommonResponseUtil.success(iEmergencyService.getPressurePumpStatusDetailChart(startTime, endTime, bizOrgCode));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getPressurePumpDiagnosticAnalysis")
	@ApiOperation(httpMethod = "GET", value = "四横八纵-稳压泵诊断分析", notes = "四横八纵-稳压泵诊断分析")
	public ResponseModel getPressurePumpDiagnosticAnalysis(@RequestParam(required = false) String bizOrgCode) {
		if(StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
			if (!ValidationUtil.isEmpty(personIdentity)) {
				bizOrgCode = personIdentity.getBizOrgCode();
				if (bizOrgCode == null) {
					return CommonResponseUtil.success(Collections.EMPTY_MAP);
				}
			}
		}
		return CommonResponseUtil.success(iEmergencyService.getPressurePumpDiagnosticAnalysis(bizOrgCode));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getPressurePumpStartStatistics")
	@ApiOperation(httpMethod = "GET", value = "四横八纵-稳压泵启动统计", notes = "四横八纵-稳压泵启动统计")
	public ResponseModel getPressurePumpStartStatistics(@RequestParam String startTime, @RequestParam String endTime,
														@RequestParam(required = false) String bizOrgCode) {
		if (StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
			if (!ValidationUtil.isEmpty(personIdentity)) {
				bizOrgCode = personIdentity.getBizOrgCode();
				if (bizOrgCode == null) {
					return CommonResponseUtil.success(Collections.EMPTY_MAP);
				}
			}
		}
		return CommonResponseUtil.success(iEmergencyService.getPressurePumpStartStatistics(startTime, endTime, bizOrgCode));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getPressurePumpDay")
	@ApiOperation(httpMethod = "GET", value = "手动-存储昨日稳压泵启动次数", notes = "手动-存储昨日稳压泵启动次数")
	public ResponseModel getPressurePumpDay() {
		return CommonResponseUtil.success(iEmergencyService.getPressurePumpDay());
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/alarmList")
	@ApiOperation(httpMethod = "GET", value = "消防告警信息", notes = "消防告警信息")
	public ResponseModel alarmList(@RequestParam Integer pageNumber,
								   @RequestParam Integer pageSize,
								   @RequestParam(required = false) List<String> types,
								   @RequestParam(required = false) List<String> emergencyLevels,
								   @RequestParam(required = false) String name,
								   @RequestParam(required = false) Integer cleanStatus,
								   @RequestParam(required = false) Integer handleStatus,
								   @RequestParam(required = false) String bizOrgCode,
								   @RequestParam(required = false) String systemCode,
								   @RequestParam(required = false) String createDate,
								   @RequestParam(required = false) String startDate,
								   @RequestParam(required = false) String endDate
								   ) {
		Page<Map<String, Object>> page = new Page<>(pageNumber, pageSize);
		if (StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
			if (!ValidationUtil.isEmpty(personIdentity)) {
				bizOrgCode = personIdentity.getBizOrgCode();
				if (bizOrgCode == null) {
					return CommonResponseUtil.success(page);
				}
			}
		}
		return CommonResponseUtil.success(iEmergencyService.alarmList(page, bizOrgCode, systemCode, types, emergencyLevels, name, cleanStatus, handleStatus, createDate, startDate, endDate));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation("应急物资及红绿码信息")
	@GetMapping(value = "/materials")
	public ResponseModel<Object> getEmergencyMaterials(@RequestParam(required = false) String bizOrgCode)  {
		if (StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && org.apache.commons.lang3.StringUtils.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
		}
		Map<String, Object> emergencyMaterials = iEmergencyService.getEmergencyMaterials(bizOrgCode);
		FireResourceStatsDTO fireExtinguisherDto = new FireResourceStatsDTO();
		fireExtinguisherDto.setTotalCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireExtinguisher"))));
		fireExtinguisherDto.setYellowCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireExtinguisherYellowCount"))));
		fireExtinguisherDto.setRedCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireExtinguisherRedCount"))));

		FireResourceStatsDTO fireHydrantDto = new FireResourceStatsDTO();
		fireHydrantDto.setTotalCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireHydrant"))));
		fireHydrantDto.setYellowCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireHydrantYellowCount"))));
		fireHydrantDto.setRedCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireHydrantRedCount"))));

		FireResourceStatsDTO fireShovelDto = new FireResourceStatsDTO();
		fireShovelDto.setTotalCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireShovel"))));
		fireShovelDto.setYellowCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireShovelYellowCount"))));
		fireShovelDto.setRedCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireShovelRedCount"))));

		FireResourceStatsDTO fireAxeDto = new FireResourceStatsDTO();
		fireAxeDto.setTotalCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireAxe"))));
		fireAxeDto.setYellowCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireAxeYellowCount"))));
		fireAxeDto.setRedCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireAxeRedCount"))));

		FireResourceStatsDTO fireBucketDto = new FireResourceStatsDTO();
		fireBucketDto.setTotalCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireBucket"))));
		fireBucketDto.setYellowCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireBucketYellowCount"))));
		fireBucketDto.setRedCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("fireBucketRedCount"))));

		FireResourceStatsDTO respiratorDto = new FireResourceStatsDTO();
		respiratorDto.setTotalCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("respirator"))));
		respiratorDto.setYellowCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("respiratorYellowCount"))));
		respiratorDto.setRedCounts(Long.valueOf(String.valueOf(emergencyMaterials.get("respiratorRedCount"))));

		Map<String, FireResourceStatsDTO> result = new HashMap<String, FireResourceStatsDTO>() {{
			put("fireExtinguisher", fireExtinguisherDto);
			put("fireHydrant", fireHydrantDto);
			put("fireShovel", fireShovelDto);
			put("fireAxe", fireAxeDto);
			put("fireBucket", fireBucketDto);
			put("respirator", respiratorDto);
		}};
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation("设备平台详情设备列表")
	@PostMapping(value = "/equip/list")
	public IPage<EquipTypeImgAmountVO> getMaterialList(@RequestBody EquipTypeAmountPageDTO equipTypeAmountPage)  {
		if (StringUtils.isEmpty(equipTypeAmountPage.getEquipCodeKey()) && StringUtils.isEmpty(equipTypeAmountPage.getSixEquipType())) {
			return new Page<>();
		}
		String bizOrgCode = equipTypeAmountPage.getBizOrgCode();
		if (StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && org.apache.commons.lang3.StringUtils.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
			equipTypeAmountPage.setBizOrgCode(bizOrgCode);
		}
		return iEmergencyService.getEmergencyEquipList(equipTypeAmountPage);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/equip/statistic")
	@ApiOperation(httpMethod = "GET", value = "查询监测部件列表", notes = "查询监测部件列表")
	public List<Map<String, Object>> getEquipStatistic(@RequestParam(required = false) String bizOrgCode,
													   @RequestParam String equipCodeKey) {
		if (StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && org.apache.commons.lang3.StringUtils.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
		}
		return iEmergencyService.getEquipStatistic(bizOrgCode, equipCodeKey);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/equip/all/statistic")
	@ApiOperation(httpMethod = "GET", value = "查询监测部件列表", notes = "查询监测部件列表")
	public List<Map<String, Object>> getAllTypeEquipStatistic(@RequestParam(required = false) String bizOrgCode) {
		if (StringUtils.isEmpty(bizOrgCode)) {
			ReginParams reginParams = getSelectedOrgInfo();
			bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && org.apache.commons.lang3.StringUtils.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
		}
		return iEmergencyService.getAllTypeEquipStatistic(bizOrgCode);
	}

}
