package com.yeejoin.amos.maintenance.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the p_check_shot database table.
 *
 */
@Entity
@Table(name="p_check_shot")
@NamedQuery(name="CheckShot.findAll", query="SELECT c FROM CheckShot c")
public class CheckShot extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 巡检记录id
	 */
	@Column(name="check_id")
	private long checkId;

	/**
	 * 权限系统org code
	 */
	@Column(name="org_code")
	private String orgCode;

	/**
	 * 照片内容
	 */
	@Lob
	@Column(name="photo_data")
	private String photoData;

	/**
	 * 拍照点名称
	 */
	@Column(name="point_name")
	private String pointName;

	/**
	 * 拍照类型:1-检查项照片；2-不合格照片
	 * 点现场照片）
	 */
	@Column(name="shot_type")
	private String shotType;

	/**
	 * 检查项id
	 */
	@Column(name="check_input_id")
	private long checkInputId;

	/**
	 * 照片配置key(关联照片和拍照设置),来源picture_json
	 */
	private String photoConfKey;

	/**
	 * 扩展分类id
	 */
	@Column(name="classify_id")
	private long classifyId;

	public long getClassifyId() {
		return classifyId;
	}

	public void setClassifyId(long classifyId) {
		this.classifyId = classifyId;
	}


	public long getCheckInputId() {
		return checkInputId;
	}

	public void setCheckInputId(long checkInputId) {
		this.checkInputId = checkInputId;
	}

	public CheckShot() {
	}

	private Check check;

	public long getCheckId() {
		return this.checkId;
	}

	public void setCheckId(long checkId) {
		this.checkId = checkId;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getPhotoData() {
		return this.photoData;
	}

	public void setPhotoData(String photoData) {
		this.photoData = photoData;
	}

	public String getPhotoConfKey() {
		return photoConfKey;
	}

	public void setPhotoConfKey(String photoConfKey) {
		this.photoConfKey = photoConfKey;
	}

	public String getPointName() {
		return this.pointName;
	}

	public void setPointName(String pointName) {
		this.pointName = pointName;
	}

	public String getShotType() {
		return this.shotType;
	}

	public void setShotType(String shotType) {
		this.shotType = shotType;
	}

	@ManyToOne
	@JoinColumn(name = "checkId", referencedColumnName = "id", updatable = false, insertable = false)
	public Check getCheck() {
		return check;
	}

	public void setCheck(Check check) {
		this.check = check;
	}

}