package com.yeejoin.amos.boot.module.common.api.crypto;

import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;

import java.nio.charset.StandardCharsets;

public class AESUtil {

    private static final String key = "amos-tzs-app-991";
    private static final String iv = "amos-tzs-app-9iv";

    private final AES aes;

    private AESUtil(Mode mode, Padding padding, byte[] key, byte[] iv) {
        aes = new AES(mode, padding, key, iv);
    }

    private static class AESUtilHolder {
        private static final AESUtil instance = new AESUtil(Mode.CBC, Padding.PKCS5Padding, key.getBytes(StandardCharsets.UTF_8), iv.getBytes(StandardCharsets.UTF_8));
    }

    private static AESUtil getInstance() {
        return AESUtilHolder.instance;
    }

    public static String encrypt(String data) {
        return getInstance().aes.encryptBase64(data);
    }

    public static String decrypt(String data) {
        return getInstance().aes.decryptStr(data, StandardCharsets.UTF_8);
    }

}
