package com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl;

import cn.hutool.core.lang.UUID;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.cylinder.api.enums.CommonVideoEnum;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CommonVideoDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitVideoDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderUnit;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderUnitVideo;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderUnitVideoMapper;
import com.yeejoin.amos.boot.module.cylinder.flc.api.service.ICylinderUnitVideoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 气瓶企业信息服务实现类
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Service
public class CylinderUnitVideoServiceImpl extends BaseService<CylinderUnitVideoDto, CylinderUnitVideo, CylinderUnitVideoMapper> implements
        ICylinderUnitVideoService {
    private static final Logger logger = LoggerFactory.getLogger(CylinderUnitVideoServiceImpl.class);
    private static final String CODE_200 = "200";
    private static final String CODE_10001 = "10001";
    private static final String CODE_10005 = "10005";
    private static final String CODE_10017 = "10017";
    private static final String CODE_10030 = "10030";
    private static final String CODE_49999 = "49999";
    private static final String CODE_201 = "201";
    private static final String CODE_401 = "401";
    private static final String CODE_403 = "403";
    private static final String CODE_404 = "404";
    private static final String CODE_20001 = "20001";

    @Value("${cylinder.video.default.image.url:/upload/tzs/cylinder/no-connect.png}")
    private String defaultVideoUrl;

    @Autowired
    CylinderUnitServiceImpl cylinderUnitService;


    @Override
    public List<CommonVideoDto> getUnitVideoUrl(String unitSeq) {
        List<CommonVideoDto> result = new ArrayList<CommonVideoDto>();
        LambdaQueryWrapper<CylinderUnitVideo> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CylinderUnitVideo::getUnitSeq, unitSeq);
        CylinderUnitVideo cylinderUnitVideo = this.getBaseMapper().selectOne(wrapper);
        if (null != cylinderUnitVideo) {
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("appKey", cylinderUnitVideo.getAppKey());
            requestInfo.put("appSecret", cylinderUnitVideo.getAppSecret());
            String channelNos = cylinderUnitVideo.getChannelNo();
            List<CommonVideoDto> channelNoList = JSONObject.parseArray(channelNos, CommonVideoDto.class);
            try {
                String accessTokenData = HttpUtil.post(cylinderUnitVideo.getTokenUrl(), requestInfo);
                JSONObject jsonObject = JSON.parseObject(accessTokenData);
                String msg = jsonObject.get("msg").toString();
                String code = jsonObject.get("code").toString();
                if (CODE_10001.equals(code) || CODE_10005.equals(code) || CODE_10017.equals(code) || CODE_10030.equals(code) || CODE_49999.equals(code)) {
                    String errorMsg = "code:" + code + "msg:" + msg + "appKey:" + cylinderUnitVideo.getAppKey() + "appSecret:" + cylinderUnitVideo.getAppSecret();
                    logger.info("视频token获取失败errorMsg", errorMsg);
                    this.setDefaultVideoIfConnectFailed(channelNoList, result);
                    return result;
                }
                if (CODE_200.equals(code)) {
                    String data = jsonObject.get("data").toString();
                    JSONObject objTokenJson = JSON.parseObject(data);
                    String accessToken = objTokenJson.get("accessToken").toString();
                    System.out.println(accessToken);
                    for (CommonVideoDto channelNo : channelNoList) {
                        HashMap<String, Object> requestVideosInfo = new HashMap<>();
                        requestVideosInfo.put("accessToken", accessToken);
                        requestVideosInfo.put("deviceSerial", cylinderUnitVideo.getDeviceSerial());
                        requestVideosInfo.put("channelNo", channelNo.getKey());
                        requestVideosInfo.put("protocol", cylinderUnitVideo.getProtocol());
                        requestVideosInfo.put("expireTime", cylinderUnitVideo.getExpireTime());
                        String videoData = HttpUtil.post(cylinderUnitVideo.getUrl(), requestVideosInfo);
                        JSONObject videoJsonObject = JSON.parseObject(videoData);
                        String msgVideo = videoJsonObject.get("msg").toString();
                        String codeVideo = videoJsonObject.get("code").toString();
                        if (CODE_201.equals(codeVideo) || CODE_401.equals(codeVideo) || CODE_403.equals(codeVideo) || CODE_404.equals(codeVideo) || CODE_20001.equals(codeVideo)) {
                            String errorMsg = "code:" + codeVideo + "msg:" + msgVideo + "appKey:" + cylinderUnitVideo.getAppKey() + "appSecret:" + cylinderUnitVideo.getAppSecret() + "accessToken:" + accessToken;
                            logger.info("视频地址获取失败errorMsg", errorMsg);
                            this.setDefaultChannelData(result, channelNo);
                            continue;
                        }
                        if (CODE_200.equals(codeVideo)) {
                            String dataS = videoJsonObject.get("data").toString();
                            JSONObject dd = JSON.parseObject(dataS);
                            String url = dd.get("url").toString();
                            CommonVideoDto commonVideoDto = new CommonVideoDto();
                            commonVideoDto.setUrl(url);
                            commonVideoDto.setKey(channelNo.getKey());
                            commonVideoDto.setType(CommonVideoEnum.getEnum(cylinderUnitVideo.getProtocol()).getName());
                            commonVideoDto.setTitle(channelNo.getTitle());
                            commonVideoDto.setThumb(channelNo.getThumb());
                            result.add(commonVideoDto);
                        }
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
                this.setDefaultVideoIfConnectFailed(channelNoList, result);
            }
        }
        return result;
    }

    /**
     * 通道连接不上时，返回通道的默认图片
     *
     * @param result    返回连接的总通道
     * @param channelNo 未连接的通道
     */
    private void setDefaultChannelData(List<CommonVideoDto> result, CommonVideoDto channelNo) {
        CommonVideoDto commonVideoDto = new CommonVideoDto();
        commonVideoDto.setUrl(channelNo.getThumb());
        commonVideoDto.setKey(channelNo.getKey());
        commonVideoDto.setType(CommonVideoEnum.IMG.getName());
        commonVideoDto.setTitle(channelNo.getTitle());
        commonVideoDto.setThumb(channelNo.getThumb());
        result.add(commonVideoDto);
    }

    /**
     * 连接不上时返回的气通道信息
     *
     * @param commonVideoDtos 当前气瓶单位的所有通道
     * @param result          返回的结果集合
     */
    private void setDefaultVideoIfConnectFailed(List<CommonVideoDto> commonVideoDtos, List<CommonVideoDto> result) {
        // 先情况防止数据重复
        result.clear();
        // 每个通道设备默认值
        commonVideoDtos.forEach(channelNo -> this.setDefaultChannelData(result, channelNo));
    }

    private void setDefaultVideoIfNoAccess(List<CommonVideoDto> result, String unitSeq) {
        CylinderUnit cylinderUnit = cylinderUnitService.getBaseMapper().selectOne(new LambdaQueryWrapper<CylinderUnit>().eq(CylinderUnit::getAppId, unitSeq ));
        CommonVideoDto commonVideoDto = new CommonVideoDto();
        commonVideoDto.setUrl(defaultVideoUrl);
        commonVideoDto.setKey(UUID.fastUUID().toString());
        commonVideoDto.setType(CommonVideoEnum.IMG.getName());
        if(cylinderUnit != null){
            commonVideoDto.setTitle(cylinderUnit.getUnitName());
        }
        commonVideoDto.setThumb(defaultVideoUrl);
        result.add(commonVideoDto);
    }
}