package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.yeejoin.amos.boot.biz.common.annotation.ResultFieldMapping;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.vo.JgVehicleInformationVo;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgVehicleInformationServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.Bean;
import java.util.HashMap;
import java.util.Map;

@Component
public class VehicleRegistrationStrategyHandler implements ToBeSubmitDetailStrategy {

    @Autowired
    private JgVehicleInformationServiceImpl vehicleInformationService;

    @Override
    @ResultFieldMapping({
            @ResultFieldMapping.ResultFieldMap(sourceField = "notice.estateUnitName",
                    targetField = "notice.estateUnitSeq",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryTcmUnitSeqByCreditCode",
                    secondParamValue = "CQ"),
            @ResultFieldMapping.ResultFieldMap(sourceField = "notice.inspectUnitCreditCode",
                    targetField = "notice.inspectUnitCreditCode",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryTcmUnitSeqByCreditCode",
                    secondParamValue = "JY,JC"),
            @ResultFieldMapping.ResultFieldMap(sourceField = "notice.installUnitCode",
                    targetField = "notice.installUnitCode",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryTcmUnitSeqByCreditCode",
                    secondParamValue = "AGW")
    })
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        JgVehicleInformationVo vo = vehicleInformationService.queryBySequenceNbr(sequenceNbr);
        Map<String, Object> basic = new HashMap<>();
        Map<String, Object> useRegFormUpload = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.SYDJ.getBusinessCode());
        basic.put("receiveOrgCreditCode1", vo.getReceiveOrgCode());
        basic.put("businessScenarios", "1");
        basic.put("code", "2300");
        basic.put("equCategory", "23T0");
        basic.put("isTempEquip", true);
        Map<String, Map<String, Object>> result = new HashMap<>();
        useRegFormUpload.put("useRegistrationFormUrl", vo.getUseRegistrationFormUrl());
        result.put("notice", Bean.BeantoMap(vo));
        result.put("basic", basic);
        result.put("useRegFormUpload", useRegFormUpload);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_VEHICLE_GAS_APPLICATION.getName();
    }
}
