package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author Administrator
 */
@Getter
public enum OpenBizTypeEnum {

    /**
     * 业务类型
     */
    JY("jy","检验业务"),
    JC("jc","检测业务");

    private final String code;

    private final String name;

    OpenBizTypeEnum(String code, String name){
        this.code = code;
        this.name = name;
    }

    public static OpenBizTypeEnum getOneByCode(String code){
        Optional<OpenBizTypeEnum> op = Arrays.stream(OpenBizTypeEnum.values()).filter(e->e.getCode().equals(code)).findFirst();
        return op.orElse(null);
    }
}
