package com.yeejoin.amos.supervision.business.service.intfc;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.supervision.business.entity.mybatis.CheckChkExListBo;
import com.yeejoin.amos.supervision.business.vo.CodeOrderVo;
import com.yeejoin.amos.supervision.business.vo.LeavePlanTaskVo;
import com.yeejoin.amos.supervision.business.vo.PlanTaskVo;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import org.springframework.data.domain.Page;

import com.yeejoin.amos.supervision.business.param.CheckPtListPageParam;
import com.yeejoin.amos.supervision.business.param.PlanTaskPageParam;
import com.yeejoin.amos.supervision.core.common.response.AppPointCheckRespone;
import com.yeejoin.amos.supervision.dao.entity.PlanTask;

public interface IPlanTaskService {


	/**
	 * 计划执行查询
	 */
	Page<HashMap<String, Object>> getPlanTaskInfo(PlanTaskPageParam params);

	/**
	 * 计划执行重做
	 */
	void reGenPlanTask(HashMap<String, Object> param) throws ParseException;

	/**
	 * 计划执行删除
	 */
	void planTaskDet(String[] strArry);

	/**
	 * 执行计划导出
	 */
	List<PlanTaskVo> planTaskReport(String toke, String product, String appKey, PlanTaskPageParam params);
	/**
	 * 自动任务执行
	 * @param runDate
	 */
	void taskExecution(String runDate);

	/**
	 * 根据路线id获取关联的所有计划任务
	 *
	 * @param routeId
	 * @return
	 */
	List<PlanTask> getPlanTaskByRouteId(Long routeId);

	/**
	 * 停用计划任务
	 *
	 * @param routeIds
	 */
	void disablePlanTask(Long[] routeIds);

	/**
	 * app 根据条件查询用户权限内所有当前巡检计划任务
	 * @param params
	 * @return
	 */
	List getPlanTaskInfo(HashMap<String, Object> params);

	/**
	 * 根据计划任务ID查询任务想起
	 * @param id
	 * @return
	 */
	public Map findPlanTaskByTaskIdAndPointId(long id, long pointId);

	/**
	 *	 天剑查询假话任务信息
	 * @param params
	 * @param page
	 * @return
	 */
	Page<HashMap<String, Object>> getPlanTasks(HashMap<String, Object> params, CommonPageable page);

	/**
	 *  根据计划任务Id获取计划任务信息
	 * @param planTaskId
	 * @return
	 */
	Map queryPlanTaskById(Long planTaskId);

	/**
	 * 	根据计划ID获取所有的 任务计划巡检点
	 * @param params
	 * @return
	 */
	Page<Map<String, Object>> getPlanTaskPoints(HashMap<String, Object> params,  CommonPageable pageable);

	/**
	 * 	获取用户当前所有有的计划任务
	 * @param userId
	 * @return
	 */
	int getCurrentPlanTaskCount(String userId);
    /**
     * 今日执行情况
     * @param params
     * @return
     */
	Page<CheckChkExListBo> getChkExList(String toke, String product, String appKey, CheckPtListPageParam params);

	/**
	 * 根据id获取执行计划
	 * @param ids
	 * @return
	 */
	List<PlanTaskVo> getPlanTaskListByIds(String toke,String product,String appKey,Long[] ids);

	/**
	 * 根据任务id点id 获取点详情
	 * @param planTaskId
	 * @param pointId
	 * @return
	 */
	AppPointCheckRespone queryPointPlanTaskDetail(String toke,String product,String appKey,Long planTaskId,Long pointId);

	AppPointCheckRespone queryPointPlanTaskDetailInVersion2(String toke,String product,String appKey,Long planTaskId,Long pointId);

	Map<String, Object> getPlanTaskStatisticsForApp(HashMap<String, Object> params);

	/**
	 * 获取公司计划累计情况
	 * @param loginOrgCode
	 * @return
	 */
	String getCumulativePlanCountByOrgCode(String loginOrgCode);

	List<LeavePlanTaskVo> queryLeavePlanTask(HashMap<String, Object> params);


	List<CodeOrderVo> queryCodeOrderVo(HashMap<String, Object> params);

	PlanTask selectPlanTaskStatus(Long id);

	public void reformStatisticsPlanTask(String strBginDate, String strEndDate, String userId, String orgCode) throws ParseException;

	void initPlanStatusOrGenDate();

	List<Map<String,Object>> queryPlanTaskTimeAxis(Long userId,Integer createDate);

	List<Map<String,Object>> queryTimeAxis(Long userId,Integer createDate);
}
