package com.yeejoin.amos.boot.biz.common.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import springfox.documentation.annotations.ApiIgnore;

/**
 * 基础控制器
 *
 * @author
 */
@ApiIgnore
@RestController
@RequestMapping("/base")
public class BaseController {
//
//    /**
//     * 成功返回状态
//     */
//    protected static final String SUCCESS = "SUCCESS";
//    /**
//     * 失败返回状态
//     */
//    protected static final String FAILED = "FAILED";
//    /**
//     * 默认页大小
//     */
//    protected static final int DEFAULT_PAGE_SIZE = 10;
//
//    @Autowired
//    protected HttpServletRequest request;

    @Autowired
    private RedisUtils redisUtils;

    /**
     * 获取token
     **/
    protected String getToken() {
        return RequestContext.getToken();
    }
//
//    /**
//     * 获取Product
//     **/
//    protected String getProduct() {
//        String product = request.getHeader("product");
//        if (product == null) {
//            product = request.getParameter("product");
//        }
//        return product;
//    }
//
//    /**
//     * 获取AppKey
//     **/
//    protected String getAppKey() {
//        String appKey = request.getHeader("appKey");
//        if (appKey == null) {
//            appKey = request.getParameter("appKey");
//        }
//        return appKey;
//    }
//
//    /**
//     * redi缓存选择的用户信息key
//     *
//     * @param userId
//     * @param token
//     * @return
//     */
////    private String buildKey(String userId, String token) {
////
////       return "region_" + userId + "_" + token;
//// 
////    }

      protected String buildKey(String token) {
    	//由于用户id 不是接口携带参数，为了避免，公共字段填充时频繁访问平台，缓存用户信息时， 
    	       return "region_" + token;
    	
   	    }
//    /**
//     * 用户选择信息保存redis
//     */
//    protected void saveSelectedOrgInfo(ReginParams reginParams) {
//    	//由于用户id 不是接口携带参数，为了避免，公共字段填充时频繁访问平台，缓存用户信息时， 
//     redisUtils.set(buildKey(getToken()), JSONObject.toJSONString(reginParams));
//       
//    }
//    
//    protected void  saveUser(AgencyUserModel agencyUserModel) {
//    	//由于用户id 不是接口携带参数，为了避免，公共字段填充时频繁访问平台，缓存用户信息时， 
//     redisUtils.set(getToken(), JSONObject.toJSONString(agencyUserModel));
//       
//    }
//
//    /**
//     * 获取结构code
//     *
//     * @return
//     */
//    protected String getOrgCode() {
//        ReginParams reginParams = getSelectedOrgInfo();
//        if (reginParams == null) {
//            return null;
//        }
//        if (reginParams.getCompany() != null) {
//            return reginParams.getCompany().getOrgCode();
//        }
//
//        return null;
//    }
//
    /**
     * 用户选择信心redis获取
     **/
    protected ReginParams getSelectedOrgInfo() {
    	//由于用户id 不是接口携带参数，为了避免，公共字段填充时频繁访问平台，缓存用户信息时， 
       // return JSONObject.parseObject(redisUtils.get(buildKey(getUserId(), getToken())).toString(), ReginParams.class);
    	return JSONObject.parseObject(redisUtils.get(buildKey( RequestContext.getToken())).toString(), ReginParams.class);
    }

    /**
     * 当前登录用户信息
     */
    protected AgencyUserModel getUserInfo() {
        AgencyUserModel userModel = null;
        if (getToken() != null) {
//            RequestContext.setToken(getToken());
//            RequestContext.setProduct(getProduct());
//            RequestContext.setAppKey(getAppKey());
            FeignClientResult<?> feignClientResult;
            try {
                feignClientResult = Privilege.agencyUserClient.getme();
                userModel = (AgencyUserModel) feignClientResult.getResult();

            } catch (InnerInvokException e) {
                throw new RuntimeException(e.getMessage());
            }

        }
        return userModel;

    }
//
//    /**
//     * 获取当前登录用户id
//     **/
//    protected String getUserId() {
//        String userId = null;
//        if (getUserInfo() != null) {
//            userId = getUserInfo().getUserId();
//        }
//        return userId;
//    }
//
//    /**
//     * 获取请求的cookies
//     *
//     * @return
//     */
//    protected HashMap<String, String> getCookInfoMap() {
//        HashMap<String, String> map = new HashMap<String, String>();
//        Cookie[] cookies = request.getCookies();
//        if (cookies != null) {
//            for (Cookie ck : cookies) {
//                map.put(ck.getName(), ck.getValue());
//            }
//        }
//        return map;
//    }
//
//    /**
//     * 获取登录用户getLoginOrgCode
//     **/
//    protected String getLoginOrgCode(ReginParams reginParams) {
//        if (reginParams == null) {
//            return null;
//        }
//        if (reginParams.getDepartment() != null) {
//            return reginParams.getDepartment().getOrgCode();
//        }
//        if (reginParams.getCompany() != null) {
//            return reginParams.getCompany().getOrgCode();
//        }
//        return null;
//    }
//
//    /**
//     * 获取部门id
//     **/
//    protected Long getDepartmentId(ReginParams reginParams) {
//        if (reginParams == null) {
//            return null;
//        }
//        if (reginParams.getDepartment() != null) {
//            return reginParams.getDepartment().getSequenceNbr();
//        }
//        return null;
//    }
//
//    /**
//     * 获取公司id
//     **/
//    protected Long getCompanyId(ReginParams reginParams) {
//        if (reginParams == null) {
//            return null;
//        }
//        if (reginParams.getCompany() != null) {
//            return reginParams.getCompany().getSequenceNbr();
//        }
//        return null;
//    }
//
//    /**
//     * <pre>
//     * 提取错误异常中的错误消息
//     * </pre>
//     *
//     * <p>
//     * 当实体类中对属相注解了以下类似的注解，需要用try.catch语句捕获异常，使用 #getErrorMessage(Exception)
//     * 提取出异常信息NotNull(message = "属性不能为空！")
//     * </p>
//     *
//     * @param e
//     * @return
//     * @see {@code NotBlank} ... NotNull、NotEmpty...
//     * @see {@code Valid}
//     */
//    public String getErrorMessage(Exception e) {
//        StringBuilder message = new StringBuilder();
//        if (e instanceof TransactionSystemException) {
//            TransactionSystemException exception = (TransactionSystemException) e;
//            if (exception.getRootCause() instanceof ConstraintViolationException) {
//                ConstraintViolationException root = (ConstraintViolationException) exception.getRootCause();
//                root.getConstraintViolations().forEach(constraintViolation -> {
//                    message.append(constraintViolation.getMessageTemplate());
//                });
//            } else {
//                message.append(e.getMessage());
//            }
//        } else if (e instanceof ConstraintViolationException) {
//            ((ConstraintViolationException) e).getConstraintViolations()
//                    .forEach(constraintViolation -> message.append(constraintViolation.getMessageTemplate()));
//        } else {
//            message.append("操作异常！");
//        }
//        return message.toString();
//    }
}
