package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
* 动态表单实例表
*
* @author system_generator
* @date 2021-07-06
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DynamicFormInstanceDto", description="动态表单实例表")
public class DynamicFormInstanceDto  extends BaseDto {

  

   private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "字段名")
    private String fieldCode;

    @ApiModelProperty(value = "中文名")
    private String fieldName;

    @ApiModelProperty(value = "数据类型：文本，数字，枚举,日期")
    private String fieldType;

    @ApiModelProperty(value = "分组编号")
    private String groupCode;

    @ApiModelProperty(value = "字段分组id")
    private Long groupId;

    @ApiModelProperty(value = "动态配置字段的值")
    private String fieldValue;

    @ApiModelProperty(value = "field_value的描述（冗余字段，在列表时查询时显示）")
    private String fieldValueLabel;

    @ApiModelProperty(value = "设备实例id")
    private Long instanceId;

    @ApiModelProperty(value = "字段定义信息的主键")
    private Long formColumnId;

    @ApiModelProperty(value = "查询策略;全等,模糊,区间")
    private String queryStrategy;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ApiModelProperty(value = "应用标识（数据隔离使用）")
    private String appKey;
    
    /**
	  * 不能为空
     */
	@TableField("not_null")
    private Boolean notNull;
	
    @ApiModelProperty(value = "是否一行显示(兼容已有动态表单使用)")
    private Boolean block;
    
    @ApiModelProperty(value = "配置json")
    private JSONObject columnConfig;
    
    //新加排序字段
    @ApiModelProperty(value = "排序字段")
    private int sort;
    
    public DynamicFormInstanceDto() {};

    public DynamicFormInstanceDto(Long sequenceNbr, String fieldName, String fieldCode, Boolean block,
			String groupCode) {
		this.formColumnId = sequenceNbr;
		this.fieldName = fieldName;
		this.fieldCode = fieldCode;
		this.block = block;
		this.groupCode = groupCode;
	}
}
