package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
* 消防队员
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="FirefightersDto", description="消防队员")
public class FirefightersExcelDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelIgnore
    @ApiModelProperty(value = "系统账号")
    private String systemAccount;

    @ExcelProperty(value = "姓名", index = 0)
    @ApiModelProperty(value = "姓名")
    private String name;

    @ExcelProperty(value = "员工编码", index = 1)
    @ApiModelProperty(value = "员工编码")
    private String employeeNumber;

    @ExplicitConstraint(indexNum = 2, sourceClass = RoleNameExplicitConstraint.class,method="getFireTeam") //动态下拉内容
    @ExcelProperty(value = "消防队伍", index = 2)
    @ApiModelProperty(value = "队伍")
    private String fireTeam;

    @ExcelProperty(value = "所属部门", index = 3)
    @ApiModelProperty(value = "所属机构")
    private String company;

    @ExcelIgnore
    @ApiModelProperty(value = "机构code")
    private String companyCode;

    @ExcelIgnore
    @ApiModelProperty(value = "机构名称")
    private String companyName;

    @ExplicitConstraint(type = "RYZJLX", indexNum = 4, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "证件类型", index = 4)
    @ApiModelProperty(value = "常用证件类型代码")
    private String certificatesType;

    @ExcelProperty(value = "证件号码", index = 5)
    @ApiModelProperty(value = "证件号码")
    private String certificateNumber;

    @ExcelProperty(value = "出生日期", index = 6)
    @ApiModelProperty(value = "出生日期")
    private Date birthdayTime;

    @ExplicitConstraint(indexNum = 7, source = {"男", "女"}) //固定下拉内容
    @ExcelProperty(value = "性别", index = 5)
    @ApiModelProperty(value = "性别")
    private String gender;

    @ExplicitConstraint(indexNum = 8, sourceClass = RoleNameExplicitConstraint.class, method = "getNations") //固定下拉内容
    @ExcelProperty(value = "民族", index = 8)
    @ApiModelProperty(value = "民族")
    private String nation;

    @ExplicitConstraint(indexNum = 9, sourceClass = RoleNameExplicitConstraint.class, method = "getMaritalStatus") //固定下拉内容
    @ExcelProperty(value = "婚姻状况", index = 9)
    @ApiModelProperty(value = "婚姻状况")
    private String maritalStatus;

    @ExcelProperty(value = "户籍所在地", index = 10)
    @ApiModelProperty(value = "籍贯/户口所在地")
    private String nativePlace;

    @ExplicitConstraint(indexNum = 11, sourceClass = RoleNameExplicitConstraint.class, method = "getPoliticalOutlook") //固定下拉内容
    @ExcelProperty(value = "政治面貌", index = 11)
    @ApiModelProperty(value = "政治面貌代码")
    private String politicalOutlook;

    @ExcelProperty(value = "现居住地", index = 12)
    @ApiModelProperty(value = "现居住地")
    private String residence;

    @ExcelIgnore
    @ApiModelProperty(value = "现居住地详情")
    private String residenceDetails;

    @ExcelProperty(value = "机场住宿情况", index = 13)
    @ApiModelProperty(value = "机场住宿情况")
    private String airportAccommodation;

    @ExcelProperty(value = "联系电话", index = 14)
    @ApiModelProperty(value = "手机")
    private String mobilePhone;

    @ExplicitConstraint(type = "RYZT", indexNum = 15, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "人员状态", index = 15)
    @ApiModelProperty(value = "人员状态，在职/离职")
    private String state;

    @ExcelIgnore
    @ApiModelProperty(value = "人员状态，在职/离职字典code")
    private String stateCode;

    @ExplicitConstraint(type = "GWMC", indexNum = 16, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "岗位名称", index = 16)
    @ApiModelProperty(value = "岗位名称")
    private String jobTitle;

    @ExcelProperty(value = "紧急联系人姓名", index = 17)
    @ApiModelProperty(value = "紧急联系人姓名")
    private String emergencyContact;

    @ExplicitConstraint(type = "RJGX", indexNum = 18, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "与紧急联系人关系", index = 18)
    @ApiModelProperty(value = "紧急联系人与本人所属关系")
    private String relationship;

    @ExcelProperty(value = "紧急联系人电话", index = 19)
    @ApiModelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    @ExcelProperty(value = "身份证正面", index = 20)
    @ApiModelProperty(value = "身份证正面")
    private String idPositive;

    @ExcelProperty(value = "身份证反面", index = 21)
    @ApiModelProperty(value = "身份证反面")
    private String idReverse;

    @ExcelIgnore
    @ApiModelProperty(value = "办公电话")
    private String officeTelephone;

    @ExcelIgnore
    @ApiModelProperty(value = "互联网_电子信箱")
    private String email;

    @ExcelIgnore
    @ApiModelProperty(value = "人员照片")
    private String personnelPhotos;

    @ExcelIgnore
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ExcelIgnore
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ExcelIgnore
    @ApiModelProperty(value = "岗位资质")	
    private String postQualification;

    @ExcelIgnore
    @ApiModelProperty(value = "专家领域")
    private String areasExpertise;

}
