package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Objects;

/**
* 值班人员日期关联关系表
*
* @author system_generator
* @date 2021-07-06
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_duty_person_shift")
public class DutyPersonShift extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
	  * 值班日期
     */
	@TableField("duty_date")
    private Date dutyDate;
    /**
	  * 值班班次id
     */
	@TableField("shift_id")
    private Long shiftId;
    /**
	  * 实例id
     */
	@TableField("instance_id")
    private Long instanceId;
    /**
	  * 更新人员
     */
	@TableField("rec_user_name")
    private String recUserName;

    /**
     * 应用标识（数据隔离使用）
     */
	private String appKey;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DutyPersonShift)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DutyPersonShift that = (DutyPersonShift) o;
        return Objects.equals(dutyDate, that.dutyDate) &&
                Objects.equals(instanceId, that.instanceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), dutyDate, instanceId);
    }
}
