package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonDto;
import com.yeejoin.amos.boot.module.common.biz.service.IDutyPersonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.util.List;
import java.util.Map;


/**
 * 值班班次
 *
 * @author system_generator
 * @date 2021-07-06
 */
@RestController
@Api(tags = "值班人员接口Api")
@RequestMapping(value = "/common/duty-person")
public class DutyPersonController extends BaseController {

    @Autowired
    IDutyPersonService iDutyPersonService;


    /**
     * 值班列表视图--分页
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page-list")
    @ApiOperation(httpMethod = "GET", value = "值班列表视图", notes = "值班列表视图")
    public ResponseModel<IPage<Map<String, Object>>> pageList(
            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate,
            @ApiParam(value = "当前页", required = true) @RequestParam(value = "current") int current,
            @ApiParam(value = "页面大小", required = true) @RequestParam(value = "size") int size) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.pageList(current, size, beginDate, endDate));
    }

    /**
     * 值班列表视图--不分页
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/list")
    @ApiOperation(httpMethod = "GET", value = "值班列表视图-不分页", notes = "值班列表视图-不分页")
    public ResponseModel list(@ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
                              @ApiParam(value = "结束日期", required = true) @RequestParam String endDate) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.list(beginDate, endDate));
    }


    /**
     * 值班月视图
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/duty-detail")
    @ApiOperation(httpMethod = "GET", value = "值班月视图", notes = "值班月视图")
    public ResponseModel<List<Map<String, Object>>> dutyDetail(
            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate
    ) throws ParseException {
        return ResponseHelper.buildResponse(iDutyPersonService.statisticsDay(beginDate, endDate));
    }


    /**
     * 调班
     *
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping("/duty-adjust")
    @ApiOperation(httpMethod = "POST", value = "调班保存", notes = "调班保存")
    public ResponseModel dutyAdjust(@RequestBody DutyPersonDto dutyPersonDto) {
        return ResponseHelper.buildResponse(iDutyPersonService.save(dutyPersonDto));
    }


    /**
     * 调班
     *
     * @param instanceId    实例id
     * @param dutyPersonDto 业务对象
     * @return DutyCarDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping("/duty-adjust")
    @ApiOperation(httpMethod = "PUT", value = "调班更新", notes = "调班更新")
    public ResponseModel dutyAdjustUpdate(
            @RequestParam Long instanceId,
            @RequestBody DutyPersonDto dutyPersonDto) {
        return ResponseHelper.buildResponse(iDutyPersonService.update(instanceId, dutyPersonDto));
    }
}
