package com.yeejoin.amos.boot.module.common.biz.controller;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.feign.AmosFeignService;
import com.yeejoin.amos.boot.module.common.api.entity.DutyPersonShift;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.*;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyPersonShiftServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonShiftDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;


/**
* 值班人员日期关联关系表
*
* @author system_generator
* @date 2021-07-06
*/
@RestController
@Api(tags = "值班人员日期关联关系表Api")
@RequestMapping(value = "/common/duty-person-shift")
public class DutyPersonShiftController extends BaseController {

    @Autowired
    DutyPersonShiftServiceImpl dutyPersonShiftServiceImpl;
    @Autowired
	AmosFeignService amosFeignService;

    /**
             * 新增值班人员日期关联关系表
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增值班人员日期关联关系表", notes = "新增值班人员日期关联关系表")
	public ResponseModel<DutyPersonShiftDto> save(@RequestBody DutyPersonShiftDto model)
	{
	    model=dutyPersonShiftServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}
	/**
             * 根据sequenceNbr更新
    * @param sequenceNbr 主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新值班人员日期关联关系表", notes = "根据sequenceNbr更新值班人员日期关联关系表")
	public ResponseModel<DutyPersonShiftDto> updateBySequenceNbrDutyPersonShift(@RequestBody DutyPersonShiftDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(dutyPersonShiftServiceImpl.updateWithModel(model));
	}
	/**
             * 根据sequenceNbr删除
    * @param sequenceNbr 主键
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除值班人员日期关联关系表", notes = "根据sequenceNbr删除值班人员日期关联关系表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
		DutyPersonShift shift = dutyPersonShiftServiceImpl.getById(sequenceNbr);
		Long instanceId = shift.getInstanceId();
		Long dateTime = shift.getDutyDate().getTime();
		List<Long> shifts = new ArrayList<>();
		List<DutyPersonShift> list = dutyPersonShiftServiceImpl.list(new QueryWrapper<DutyPersonShift>().eq("instance_id", instanceId));
		list.forEach(x -> {
			if (dateTime >= x.getDutyDate().getTime()) {
				shifts.add(x.getSequenceNbr());
			}
		});
        return ResponseHelper.buildResponse(dutyPersonShiftServiceImpl.removeByIds(shifts));
    }
    /**
             * 根据sequenceNbr查询
    * @param sequenceNbr  主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个值班人员日期关联关系表",  notes = "根据sequenceNbr查询单个值班人员日期关联关系表")
	public ResponseModel<DutyPersonShiftDto> seleteOne(@PathVariable Long sequenceNbr)
	{
	    return ResponseHelper.buildResponse(dutyPersonShiftServiceImpl.queryBySeq(sequenceNbr));
	}
	/**
             * 列表分页查询
    *@param current 当前页
    *@param current 每页大小
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "值班人员日期关联关系表分页查询",  notes = "值班人员日期关联关系表分页查询")
	public ResponseModel<Page<DutyPersonShiftDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam(value = "size") int size)
	{
	    Page<DutyPersonShiftDto> page=new Page<DutyPersonShiftDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(dutyPersonShiftServiceImpl.queryForDutyPersonShiftPage(page));
	}
	/**
	*列表全部数据查询
	*@return
	*/
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "值班人员日期关联关系表列表全部数据查询",   notes = "值班人员日期关联关系表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DutyPersonShiftDto>>  selectForList()
	{
	    return ResponseHelper.buildResponse(dutyPersonShiftServiceImpl.queryForDutyPersonShiftList());
	}

	/**
	  * <pre>
	  * @Description:
	  * </pre>
	  *
	  * @MethodName:
	  * @Param:
	  * @Return:
	  * @Throws
	  * @Author keyong
	  * @Date 2021/7/7 19:34
	  */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "岗位枚举数据查询",   notes = "岗位枚举数据查询")
	@GetMapping(value = "/list/station")
	public ResponseModel<List<DictionarieValueModel>> selectStationList() throws Exception {
		return ResponseHelper.buildResponse(amosFeignService.listDictionaryByDictCode("POST_TYPE"));
	}
}
