package com.yeejoin.amos.boot.module.common.biz.controller;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyShiftServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DutyShiftDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;


/**
* 值班班次
*
* @author system_generator
* @date 2021-07-06
*/
@RestController
@Api(tags = "值班班次Api")
@RequestMapping(value = "/common/duty-shift")
public class DutyShiftController extends BaseController {

    @Autowired
    DutyShiftServiceImpl dutyShiftServiceImpl;

    /**
             * 新增值班班次
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增值班班次", notes = "新增值班班次")
	public ResponseModel<DutyShiftDto> save(@RequestBody DutyShiftDto model)
	{
	    model=dutyShiftServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}
	/**
             * 根据sequenceNbr更新
    * @param sequenceNbr 主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新值班班次", notes = "根据sequenceNbr更新值班班次")
	public ResponseModel<DutyShiftDto> updateBySequenceNbrDutyShift(@RequestBody DutyShiftDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(dutyShiftServiceImpl.updateWithModel(model));
	}
	/**
             * 根据sequenceNbr删除
    * @param sequenceNbr 主键
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除值班班次", notes = "根据sequenceNbr删除值班班次")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(dutyShiftServiceImpl.removeById(sequenceNbr));
    }
    /**
             * 根据sequenceNbr查询
    * @param sequenceNbr  主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个值班班次",  notes = "根据sequenceNbr查询单个值班班次")
	public ResponseModel<DutyShiftDto> seleteOne(@PathVariable Long sequenceNbr)
	{
	    return ResponseHelper.buildResponse(dutyShiftServiceImpl.queryBySeq(sequenceNbr));
	}
	/**
             * 列表分页查询
    *@param current 当前页
    *@param current 每页大小
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "值班班次分页查询",  notes = "值班班次分页查询")
	public ResponseModel<Page<DutyShiftDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam(value = "size") int size)
	{
	    Page<DutyShiftDto> page=new Page<DutyShiftDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(dutyShiftServiceImpl.queryForDutyShiftPage(page));
	}
	/**
	*列表全部数据查询
	*@return
	*/
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "值班班次列表全部数据查询",   notes = "值班班次列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DutyShiftDto>>  selectForList()
	{
	    return ResponseHelper.buildResponse(dutyShiftServiceImpl.queryForDutyShiftList());
	}
}
