package com.yeejoin.amos.boot.module.common.biz.service;

import com.baomidou.mybatisplus.core.metadata.IPage;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IDutyCommonService {
    /**
     * 分页查询
     *
     * @param current   当前页
     * @param size      页大小
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return IPage<Map < String, Object>>
     */
    IPage<Map<String, Object>> pageList(int current, int size, String beginDate, String endDate) throws ParseException;

    /**
     * 值班明细
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return ResponseModel
     */
    List<Map<String, Object>> statisticsDay(String beginDate, String endDate) throws ParseException;

    /**
     * 不分页查询
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return ResponseModel
     */
    List<Map<String, Object>> list(String beginDate, String endDate) throws ParseException;

    /**
     * 获取表单参数
     *
     * @return String
     */
    String getGroupCode();
}
