package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.common.api.dto.DutyCarDto;
import com.yeejoin.amos.boot.module.common.api.entity.DutyPersonShift;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormColumn;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.biz.service.IDutyCarService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Service
public class DutyCarServiceImpl extends DutyCommonServiceImpl implements IDutyCarService {

    @Override
    public String getGroupCode() {
        return "dutyCar";
    }

    @Override
    public DutyCarDto save(DutyCarDto dutyCarDto) {
        //1.保存行数据
        String groupCode = this.getGroupCode();
        List<DynamicFormColumn> columns = dynamicFormColumnService.list(new LambdaQueryWrapper<DynamicFormColumn>().eq(DynamicFormColumn::getGroupCode, groupCode));
        Map<String, Object> map = Bean.BeantoMap(dutyCarDto);
        Long instanceId = sequence.nextId();
        List<DynamicFormInstance> instances = columns.stream().map(column -> {
            DynamicFormInstance instance = new DynamicFormInstance();
            buildFormInstanceData(instanceId, map, column, instance);
            return instance;
        }).collect(Collectors.toList());
        if (!instances.isEmpty()) {
            dynamicFormInstanceService.saveBatch(instances);
        }
        //2.保存值班信息
        insertPersonShift(instanceId, dutyCarDto);
        //3.返回保存后的数据
        return dutyCarDto;
    }

    @Override
    public DutyCarDto update(Long instanceId, DutyCarDto dutyCarDto) {
        String groupCode = this.getGroupCode();
        //1.查询已有数据
        List<DynamicFormInstance> instances = dynamicFormInstanceService.list(new LambdaQueryWrapper<DynamicFormInstance>().eq(DynamicFormInstance::getInstanceId, instanceId));
        //2.list 转 map
        Map<Object, DynamicFormInstance> instanceMap = Bean.listToMap(instances, "fieldCode", DynamicFormInstance.class);
        //3.查询列数据，已列为主
        List<DynamicFormColumn> columns = dynamicFormColumnService.list(new LambdaQueryWrapper<DynamicFormColumn>().eq(DynamicFormColumn::getGroupCode, groupCode));
        //页面数据转Map
        Map<String, Object> map = Bean.BeantoMap(dutyCarDto);
        //4.已列为主 填充动态表单数据
        List<DynamicFormInstance> entrys = new ArrayList<>();
        updateFormValue(entrys, map, instanceId, columns, instanceMap);
        if (!entrys.isEmpty()) {
            dynamicFormInstanceService.saveOrUpdateBatch(entrys);
        }
        //5.更新值班信息人日期数据
        insertPersonShift(instanceId, dutyCarDto);
        return dutyCarDto;
    }

    private void insertPersonShift(Long instanceId, DutyCarDto dutyCarDto) {
        Set<DutyPersonShift> personShiftList = dutyCarDto.getDutyShift().stream().map(dto -> {
            DutyPersonShift dutyPersonShift = new DutyPersonShift();
            dto.setInstanceId(instanceId);
            Bean.copyExistPropertis(dto, dutyPersonShift);
            return dutyPersonShift;
        }).collect(Collectors.toSet());
        if (!personShiftList.isEmpty()) {
            dutyPersonShiftService.saveOrUpdateBatch(personShiftList);
        }
    }

    private void buildFormInstanceData(Long instanceId, Map<String, Object> map, DynamicFormColumn column, DynamicFormInstance formInstance) {
        fillFormInstanceData(instanceId, map, column, formInstance, sequence.nextId());
    }
}
