package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInstanceDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.mapper.DynamicFormInstanceMapper;
import com.yeejoin.amos.boot.module.common.api.service.IDynamicFormInstanceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * 动态表单实例表服务实现类
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Service
public class DynamicFormInstanceServiceImpl extends BaseService<DynamicFormInstanceDto, DynamicFormInstance, DynamicFormInstanceMapper> implements IDynamicFormInstanceService {

    @Autowired
    private DynamicFormInstanceMapper dynamicFormInstanceMapper;

    /**
     * 分页查询
     */
    public Page<DynamicFormInstanceDto> queryForDynamicFormInstancePage(Page<DynamicFormInstanceDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<DynamicFormInstanceDto> queryForDynamicFormInstanceList() {
        return this.queryForList("", false);
    }


    public List<DynamicFormInstanceDto> queryByCalledId(Long instanceId) {
        return this.queryForList(null, false, instanceId);
    }

    public List<DynamicFormInstanceDto> listByCalledId(Long instanceId) {
        return dynamicFormInstanceMapper.selectListByCalledId(instanceId);
    }

}
