package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.*;
import com.yeejoin.amos.boot.module.common.biz.service.impl.*;
import com.yeejoin.amos.boot.module.jcs.api.entity.Aircraft;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.FireTeamServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftDto;
import com.yeejoin.amos.boot.module.jcs.api.enums.ExcelEnums;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AircraftServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.DataSourcesImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 导出导入
 *
 * @author system_generator
 * @date 2021-06-29
 */
@RestController
@Api(tags = "导出")
@RequestMapping(value = "/excel")
public class ExcelController extends BaseController {

    @Autowired
    DataSourcesImpl dataSourcesImpl;
    @Autowired
    FireChemicalServiceImpl fireChemicalServiceImpl;
    @Autowired
    FireExpertsServiceImpl fireExpertsServiceImpl;
    @Autowired
    WaterResourceServiceImpl waterResourceServiceImpl;
    @Autowired
    AircraftServiceImpl aircraftServiceImpl;
    @Autowired
    FireTeamServiceImpl fireTeamService;
    @Autowired
    FireStationServiceImpl fireStationService;
    @Autowired
    FirefightersServiceImpl firefightersService;


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "下载模板")
    @GetMapping("/template")
    public void template(HttpServletResponse response, ExcelDto excelDto) {
        try {
            String url = excelDto.getClassUrl();
            Class<?> clz = Class.forName(url);
            ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), null, clz,
                    dataSourcesImpl, true);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出公用类")
    @GetMapping("/export")
    public void getFireStationFile(HttpServletResponse response, ExcelDto excelDto) {
        try {
            switch (excelDto.getType()) {

                case ExcelEnums.WHP:
                    List<FireChemicalDto> data = fireChemicalServiceImpl.queryForFireChemicalList(false);
                    ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), data,
                            FireChemicalDto.class, dataSourcesImpl, false);
                    break;
                case ExcelEnums.XFZJ:
                    List<FireExpertsDto> fireExpertsDtoList = fireExpertsServiceImpl.queryForFireExpertsList(false);
                    ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
                            fireExpertsDtoList, FireExpertsDto.class, dataSourcesImpl, false);
                    break;
                case ExcelEnums.SYXX:
                    List<WaterResourceDto> waterResourceDtoList = waterResourceServiceImpl.exportToExcel(true);
                    ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
                            waterResourceDtoList, WaterResourceDto.class, dataSourcesImpl, false);
                    break;
                case ExcelEnums.HKQ:
                    List<AircraftDto> aircraftDtoList = aircraftServiceImpl.queryAircraftDtoForList(false);
                    ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
                            aircraftDtoList, AircraftDto.class, dataSourcesImpl, false);
                    break;
                case ExcelEnums.XFDW:
                    List<FireTeamDto> fireTeamDtoList = fireTeamService.queryFireTeamForList(false);
                    ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), fireTeamDtoList,
                            FireTeamDto.class, dataSourcesImpl, false);
                    break;
                case ExcelEnums.WXXFZ:
                    List<FireStationDto> fireStationDtoList = fireStationService.queryForFireStationList(false);
                    ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
                            fireStationDtoList, FireStationDto.class, null, false);
                    break;
                case ExcelEnums.XFRY:
                    List<FirefightersExcelDto> firefightersExcelDtoList = firefightersService.exportToExcel(false);
                    ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
                            firefightersExcelDtoList, FirefightersExcelDto.class, null, false);
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "上传文件数据-")
    @PostMapping("/upload")
    public void template2(MultipartFile multipartFile, ExcelDto excelDto) {
        try {
            switch (excelDto.getType()) {

                case ExcelEnums.WHP:
                    excelImportFireChemical(multipartFile);
                    break;
                case ExcelEnums.XFZJ:
                    excelImportFireExperts(multipartFile);
                    break;
                case ExcelEnums.SYXX:
                    excelImportWaterResource(multipartFile);
                    break;
                case ExcelEnums.HKQ:
                    excelImportAircraft(multipartFile);
                    break;
                case ExcelEnums.XFDW:
                    excelImportFireTeam(multipartFile);
                    break;
                case ExcelEnums.WXXFZ:
                    excelImportFireStation(multipartFile);
                    break;
                case ExcelEnums.XFRY:
                    excelImportFirefighters(multipartFile);
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    private void excelImportFirefighters(MultipartFile multipartFile) throws Exception {
        List<FirefightersExcelDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
                FirefightersExcelDto.class, 1);
        excelDtoList.forEach(
                item -> {
                    Firefighters firefighters = new Firefighters();
                    FirefightersContacts firefightersContacts = new FirefightersContacts();
                    firefighters = Bean.toPo(item, firefighters);
                    firefightersContacts = Bean.toPo(item, firefightersContacts);
                    if (item.getFireTeam() != null) {
                        Long fireTeamId = Long.valueOf(item.getFireTeam().split("@")[1]);
                        firefighters.setFireTeamId(fireTeamId);
                    }
                    if (firefighters.getCertificatesType() != null) {
                        String[] certificates = firefighters.getCertificatesType().split("@");
                        firefighters.setCertificatesType(certificates[0]);
                        firefighters.setCertificatesTypeCode(certificates[1]);
                    }
                    if (firefighters.getState() != null) {
                        String[] state = firefighters.getState().split("@");
                        firefighters.setState(state[0]);
                        firefighters.setStateCode(state[1]);
                    }
                    if (firefighters.getJobTitle() != null) {
                        String[] jobTitle = firefighters.getJobTitle().split("@");
                        firefighters.setJobTitle(jobTitle[0]);
                        firefighters.setJobTitleCode(jobTitle[1]);
                    }
                    if (firefightersContacts.getRelationship() != null) {
                        String relationship = firefightersContacts.getRelationship().split("@")[1];
                        firefightersContacts.setRelationship(relationship);
                    }
                    FirefightersInfoDto firefightersInfo = new FirefightersInfoDto(firefighters, firefightersContacts);
                    firefightersService.saveFirefighters(firefightersInfo);
                }
        );
    }

    private void excelImportFireStation(MultipartFile multipartFile) throws Exception {
        List<FireStationDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, FireStationDto.class, 1);
        List<FireStation> excelEntityList = new ArrayList<>();
        excelDtoList.forEach(
                item -> {
                    FireStation fireStation = new FireStation();
                    fireStation = Bean.toPo(item, fireStation);
                    if (fireStation.getWhereBuilding() != null) {
                        String[] whereBuilding = fireStation.getWhereBuilding().split("@");
                        fireStation.setWhereBuilding(whereBuilding[0]);
                        fireStation.setWhereBuildingId(whereBuilding[1]);
                    }
                    if (fireStation.getBizCompany() != null) {
                        String[] bizCompany = fireStation.getBizCompany().split("@");
                        fireStation.setBizCompany(bizCompany[0]);
                        fireStation.setBizCompanyId(Long.valueOf(bizCompany[1]));
                        fireStation.setBizCompanyCode(bizCompany[2]);
                    }
                    excelEntityList.add(fireStation);
                }
        );
        fireStationService.saveBatch(excelEntityList);
    }

    private void excelImportFireTeam(MultipartFile multipartFile) throws Exception {
        List<FireTeamDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, FireTeamDto.class, 1);
        List<FireTeam> excelEntityList = new ArrayList<>();
        excelDtoList.forEach(
                item -> {
                    FireTeam fireTeam = new FireTeam();
                    fireTeam = Bean.toPo(item, fireTeam);
                    if (fireTeam.getType() != null) {
                        String[] type = fireTeam.getType().split("@");
                        fireTeam.setType(type[0]);
                        fireTeam.setTypeCode(type[1]);
                    }
                    if (fireTeam.getContactUser() != null) {
                        String[] contactUser = fireTeam.getContactUser().split("@");
                        fireTeam.setContactUser(contactUser[0]);
                        fireTeam.setContactUserId(Long.valueOf(contactUser[1]));
                    }
                    if (item.getParentName() != null) {
                        String[] parentName = item.getParentName().split("@");
                        fireTeam.setParent(Long.valueOf(parentName[1]));
                    }
                    excelEntityList.add(fireTeam);
                }
        );
        fireTeamService.saveBatch(excelEntityList);
    }

    private void excelImportAircraft(MultipartFile multipartFile) throws Exception {
        List<AircraftDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, AircraftDto.class, 1);
        List<Aircraft> excelEntityList = new ArrayList<>();
        excelDtoList.forEach(
                item -> {
                    Aircraft aircraft = new Aircraft();
                    aircraft = Bean.toPo(item, aircraft);
                    if (aircraft.getEngineType() != null) {
                        String[] engineType = aircraft.getEngineType().split("@");
                        aircraft.setEngineType(engineType[0]);
                        aircraft.setEngineTypeCode(engineType[1]);
                    }
                    if (aircraft.getFuelType() != null) {
                        String[] fuelType = aircraft.getFuelType().split("@");
                        aircraft.setFuelType(fuelType[0]);
                        aircraft.setFuelTypeCode(fuelType[1]);
                    }
                    excelEntityList.add(aircraft);
                }
        );
        aircraftServiceImpl.saveBatch(excelEntityList);
    }

    private void excelImportFireChemical(MultipartFile multipartFile) throws Exception {
        List<FireChemicalDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, FireChemicalDto.class, 1);
        List<FireChemical> excelEntityList = new ArrayList<>();
        excelDtoList.forEach(
                item -> {
                    FireChemical fireChemical = new FireChemical();
                    fireChemical = Bean.toPo(item, fireChemical);
                    if (fireChemical.getType() != null) {
                        String[] type = fireChemical.getType().split("@");
                        fireChemical.setType(type[0]);
                        fireChemical.setTypeCode(type[1]);
                    }
                    excelEntityList.add(fireChemical);
                }
        );
        fireChemicalServiceImpl.saveBatch(excelEntityList);
    }

    private void excelImportWaterResource(MultipartFile multipartFile) throws Exception {
        List<WaterResourceDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
                WaterResourceDto.class, 1);
        excelDtoList.forEach(
                item -> {
                    if (item.getResourceTypeName() != null) {
                        String[] resourceTypeName = item.getResourceTypeName().split("@");
                        item.setResourceTypeName(resourceTypeName[0]);
                        item.setResourceType(resourceTypeName[1]);
                    }
                    if (item.getSystemType() != null) {
                        String[] systemType = item.getSystemType().split("@");
                        item.setSystemType(systemType[0]);
                        item.setSystemTypeCode(systemType[1]);
                    }
                    if (item.getPlaceForm() != null) {
                        String[] placeForm = item.getPlaceForm().split("@");
                        item.setPlaceForm(placeForm[0]);
                        item.setPlaceFormCode(placeForm[1]);
                    }
                    if (item.getBelongBuilding() != null) {
                        String[] belongBuilding = item.getBelongBuilding().split("@");
                        item.setBelongBuilding(belongBuilding[0]);
                        item.setBelongBuildingId(Long.valueOf(belongBuilding[1]));
                    }
                    if (item.getBelongFightingSystem() != null) {
                        String[] belongFightingSystem = item.getBelongFightingSystem().split("@");
                        item.setBelongFightingSystem(belongFightingSystem[0]);
                        item.setBelongFightingSystemId(Long.valueOf(belongFightingSystem[1]));
                    }
                    if (item.getManagementUnit() != null) {
                        String[] managementUnit = item.getManagementUnit().split("@");
                        item.setManagementUnit(managementUnit[0]);
                        item.setManagementUnitId(Long.valueOf(managementUnit[1]));
                    }
                    if (item.getMaintenanceUnit() != null) {
                        String[] maintenanceUnit = item.getMaintenanceUnit().split("@");
                        item.setMaintenanceUnit(maintenanceUnit[0]);
                        item.setMaintenanceUnitId(Long.valueOf(maintenanceUnit[1]));
                    }
                    if (item.getHoseConnection() != null) {
                        String[] hoseConnection = item.getHoseConnection().split("@");
                        item.setHoseConnection(hoseConnection[0]);
                        item.setHoseConnectionCode(hoseConnection[1]);
                    }
                    if (item.getIntakeForm() != null) {
                        String[] intakeForm = item.getIntakeForm().split("@");
                        item.setIntakeForm(intakeForm[0]);
                    }
                    if (item.getPipeTypeName() != null) {
                        String[] pipeTypeName = item.getPipeTypeName().split("@");
                        item.setPipeTypeName(pipeTypeName[0]);
                        item.setPipeTypeCode(pipeTypeName[1]);
                    }
                    if (item.getStatus() != null) {
                        String[] status = item.getStatus().split("@");
                        item.setStatus(status[0]);
                        item.setStatusCode(status[1]);
                    }
                    if (item.getType() != null) {
                        String[] type = item.getType().split("@");
                        item.setType(type[0]);
                        item.setTypeCode(type[1]);
                    }
                    waterResourceServiceImpl.importByExcel(item);
                }
        );
    }

    private void excelImportFireExperts(MultipartFile multipartFile) throws Exception {
        List<FireExpertsDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
                FireExpertsDto.class, 1);
        List<FireExperts> excelEntityList = new ArrayList<>();
        excelDtoList.forEach(
                fireExpertsDto -> {
                    FireExperts fireExperts = new FireExperts();
                    fireExperts = Bean.toPo(fireExpertsDto, fireExperts);
                    if (fireExperts.getCertificatesType() != null) {
                        String[] certificates = fireExperts.getCertificatesType().split("@");
                        fireExperts.setCertificatesType(certificates[0]);
                        fireExperts.setCertificatesTypeCode(certificates[1]);
                    }
                    if (fireExperts.getJobs() != null) {
                        String[] jobs = fireExperts.getJobs().split("@");
                        fireExperts.setJobs(jobs[0]);
                        fireExperts.setJobsCode(jobs[1]);
                    }
                    if (fireExperts.getExpert() != null) {
                        String[] expert = fireExperts.getExpert().split("@");
                        fireExperts.setExpert(expert[0]);
                        fireExperts.setExpertCode(expert[1]);
                    }
                    if (fireExperts.getHighestEducation() != null) {
                        String[] highestEducation = fireExperts.getHighestEducation().split("@");
                        fireExperts.setHighestEducation(highestEducation[0]);
                    }
                    excelEntityList.add(fireExperts);
                }
        );
        fireExpertsServiceImpl.saveBatch(excelEntityList);
    }


}
