package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledObjsDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertStageEnums;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertCalledMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertCalledService;

/**
* 警情接警记录 服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertCalledServiceImpl extends BaseService<AlertCalledDto,AlertCalled,AlertCalledMapper> implements IAlertCalledService {

	 @Autowired
	 RedisUtils redisUtils;
	 @Resource
	 AlertCalledMapper alertCalledMapper;
	 
	@Autowired
	private AlertFormValueServiceImpl iAlertFormValueService;
	    
    @Autowired
    private ESAlertCalledService eSAlertCalledService;
	    
    @Autowired
    RuleAlertCalledService ruleAlertCalledService;
	/**
	 * 
	 * <pre>
	 * 保存警情信息
	 * </pre>
	 *
	 * @param alertCalledVo
	 * @return
	 */
    @Transactional
	 public AlertCalledObjsDto createAlertCalled(AlertCalledObjsDto alertCalledObjsDto)  {
		try {
   	    // 警情基本信息
         AlertCalled alertCalled = alertCalledObjsDto.getAlertCalled();
         alertCalled.setCallTime(new Date());  
 		   if(AlertStageEnums.RG.getValue().equals(alertCalled.getAlertSourceCode())||
			AlertStageEnums.RG.getValue().equals(alertCalled.getAlertSourceCode())){
			   alertCalled.setType("0");
		   }else {
			   alertCalled.setType("1");
		   }
         
         // 判断是否归并警情
         if (alertCalled.getFatherAlert() != null) {
             // 警情归并，设置当前警情状态为结束。
             alertCalled.setAlertStatus(true);
             alertCalled.setAlertStage(AlertStageEnums.JQJB.getValue());
             alertCalled.setAlarmType(AlertStageEnums.JQGB.getValue());
             alertCalled.setAlarmTypeCode(AlertStageEnums.JQGB.getCode());
             this.save(alertCalled);
             // 动态表单
             List<AlertFormValue> alertFormValuelist = alertCalledObjsDto.getAlertFormValue();
             // 填充警情主键
                 alertFormValuelist.stream().forEach(alertFormValue -> {
                 alertFormValue.setAlertCalledId(alertCalled.getSequenceNbr());
                 alertFormValue.setAlertTypeCode(alertCalled.getAlertTypeCode());
             });
             // 保存动态表单数据
             iAlertFormValueService.saveBatch(alertFormValuelist);
         } else {
             // 警情报送
             // ****************************************************待确认开发
        	  alertCalled.setAlertStatus(false);
        	  alertCalled.setIsDelete(false);
        	  alertCalled.setAlertStage(AlertStageEnums.LLDP.getValue());
        	  alertCalled.setAlarmType(AlertStageEnums.JQCB.getValue());
              alertCalled.setAlarmTypeCode(AlertStageEnums.JQCB.getCode());
              this.save(alertCalled);

              // 动态表单
              List<AlertFormValue> alertFormValuelist = alertCalledObjsDto.getAlertFormValue();
              // 填充警情主键
                  alertFormValuelist.stream().forEach(alertFormValue -> {
                  alertFormValue.setAlertCalledId(alertCalled.getSequenceNbr());
                  alertFormValue.setAlertTypeCode(alertCalled.getAlertTypeCode());
              });
              // 保存动态表单数据
              iAlertFormValueService.saveBatch(alertFormValuelist);
              alertCalledObjsDto.setAlertCalled(alertCalled);
              alertCalledObjsDto.setAlertFormValue(alertFormValuelist);
              //调用规则          
              ruleAlertCalledService.fireAlertCalledRule(alertCalledObjsDto);
         }
        
         
         /**
          * 同步保存ES
          */
         eSAlertCalledService.saveAlertCalledToES(alertCalled);
         
		 return alertCalledObjsDto;
		} catch (Exception e) {
			throw new RuntimeException("报送失败，系统异常!");
		}
	 }
		 
		 
	 /*
	  * 根据id 修改警情
	  * type：警情相关 操作类型  0警情续报   1非警情确认   2 警情结案
	  * */
	@Override
	@Transactional
	public boolean updateAlertCalled(Long id, String code)  {
		// TODO Auto-generated method stub
		try {
			switch (code) {
			case "314":
				alertCalledMapper.update(null, new UpdateWrapper<AlertCalled>().eq("sequence_nbr", id)
						.set("alert_status", 1).set("alert_stage", AlertStageEnums.ZBQJ.getValue()).set("alarm_type", AlertStageEnums.FJQ.getValue()).set("alarm_type_code", AlertStageEnums.FJQ.getCode()) );  
				break;
	        case "315":
	        	alertCalledMapper.update(null, new UpdateWrapper<AlertCalled>().eq("sequence_nbr", id)
						.set("alert_status", 1).set("alert_stage", AlertStageEnums.CZJS.getValue()) );  
				break;
			default:
				alertCalledMapper.update(null, new UpdateWrapper<AlertCalled>().eq("sequence_nbr", id)
						.set("alert_stage", AlertStageEnums.CZGZ.getValue()));  
				
				break;
			}	
			
			  AlertCalled alertCalled =this.getById(id);
			//删除缓存
	        redisUtils.del(RedisKey.ALERTCALLED_ID+id);	        
	        /**
	          * 同步更新存ES
	          */
	        eSAlertCalledService.saveAlertCalledToES(alertCalled);
			return true;
		} catch (Exception e) {
			throw new RuntimeException("系统异常!");
		}
	}

	
	
}
